/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.selection;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;
import org.pepsoft.worldpainter.selection.SelectionOptions;

public class SelectionHelper {
    private final Dimension dimension;
    private SelectionOptions options;
    private boolean clearUndoOnNewTileCreation;
    private static final double DISTANCE_TO_BLEND = 5.092958178940651;
    private static final Random RANDOM = new Random();
    private static final Set<Layer> SKIP_LAYERS = new HashSet<Layer>(Arrays.asList(Biome.INSTANCE, SelectionChunk.INSTANCE, SelectionBlock.INSTANCE, NotPresent.INSTANCE, NotPresentBlock.INSTANCE, Annotations.INSTANCE, FloodWithLava.INSTANCE));

    public SelectionHelper(Dimension dimension) {
        this.dimension = dimension;
    }

    public void addToSelection(Shape shape) {
        this.editSelection(shape, true);
    }

    public void addToSelection(int x, int y, Brush brush, Filter filter, float dynamicLevel, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        boolean brushSpecified = brush != null;
        boolean filterSpecified = filter != null;
        boolean[][] blocksSet = new boolean[16][16];
        this.dimension.visitTilesForEditing().forFilter(filter).forBrush(brush, x, y).andDo(tile -> {
            boolean tileHasChunkSelection = tile.hasLayer((Layer)SelectionChunk.INSTANCE);
            if (!brushSpecified && !filterSpecified) {
                tile.clearLayerData((Layer)SelectionBlock.INSTANCE);
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        if (tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) continue;
                        tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, true);
                    }
                }
            } else {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                boolean tileHasBlockSelection = tile.hasLayer((Layer)SelectionBlock.INSTANCE);
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; !(chunkY >= 128 || tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)); chunkY += 16) {
                        int yInChunk;
                        int xInChunk;
                        boolean chunkEntirelySelected = true;
                        boolean noSelection = true;
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                boolean select;
                                float strength;
                                int worldX = worldTileX | chunkX | xInChunk;
                                int worldY = worldTileY | chunkY | yInChunk;
                                float f = strength = brushSpecified ? brush.getStrength(x - worldX, y - worldY) * dynamicLevel : dynamicLevel;
                                if (filterSpecified) {
                                    strength = filter.modifyStrength(worldX, worldY, strength);
                                }
                                blocksSet[xInChunk][yInChunk] = select = strength > 0.95f || Math.random() < (double)strength;
                                if (!select) {
                                    chunkEntirelySelected = false;
                                    continue;
                                }
                                noSelection = false;
                            }
                        }
                        if (noSelection) continue;
                        if (chunkEntirelySelected) {
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, true);
                            if (!tileHasBlockSelection) continue;
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                                }
                            }
                            continue;
                        }
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                if (!blocksSet[xInChunk][yInChunk]) continue;
                                tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, true);
                            }
                        }
                    }
                }
            }
        }, progressReceiver);
    }

    public void removeFromSelection(Shape shape) {
        this.editSelection(shape, false);
    }

    public void removeFromSelection(int x, int y, Brush brush, Filter filter, float dynamicLevel, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        boolean brushSpecified = brush != null;
        boolean filterSpecified = filter != null;
        boolean[][] blocksDeselected = new boolean[16][16];
        if (!brushSpecified && !filterSpecified) {
            this.dimension.clearLayerData((Layer)SelectionChunk.INSTANCE);
            this.dimension.clearLayerData((Layer)SelectionBlock.INSTANCE);
        } else {
            this.dimension.visitTilesForEditing().forSelection().forFilter(filter).forBrush(brush, x, y).andDo(tile -> {
                boolean tileHasChunkSelection = tile.hasLayer((Layer)SelectionChunk.INSTANCE);
                boolean tileHasBlockSelection = tile.hasLayer((Layer)SelectionBlock.INSTANCE);
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        int yInChunk;
                        int xInChunk;
                        boolean chunkEntirelyDeselected = true;
                        boolean noDeselection = true;
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                boolean deselect;
                                float strength;
                                int worldX = worldTileX | chunkX | xInChunk;
                                int worldY = worldTileY | chunkY | yInChunk;
                                float f = strength = brushSpecified ? brush.getStrength(x - worldX, y - worldY) * dynamicLevel : dynamicLevel;
                                if (filterSpecified) {
                                    strength = filter.modifyStrength(worldX, worldY, strength);
                                }
                                blocksDeselected[xInChunk][yInChunk] = deselect = strength > 0.95f || Math.random() < (double)strength;
                                if (!deselect) {
                                    chunkEntirelyDeselected = false;
                                    continue;
                                }
                                noDeselection = false;
                            }
                        }
                        if (noDeselection) continue;
                        if (chunkEntirelyDeselected) {
                            if (tileHasChunkSelection) {
                                tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            }
                            if (!tileHasBlockSelection) continue;
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                                }
                            }
                            continue;
                        }
                        if (tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) {
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    if (blocksDeselected[xInChunk][yInChunk]) continue;
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, true);
                                }
                            }
                            continue;
                        }
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                if (!blocksDeselected[xInChunk][yInChunk]) continue;
                                tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                            }
                        }
                    }
                }
            }, progressReceiver);
        }
    }

    public Rectangle getSelectionBounds() {
        int[] lowestX = new int[]{Integer.MAX_VALUE};
        int[] highestX = new int[]{Integer.MIN_VALUE};
        int[] lowestY = new int[]{Integer.MAX_VALUE};
        int[] highestY = new int[]{Integer.MIN_VALUE};
        this.dimension.visitTiles().forSelection().andDo(tile -> {
            int tileX = tile.getX();
            int tileY = tile.getY();
            if (tileX << 7 >= lowestX[0] && tileX + 1 << 7 < highestX[0] && tileY << 7 >= lowestY[0] && tileY + 1 << 7 < highestY[0]) {
                return;
            }
            boolean tileHasChunkSelection = tile.hasLayer((Layer)SelectionChunk.INSTANCE);
            boolean tileHasBlockSelection = tile.hasLayer((Layer)SelectionBlock.INSTANCE);
            for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                    if (tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) {
                        int x1 = tileX << 7 | chunkX;
                        int x2 = x1 + 15;
                        int y1 = tileY << 7 | chunkY;
                        int y2 = y1 + 15;
                        if (x1 < lowestX[0]) {
                            lowestX[0] = x1;
                        }
                        if (x2 > highestX[0]) {
                            highestX[0] = x2;
                        }
                        if (y1 < lowestY[0]) {
                            lowestY[0] = y1;
                        }
                        if (y2 <= highestY[0]) continue;
                        highestY[0] = y2;
                        continue;
                    }
                    if (!tileHasBlockSelection) continue;
                    for (int dx = 0; dx < 16; ++dx) {
                        for (int dy = 0; dy < 16; ++dy) {
                            if (!tile.getBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX + dx, chunkY + dy)) continue;
                            int x = (tileX << 7 | chunkX) + dx;
                            int y = (tileY << 7 | chunkY) + dy;
                            if (x < lowestX[0]) {
                                lowestX[0] = x;
                            }
                            if (x > highestX[0]) {
                                highestX[0] = x;
                            }
                            if (y < lowestY[0]) {
                                lowestY[0] = y;
                            }
                            if (y <= highestY[0]) continue;
                            highestY[0] = y;
                        }
                    }
                }
            }
        });
        if (lowestX[0] != Integer.MAX_VALUE) {
            return new Rectangle(lowestX[0], lowestY[0], highestX[0] - lowestX[0] + 1, highestY[0] - lowestY[0] + 1);
        }
        return null;
    }

    public void copySelection(int targetX, int targetY, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Rectangle bounds = this.getSelectionBounds();
        if (bounds == null) {
            return;
        }
        int dx = targetX - bounds.x;
        int dy = targetY - bounds.y;
        if (dx == 0 && dy == 0) {
            return;
        }
        int tileX1 = bounds.x >> 7;
        int tileX2 = bounds.x + bounds.width - 1 >> 7;
        int tileY1 = bounds.y >> 7;
        int tileY2 = bounds.y + bounds.height - 1 >> 7;
        this.clearUndoOnNewTileCreation = this.options.createNewTiles;
        if (dx > 0) {
            if (dy > 0) {
                for (int tileX = tileX2; tileX >= tileX1; --tileX) {
                    for (int tileY = tileY2; tileY >= tileY1; --tileY) {
                        Tile tile = this.dimension.getTile(tileX, tileY);
                        if (tile == null) continue;
                        for (int xInTile = 127; xInTile >= 0; --xInTile) {
                            for (int yInTile = 127; yInTile >= 0; --yInTile) {
                                this.processColumn(tile, xInTile, yInTile, dx, dy);
                            }
                        }
                    }
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)(tileX2 - tileX + 1) / (float)(tileX2 - tileX1 + 1));
                }
            } else {
                for (int tileX = tileX2; tileX >= tileX1; --tileX) {
                    for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                        Tile tile = this.dimension.getTile(tileX, tileY);
                        if (tile == null) continue;
                        for (int xInTile = 127; xInTile >= 0; --xInTile) {
                            for (int yInTile = 0; yInTile < 128; ++yInTile) {
                                this.processColumn(tile, xInTile, yInTile, dx, dy);
                            }
                        }
                    }
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)(tileX2 - tileX + 1) / (float)(tileX2 - tileX1 + 1));
                }
            }
        } else if (dy > 0) {
            for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
                for (int tileY = tileY2; tileY >= tileY1; --tileY) {
                    Tile tile = this.dimension.getTile(tileX, tileY);
                    if (tile == null) continue;
                    for (int xInTile = 0; xInTile < 128; ++xInTile) {
                        for (int yInTile = 127; yInTile >= 0; --yInTile) {
                            this.processColumn(tile, xInTile, yInTile, dx, dy);
                        }
                    }
                }
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)(tileX - tileX1 + 1) / (float)(tileX2 - tileX1 + 1));
            }
        } else {
            for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
                for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                    Tile tile = this.dimension.getTile(tileX, tileY);
                    if (tile == null) continue;
                    for (int xInTile = 0; xInTile < 128; ++xInTile) {
                        for (int yInTile = 0; yInTile < 128; ++yInTile) {
                            this.processColumn(tile, xInTile, yInTile, dx, dy);
                        }
                    }
                }
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)(tileX - tileX1 + 1) / (float)(tileX2 - tileX1 + 1));
            }
        }
    }

    public void clearSelection() {
        this.dimension.clearLayerData((Layer)SelectionChunk.INSTANCE);
        this.dimension.clearLayerData((Layer)SelectionBlock.INSTANCE);
    }

    public SelectionOptions getOptions() {
        return this.options;
    }

    public void setOptions(SelectionOptions options) {
        this.options = options;
    }

    private void processColumn(Tile tile, int xInTile, int yInTile, int dx, int dy) {
        if (tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, xInTile, yInTile) || tile.getBitLayerValue((Layer)SelectionBlock.INSTANCE, xInTile, yInTile)) {
            int srcX = tile.getX() << 7 | xInTile;
            int srcY = tile.getY() << 7 | yInTile;
            int dstX = srcX + dx;
            int dstY = srcY + dy;
            if (this.options.createNewTiles && !this.dimension.isTilePresent(dstX >> 7, dstY >> 7)) {
                if (this.clearUndoOnNewTileCreation) {
                    this.dimension.clearUndo();
                    this.clearUndoOnNewTileCreation = false;
                }
                this.dimension.addTile(this.dimension.getTileFactory().createTile(dstX >> 7, dstY >> 7));
            }
            if (this.options.doBlending) {
                float distanceFromEdge = this.distanceToSelectionEdge(srcX, srcY);
                if (distanceFromEdge < 16.0f) {
                    float blend = (float)(-Math.cos((double)distanceFromEdge / 5.092958178940651) / 2.0 + 0.5);
                    this.copyColumn(tile, xInTile, yInTile, dstX, dstY, blend);
                } else {
                    this.copyColumn(tile, xInTile, yInTile, dstX, dstY);
                }
            } else {
                this.copyColumn(tile, xInTile, yInTile, dstX, dstY);
            }
        }
    }

    private void copyColumn(Tile srcTile, int srcXInTile, int srcYInTile, int dstX, int dstY) {
        if (this.options.copyHeights) {
            this.dimension.setRawHeightAt(dstX, dstY, srcTile.getRawHeight(srcXInTile, srcYInTile));
        }
        if (this.options.copyTerrain) {
            this.dimension.setTerrainAt(dstX, dstY, srcTile.getTerrain(srcXInTile, srcYInTile));
        }
        if (this.options.copyFluids) {
            this.dimension.setWaterLevelAt(dstX, dstY, srcTile.getWaterLevel(srcXInTile, srcYInTile));
            this.dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, dstX, dstY, srcTile.getBitLayerValue((Layer)FloodWithLava.INSTANCE, srcXInTile, srcYInTile));
        }
        if (this.options.copyLayers) {
            if (this.options.removeExistingLayers) {
                this.dimension.clearLayerData(dstX, dstY, SKIP_LAYERS);
            }
            Map layerValues = srcTile.getLayersAt(srcXInTile, srcYInTile);
            layerValues.forEach((layer, value) -> {
                if (SKIP_LAYERS.contains(layer)) {
                    return;
                }
                switch (layer.getDataSize()) {
                    case BIT_PER_CHUNK: 
                    case BIT: {
                        this.dimension.setBitLayerValueAt(layer, dstX, dstY, value != 0);
                        break;
                    }
                    case BYTE: 
                    case NIBBLE: {
                        this.dimension.setLayerValueAt(layer, dstX, dstY, value.intValue());
                        break;
                    }
                    case NONE: {
                        throw new UnsupportedOperationException("Don't know how to copy layer " + layer);
                    }
                }
            });
        }
        if (this.options.copyAnnotations) {
            this.dimension.setLayerValueAt((Layer)Annotations.INSTANCE, dstX, dstY, srcTile.getLayerValue((Layer)Annotations.INSTANCE, srcXInTile, srcYInTile));
        }
        if (this.options.copyBiomes) {
            this.dimension.setLayerValueAt((Layer)Biome.INSTANCE, dstX, dstY, srcTile.getLayerValue((Layer)Biome.INSTANCE, srcXInTile, srcYInTile));
        }
    }

    private void copyColumn(Tile srcTile, int srcXInTile, int srcYInTile, int dstX, int dstY, float blend) {
        if (this.options.copyHeights) {
            this.dimension.setRawHeightAt(dstX, dstY, Math.round(blend * (float)srcTile.getRawHeight(srcXInTile, srcYInTile) + (1.0f - blend) * (float)this.dimension.getRawHeightAt(dstX, dstY)));
        }
        if (this.options.copyTerrain && RANDOM.nextFloat() <= blend) {
            this.dimension.setTerrainAt(dstX, dstY, srcTile.getTerrain(srcXInTile, srcYInTile));
        }
        if (this.options.copyFluids) {
            this.dimension.setWaterLevelAt(dstX, dstY, Math.round(blend * (float)srcTile.getWaterLevel(srcXInTile, srcYInTile) + (1.0f - blend) * (float)this.dimension.getWaterLevelAt(dstX, dstY)));
            if (RANDOM.nextFloat() <= blend) {
                this.dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, dstX, dstY, srcTile.getBitLayerValue((Layer)FloodWithLava.INSTANCE, srcXInTile, srcYInTile));
            }
        }
        if (this.options.copyLayers) {
            if (this.options.removeExistingLayers && RANDOM.nextFloat() <= blend) {
                this.dimension.clearLayerData(dstX, dstY, SKIP_LAYERS);
            }
            Map layerValues = srcTile.getLayersAt(srcXInTile, srcYInTile);
            layerValues.forEach((layer, value) -> {
                if (SKIP_LAYERS.contains(layer)) {
                    return;
                }
                switch (layer.getDataSize()) {
                    case BIT_PER_CHUNK: 
                    case BIT: {
                        if (!(RANDOM.nextFloat() <= blend)) break;
                        this.dimension.setBitLayerValueAt(layer, dstX, dstY, value != 0);
                        break;
                    }
                    case BYTE: 
                    case NIBBLE: {
                        this.dimension.setLayerValueAt(layer, dstX, dstY, Math.round(blend * (float)value.intValue() + (1.0f - blend) * (float)this.dimension.getLayerValueAt(layer, dstX, dstY)));
                        break;
                    }
                    case NONE: {
                        throw new UnsupportedOperationException("Don't know how to copy layer " + layer);
                    }
                }
            });
        }
        if (this.options.copyAnnotations && RANDOM.nextFloat() <= blend) {
            this.dimension.setLayerValueAt((Layer)Annotations.INSTANCE, dstX, dstY, srcTile.getLayerValue((Layer)Annotations.INSTANCE, srcXInTile, srcYInTile));
        }
        if (this.options.copyBiomes && RANDOM.nextFloat() <= blend) {
            this.dimension.setLayerValueAt((Layer)Biome.INSTANCE, dstX, dstY, srcTile.getLayerValue((Layer)Biome.INSTANCE, srcXInTile, srcYInTile));
        }
    }

    private float distanceToSelectionEdge(int x, int y) {
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        boolean nonSelectedChunkFound = false;
        block0: for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (this.dimension.getBitLayerValueAt((Layer)SelectionChunk.INSTANCE, chunkX + dx << 4, chunkY + dy << 4)) continue;
                nonSelectedChunkFound = true;
                break block0;
            }
        }
        if (!nonSelectedChunkFound) {
            return 16.0f;
        }
        if (!this.dimension.getBitLayerValueAt((Layer)SelectionChunk.INSTANCE, x, y) && !this.dimension.getBitLayerValueAt((Layer)SelectionBlock.INSTANCE, x, y)) {
            return 0.0f;
        }
        float distance = 16.0f;
        block2: for (int i = 1; i <= 16; ++i) {
            if (!(this.isSelected(x - i, y) && this.isSelected(x + i, y) && this.isSelected(x, y - i) && this.isSelected(x, y + i) || !((float)i < distance))) {
                return i;
            }
            for (int d = 1; d <= i; ++d) {
                if (this.isSelected(x - i, y - d) && this.isSelected(x + d, y - i) && this.isSelected(x + i, y + d) && this.isSelected(x - d, y + i) && (d >= i || this.isSelected(x - i, y + d) && this.isSelected(x - d, y - i) && this.isSelected(x + i, y - d) && this.isSelected(x + d, y + i))) continue;
                float tDistance = MathUtils.getDistance((int)i, (int)d);
                if (!(tDistance < distance)) continue block2;
                distance = tDistance;
                continue block2;
            }
        }
        return distance;
    }

    private boolean isSelected(int x, int y) {
        return this.dimension.getBitLayerValueAt((Layer)SelectionChunk.INSTANCE, x, y) || this.dimension.getBitLayerValueAt((Layer)SelectionBlock.INSTANCE, x, y);
    }

    private void editSelection(Shape shape, boolean add) {
        Rectangle shapeBounds = shape.getBounds();
        int tileX1 = shapeBounds.x >> 7;
        int tileX2 = shapeBounds.x + shapeBounds.width - 1 >> 7;
        int tileY1 = shapeBounds.y >> 7;
        int tileY2 = shapeBounds.y + shapeBounds.height - 1 >> 7;
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = this.dimension.getTileForEditing(tileX, tileY);
                if (tile == null) continue;
                Rectangle tileBounds = new Rectangle(tileX << 7, tileY << 7, 128, 128);
                if (shape.contains(tileBounds)) {
                    if (add) {
                        tile.clearLayerData((Layer)SelectionBlock.INSTANCE);
                        this.fillTile(tile, (Layer)SelectionChunk.INSTANCE);
                        continue;
                    }
                    tile.clearLayerData((Layer)SelectionBlock.INSTANCE);
                    tile.clearLayerData((Layer)SelectionChunk.INSTANCE);
                    continue;
                }
                if (!shape.intersects(tileBounds)) continue;
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        int blockY;
                        int blockX;
                        int dy;
                        int dx;
                        Rectangle chunkBounds = new Rectangle(tileBounds.x + chunkX, tileBounds.y + chunkY, 16, 16);
                        if (shape.contains(chunkBounds)) {
                            if (add) {
                                this.clearTile(tile, (Layer)SelectionBlock.INSTANCE, chunkX, chunkY, 16, 16);
                                tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, true);
                                continue;
                            }
                            this.clearTile(tile, (Layer)SelectionBlock.INSTANCE, chunkX, chunkY, 16, 16);
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            continue;
                        }
                        if (!shape.intersects(chunkBounds)) continue;
                        if (add && !tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) {
                            for (dx = 0; dx < 16; ++dx) {
                                for (dy = 0; dy < 16; ++dy) {
                                    blockX = chunkBounds.x + dx;
                                    blockY = chunkBounds.y + dy;
                                    if (!shape.contains(blockX, blockY)) continue;
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX + dx, chunkY + dy, true);
                                }
                            }
                            continue;
                        }
                        if (add) continue;
                        if (tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) {
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            for (dx = 0; dx < 16; ++dx) {
                                for (dy = 0; dy < 16; ++dy) {
                                    blockX = chunkBounds.x + dx;
                                    blockY = chunkBounds.y + dy;
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX + dx, chunkY + dy, !shape.contains(blockX, blockY));
                                }
                            }
                            continue;
                        }
                        for (dx = 0; dx < 16; ++dx) {
                            for (dy = 0; dy < 16; ++dy) {
                                blockX = chunkBounds.x + dx;
                                blockY = chunkBounds.y + dy;
                                if (!shape.contains(blockX, blockY)) continue;
                                tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX + dx, chunkY + dy, false);
                            }
                        }
                    }
                }
            }
        }
    }

    private void fillTile(Tile tile, Layer layer) {
        switch (layer.getDataSize()) {
            case BIT_PER_CHUNK: {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        tile.setBitLayerValue(layer, x, y, true);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Data size " + layer.getDataSize() + " not supported");
            }
        }
    }

    private void clearTile(Tile tile, Layer layer, int x, int y, int w, int h) {
        switch (layer.getDataSize()) {
            case BIT: {
                for (int dx = 0; dx < w; ++dx) {
                    for (int dy = 0; dy < h; ++dy) {
                        tile.setBitLayerValue(layer, x + dx, y + dy, false);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Data size " + layer.getDataSize() + " not supported");
            }
        }
    }
}

