/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.selection;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import javax.swing.JPanel;
import org.pepsoft.util.ObservableBoolean;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.brushes.RotatedBrush;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.selection.SelectionHelper;

public class EditSelectionOperation
extends AbstractBrushOperation {
    private final ObservableBoolean selectionState;
    private static final JPanel OPTIONS_PANEL = new StandardOptionsPanel("Edit Selection", "<ul><li>Left-click to add to the selection<li>Right-click to remove from the selection</ul>");
    private static final double DEGREES_TO_RADIANS = 57.29577951308232;

    public EditSelectionOperation(WorldPainterView view, ObservableBoolean selectionState) {
        super("Edit Selection", "Expand or shrink the selection", view, "operation.selection.edit", "edit_selection");
        this.selectionState = selectionState;
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Shape shape;
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        Brush brush = this.getBrush();
        int brushRadius = brush.getRadius();
        switch (brush.getBrushShape()) {
            case BITMAP: 
            case SQUARE: {
                int rotation;
                shape = new Rectangle(centreX - brushRadius, centreY - brushRadius, brushRadius * 2 + 1, brushRadius * 2 + 1);
                if (!(brush instanceof RotatedBrush) || (rotation = ((RotatedBrush)brush).getDegrees()) == 0) break;
                shape = new Path2D.Float(shape, AffineTransform.getRotateInstance((double)rotation / 57.29577951308232, centreX, centreY));
                break;
            }
            case CIRCLE: {
                shape = new Arc2D.Float(centreX - brushRadius, centreY - brushRadius, brushRadius * 2 + 1, brushRadius * 2 + 1, 0.0f, 360.0f, 1);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        dimension.setEventsInhibited(true);
        try {
            SelectionHelper selectionHelper = new SelectionHelper(dimension);
            if (inverse) {
                selectionHelper.removeFromSelection(shape);
            } else {
                selectionHelper.addToSelection(shape);
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

