/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.selection;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.selection.CopySelectionOperationOptions;
import org.pepsoft.worldpainter.selection.CopySelectionOperationOptionsPanel;
import org.pepsoft.worldpainter.selection.SelectionHelper;

public class CopySelectionOperation
extends MouseOrTabletOperation {
    private SelectionHelper selectionHelper;
    private final CopySelectionOperationOptions options = new CopySelectionOperationOptions();
    private final StandardOptionsPanel optionsPanel = new StandardOptionsPanel("Copy Selection", "<p>Click to copy the selected area to the indicated location. Choose below which aspects of the world to copy:"){

        @Override
        protected void addAdditionalComponents(GridBagConstraints constraints) {
            this.add((Component)new CopySelectionOperationOptionsPanel(CopySelectionOperation.this.options), constraints);
        }
    };

    public CopySelectionOperation(WorldPainterView view) {
        super("Copy Selection", "Copy the selection to another location", view, "operation.selection.copy", "copy_selection");
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    @Override
    protected void activate() throws PropertyVetoException {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            throw new PropertyVetoException("Dimension not set", null);
        }
        super.activate();
        this.selectionHelper = new SelectionHelper(dimension);
        WorldPainter view = (WorldPainter)this.getView();
        Rectangle bounds = this.selectionHelper.getSelectionBounds();
        if (bounds == null) {
            super.deactivate();
            throw new PropertyVetoException("No active selection", null);
        }
        bounds.translate(-bounds.x, -bounds.y);
        view.setCustomBrushShape(bounds);
        view.setBrushShape(BrushShape.CUSTOM);
        view.setDrawBrush(true);
    }

    @Override
    protected void deactivate() {
        this.getView().setDrawBrush(false);
        super.deactivate();
    }

    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        this.selectionHelper.setOptions(this.options);
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        dimension.setEventsInhibited(true);
        try {
            this.selectionHelper.copySelection(centreX, centreY, null);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError(e);
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

