/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.panels;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ObservableBoolean;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerManager;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.panels.CombinedFilter;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.panels.ExceptOnTerrainOrLayerFilter;
import org.pepsoft.worldpainter.panels.OnlyOnTerrainOrLayerFilter;
import org.pepsoft.worldpainter.panels.TerrainOrLayerFilter;
import org.pepsoft.worldpainter.tools.Eyedropper;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrushOptions
extends JPanel
implements Observer {
    private JButton buttonExceptOn;
    private JButton buttonReplace;
    private JCheckBox checkBoxAbove;
    private JCheckBox checkBoxAboveSlope;
    private JCheckBox checkBoxBelow;
    private JCheckBox checkBoxBelowSlope;
    private JCheckBox checkBoxExceptOn;
    private JCheckBox checkBoxFeather;
    private JCheckBox checkBoxInSelection;
    private JCheckBox checkBoxOutsideSelection;
    private JCheckBox checkBoxReplace;
    private JLabel jLabel1;
    private JSpinner spinnerAbove;
    private JSpinner spinnerBelow;
    private JSpinner spinnerSlope;
    private ColourScheme colourScheme;
    private CustomBiomeManager customBiomeManager;
    private Object onlyOn;
    private Object exceptOn;
    private Listener listener;
    private boolean initialised;
    private ObservableBoolean selectionState;
    private Platform platform;
    private MapSelectionListener mapSelectionListener;
    public static final String MENU_ONLY_ON = "onlyOn";
    public static final String MENU_EXCEPT_ON = "exceptOn";
    private static final Icon ICON_WATER = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/flood.png");
    private static final Icon ICON_LAVA = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/flood_with_lava.png");
    private static final Icon ICON_EYEDROPPER = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/eyedropper.png");
    private static final Icon ICON_PLUS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plus.png");
    private static final Logger logger = LoggerFactory.getLogger(BrushOptions.class);
    private static final long serialVersionUID = 1L;

    public BrushOptions() {
        this.initComponents();
        this.spinnerAbove.setEditor(new JSpinner.NumberEditor(this.spinnerAbove, "0"));
        this.spinnerBelow.setEditor(new JSpinner.NumberEditor(this.spinnerBelow, "0"));
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    public CustomBiomeManager getCustomBiomeManager() {
        return this.customBiomeManager;
    }

    public void setCustomBiomeManager(CustomBiomeManager customBiomeManager) {
        this.customBiomeManager = customBiomeManager;
    }

    public void setSelectionState(ObservableBoolean selectionState) {
        if (this.selectionState != null) {
            throw new IllegalStateException("selectionState already set");
        }
        this.selectionState = selectionState;
        selectionState.addObserver((Observer)this);
        this.checkBoxInSelection.setEnabled(selectionState.getValue());
        this.checkBoxOutsideSelection.setEnabled(selectionState.getValue());
    }

    public DefaultFilter getFilter() {
        if (this.checkBoxInSelection.isSelected() || this.checkBoxOutsideSelection.isSelected() || this.checkBoxAbove.isSelected() || this.checkBoxBelow.isSelected() || this.checkBoxReplace.isSelected() || this.onlyOn != null || this.checkBoxExceptOn.isSelected() || this.exceptOn != null || this.checkBoxAboveSlope.isSelected() || this.checkBoxBelowSlope.isSelected()) {
            return new DefaultFilter(App.getInstance().getDimension(), this.checkBoxInSelection.isSelected(), this.checkBoxOutsideSelection.isSelected(), this.checkBoxAbove.isSelected() ? (Integer)this.spinnerAbove.getValue() : Integer.MIN_VALUE, this.checkBoxBelow.isSelected() ? (Integer)this.spinnerBelow.getValue() : Integer.MIN_VALUE, this.checkBoxFeather.isSelected(), this.checkBoxReplace.isSelected(), this.onlyOn, this.checkBoxExceptOn.isSelected(), this.exceptOn, this.checkBoxAboveSlope.isSelected() || this.checkBoxBelowSlope.isSelected() ? (Integer)this.spinnerSlope.getValue() : -1, this.checkBoxAboveSlope.isSelected());
        }
        return null;
    }

    public void setFilter(DefaultFilter filter) {
        if (filter == null) {
            this.checkBoxInSelection.setSelected(false);
            this.checkBoxOutsideSelection.setSelected(false);
            this.checkBoxAbove.setSelected(false);
            this.checkBoxBelow.setSelected(false);
            this.checkBoxReplace.setSelected(false);
            this.checkBoxExceptOn.setSelected(false);
            this.checkBoxAboveSlope.setSelected(false);
            this.checkBoxBelowSlope.setSelected(false);
            this.exceptOn = null;
            this.onlyOn = null;
        } else {
            this.checkBoxInSelection.setSelected(filter.inSelection);
            this.checkBoxOutsideSelection.setSelected(filter.outsideSelection);
            this.checkBoxAbove.setSelected(filter.levelType == DefaultFilter.LevelType.ABOVE || filter.levelType == DefaultFilter.LevelType.BETWEEN || filter.levelType == DefaultFilter.LevelType.OUTSIDE);
            if (filter.aboveLevel != Integer.MIN_VALUE) {
                this.spinnerAbove.setValue(filter.aboveLevel);
            }
            this.checkBoxBelow.setSelected(filter.levelType == DefaultFilter.LevelType.BELOW || filter.levelType == DefaultFilter.LevelType.BETWEEN || filter.levelType == DefaultFilter.LevelType.OUTSIDE);
            if (filter.belowLevel != Integer.MIN_VALUE) {
                this.spinnerBelow.setValue(filter.belowLevel);
            }
            this.checkBoxAboveSlope.setSelected(filter.checkSlope && filter.slopeIsAbove);
            this.checkBoxBelowSlope.setSelected(filter.checkSlope && !filter.slopeIsAbove);
            if (filter.degrees >= 0) {
                this.spinnerSlope.setValue(filter.degrees);
            }
            this.checkBoxReplace.setSelected(filter.onlyOn);
            this.checkBoxExceptOn.setSelected(filter.exceptOn);
            App app = App.getInstance();
            if (filter.onlyOnFilter instanceof OnlyOnTerrainOrLayerFilter) {
                this.onlyOn = this.toPaint((TerrainOrLayerFilter)((OnlyOnTerrainOrLayerFilter)filter.onlyOnFilter));
            } else if (filter.onlyOnFilter instanceof CombinedFilter) {
                this.onlyOn = ((CombinedFilter)filter.onlyOnFilter).getFilters().stream().map(f -> this.toPaint((TerrainOrLayerFilter)((OnlyOnTerrainOrLayerFilter)f))).collect(Collectors.toCollection(ArrayList::new));
            } else if (filter.onlyOnFilter != null) {
                throw new UnsupportedOperationException("Unsupported onlyOn filter type " + filter.onlyOnFilter.getClass());
            }
            if (filter.exceptOnFilter instanceof ExceptOnTerrainOrLayerFilter) {
                this.exceptOn = this.toPaint((TerrainOrLayerFilter)((ExceptOnTerrainOrLayerFilter)filter.exceptOnFilter));
            } else if (filter.exceptOnFilter instanceof CombinedFilter) {
                this.exceptOn = ((CombinedFilter)filter.exceptOnFilter).getFilters().stream().map(f -> this.toPaint((TerrainOrLayerFilter)((ExceptOnTerrainOrLayerFilter)f))).collect(Collectors.toCollection(ArrayList::new));
            } else if (filter.exceptOnFilter != null) {
                throw new UnsupportedOperationException("Unsupported exceptOn filter type " + filter.exceptOnFilter.getClass());
            }
        }
        this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
        this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
        this.setControlStates();
    }

    public void setMinHeight(int minHeight) {
        boolean updateFilter = false;
        ((SpinnerNumberModel)this.spinnerAbove.getModel()).setMinimum(Integer.valueOf(minHeight));
        if ((Integer)this.spinnerAbove.getValue() < minHeight) {
            this.spinnerAbove.setValue(minHeight);
            updateFilter = true;
        }
        ((SpinnerNumberModel)this.spinnerBelow.getModel()).setMinimum(Integer.valueOf(minHeight));
        if ((Integer)this.spinnerBelow.getValue() < minHeight) {
            this.spinnerBelow.setValue(minHeight);
            updateFilter = true;
        }
        if (updateFilter) {
            this.filterChanged();
        }
    }

    public void setMaxHeight(int maxHeight) {
        boolean updateFilter = false;
        ((SpinnerNumberModel)this.spinnerAbove.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        if ((Integer)this.spinnerAbove.getValue() >= maxHeight) {
            this.spinnerAbove.setValue(maxHeight - 1);
            updateFilter = true;
        }
        ((SpinnerNumberModel)this.spinnerBelow.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        if ((Integer)this.spinnerBelow.getValue() >= maxHeight) {
            this.spinnerBelow.setValue(maxHeight - 1);
            updateFilter = true;
        }
        if (updateFilter) {
            this.filterChanged();
        }
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public MapSelectionListener getMapSelectionListener() {
        return this.mapSelectionListener;
    }

    public void setMapSelectionListener(MapSelectionListener mapSelectionListener) {
        this.mapSelectionListener = mapSelectionListener;
    }

    public void setOnlyOn(Terrain terrain) {
        this.onlyOn = terrain;
        this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
    }

    public void setOnlyOn(Layer layer, int value) {
        this.onlyOn = this.toPaint(layer, value);
        this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
    }

    public void addOnlyOn(Terrain terrain) {
        this.onlyOn = this.addToSelection(this.onlyOn, terrain);
        this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
    }

    public void addOnlyOn(Layer layer, int value) {
        this.onlyOn = this.addToSelection(this.onlyOn, this.toPaint(layer, value));
        this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
    }

    public void setExceptOn(Terrain terrain) {
        this.exceptOn = terrain;
        this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
    }

    public void setExceptOn(Layer layer, int value) {
        this.exceptOn = this.toPaint(layer, value);
        this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
    }

    public void addExceptOn(Terrain terrain) {
        this.exceptOn = this.addToSelection(this.exceptOn, terrain);
        this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
    }

    public void addExceptOn(Layer layer, int value) {
        this.exceptOn = this.addToSelection(this.exceptOn, this.toPaint(layer, value));
        this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
    }

    @Override
    public void update(Observable o, Object selectionMayBePresent) {
        this.checkBoxInSelection.setEnabled((Boolean)selectionMayBePresent);
        this.checkBoxOutsideSelection.setEnabled((Boolean)selectionMayBePresent);
    }

    private Object addToSelection(Object currentSelection, Object item) {
        ArrayList<Object> selection = currentSelection instanceof List ? (ArrayList<Object>)currentSelection : new ArrayList<Object>(Collections.singleton(currentSelection));
        selection.add(item);
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPaint(Object paint, AbstractButton button, JComponent ... additionalComponents) {
        String tooltip;
        Icon icon;
        Object text;
        if (paint == null) {
            text = "...";
            icon = null;
            tooltip = null;
        } else if (paint instanceof List) {
            List list = (List)paint;
            String symbol = button == this.buttonReplace ? " + " : " / ";
            text = list.size() > 2 ? this.shorten(this.getText(list.get(0))) + symbol + (list.size() - 1) + " more" : this.shorten(this.getText(list.get(0)) + symbol + this.shorten(this.getText(list.get(1))));
            List icons = list.stream().map(item -> (ImageIcon)this.getIcon(item)).filter(Objects::nonNull).limit(2L).collect(Collectors.toList());
            if (icons.isEmpty()) {
                icon = null;
            } else if (icons.size() == 1) {
                icon = (Icon)icons.get(0);
            } else {
                int iconSize = Math.round(16.0f * GUIUtils.getUIScale());
                int subSize = Math.round(12.0f * GUIUtils.getUIScale());
                BufferedImage image = new BufferedImage(iconSize, iconSize, 2);
                Graphics2D g2 = image.createGraphics();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2.drawImage(((ImageIcon)icons.get(0)).getImage(), 0, 0, subSize, subSize, null);
                    g2.drawImage(((ImageIcon)icons.get(1)).getImage(), iconSize - subSize, iconSize - subSize, subSize, subSize, null);
                }
                finally {
                    g2.dispose();
                }
                icon = new ImageIcon(image);
            }
            tooltip = "<html>" + ((List)paint).stream().map(this::getText).collect(Collectors.joining("<br>")) + "</html>";
        } else {
            text = this.getText(paint);
            icon = this.getIcon(paint);
            tooltip = null;
        }
        button.setText((String)text);
        button.setIcon(icon);
        button.setToolTipText(tooltip);
        for (JComponent additionalComponent : additionalComponents) {
            additionalComponent.setToolTipText(tooltip);
        }
        this.filterChanged();
    }

    private String shorten(String text) {
        return text.length() > 15 ? text.substring(0, 12) + "..." : text;
    }

    private String getText(Object paint) {
        if (paint instanceof String) {
            switch ((String)paint) {
                case "Water": {
                    return "Water";
                }
                case "Lava": {
                    return "Lava";
                }
                case "Land": {
                    return "Land";
                }
                case "Automatic Biomes": {
                    return "All Auto Biomes";
                }
            }
            throw new UnsupportedOperationException("Paint of type \"" + paint + "\" not supported");
        }
        if (paint instanceof Terrain) {
            return ((Terrain)paint).getName();
        }
        if (paint instanceof DefaultFilter.LayerValue) {
            DefaultFilter.LayerValue layerValue = (DefaultFilter.LayerValue)paint;
            if (layerValue.layer instanceof Biome) {
                return new BiomeHelper(this.colourScheme, this.customBiomeManager, this.platform).getBiomeName(Math.abs(layerValue.value));
            }
            if (layerValue.layer instanceof Annotations) {
                if (layerValue.value == -1) {
                    return "All Annotations";
                }
                return Annotations.getColourName((int)layerValue.value) + " Annotations";
            }
            throw new UnsupportedOperationException("Paint of layer type " + layerValue.layer.getClass() + " and value " + layerValue.value + " not supported");
        }
        if (paint instanceof Layer) {
            return ((Layer)paint).getName();
        }
        throw new UnsupportedOperationException("Paint of type " + paint.getClass() + " not supported");
    }

    private Icon getIcon(Object paint) {
        if (paint instanceof String) {
            switch ((String)paint) {
                case "Water": {
                    return ICON_WATER;
                }
                case "Lava": {
                    return ICON_LAVA;
                }
                case "Land": 
                case "Automatic Biomes": {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Paint of type \"" + paint + "\" not supported");
        }
        if (paint instanceof Terrain) {
            return new ImageIcon(((Terrain)paint).getScaledIcon(16, this.colourScheme));
        }
        if (paint instanceof DefaultFilter.LayerValue) {
            DefaultFilter.LayerValue layerValue = (DefaultFilter.LayerValue)paint;
            if (layerValue.layer instanceof Biome) {
                return new BiomeHelper(this.colourScheme, this.customBiomeManager, this.platform).getBiomeIcon(Math.abs(layerValue.value));
            }
            if (layerValue.layer instanceof Annotations) {
                if (layerValue.value == -1) {
                    return null;
                }
                return IconUtils.createScaledColourIcon((int)Annotations.getColour((int)layerValue.value, (ColourScheme)this.colourScheme));
            }
            throw new UnsupportedOperationException("Paint of layer type " + layerValue.layer.getClass() + " and value " + layerValue.value + " not supported");
        }
        if (paint instanceof Layer) {
            return new ImageIcon(((Layer)paint).getIcon());
        }
        throw new UnsupportedOperationException("Paint of type " + paint.getClass() + " not supported");
    }

    private Object toPaint(Layer layer, int value) {
        if (layer instanceof Biome) {
            return new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, value);
        }
        if (layer instanceof Annotations) {
            return new DefaultFilter.LayerValue((Layer)Annotations.INSTANCE, value);
        }
        if (layer.discrete) {
            throw new UnsupportedOperationException("Discrete layers not supported");
        }
        return layer;
    }

    private Object toPaint(TerrainOrLayerFilter filter) {
        switch (filter.objectType) {
            case BIOME: {
                if (filter.value == 255) {
                    return "Automatic Biomes";
                }
                return new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, filter.value);
            }
            case AUTO_BIOME: {
                return new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, -filter.value);
            }
            case BIT_LAYER: 
            case INT_LAYER_ANY: {
                return filter.layer;
            }
            case INT_LAYER_EQUAL: {
                return new DefaultFilter.LayerValue(filter.layer, filter.value);
            }
            case TERRAIN: {
                return filter.terrain;
            }
            case WATER: {
                return "Water";
            }
            case LAND: {
                return "Land";
            }
            case LAVA: {
                return "Lava";
            }
            case ANNOTATION: {
                return new DefaultFilter.LayerValue((Layer)Annotations.INSTANCE, filter.value);
            }
            case ANNOTATION_ANY: {
                return new DefaultFilter.LayerValue((Layer)Annotations.INSTANCE);
            }
        }
        throw new UnsupportedOperationException("Unsupported onlyOn filter type " + filter.objectType);
    }

    private void setControlStates() {
        this.spinnerAbove.setEnabled(this.checkBoxAbove.isSelected());
        this.spinnerBelow.setEnabled(this.checkBoxBelow.isSelected());
        this.spinnerSlope.setEnabled(this.checkBoxAboveSlope.isSelected() || this.checkBoxBelowSlope.isSelected());
        this.buttonReplace.setEnabled(this.checkBoxReplace.isSelected());
        this.buttonExceptOn.setEnabled(this.checkBoxExceptOn.isSelected());
        this.checkBoxFeather.setEnabled(this.checkBoxAbove.isSelected() || this.checkBoxBelow.isSelected());
    }

    private JPopupMenu createReplaceMenu() {
        JMenu menu = this.createObjectSelectionMenu(MENU_ONLY_ON, (object, name, icon) -> {
            this.onlyOn = object;
            this.installPaint(this.onlyOn, this.buttonReplace, this.checkBoxReplace);
        }, false, this.onlyOn);
        BetterJPopupMenu popupMenu = new BetterJPopupMenu();
        Arrays.stream(menu.getMenuComponents()).forEach(((JPopupMenu)popupMenu)::add);
        return popupMenu;
    }

    private JPopupMenu createExceptOnMenu() {
        JMenu menu = this.createObjectSelectionMenu(MENU_EXCEPT_ON, (object, name, icon) -> {
            this.exceptOn = object;
            this.installPaint(this.exceptOn, this.buttonExceptOn, this.checkBoxExceptOn);
        }, false, this.exceptOn);
        BetterJPopupMenu popupMenu = new BetterJPopupMenu();
        Arrays.stream(menu.getMenuComponents()).forEach(((JPopupMenu)popupMenu)::add);
        return popupMenu;
    }

    private JMenu createObjectSelectionMenu(final String descriptor, ObjectSelectionListener listener, final boolean addAnother, Object currentSelection) {
        JMenuItem waterItem = new JMenuItem("Water", ICON_WATER);
        waterItem.addActionListener(e -> listener.objectSelected("Water", "Water", null));
        JMenu popupMenu = new JMenu();
        popupMenu.add(waterItem);
        JMenuItem lavaItem = new JMenuItem("Lava", ICON_LAVA);
        lavaItem.addActionListener(e -> listener.objectSelected("Lava", "Lava", null));
        popupMenu.add(lavaItem);
        JMenuItem landItem = new JMenuItem("Land");
        landItem.addActionListener(e -> listener.objectSelected("Land", "Land", null));
        popupMenu.add(landItem);
        JMenuItem eyedropperItem = new JMenuItem("Select on Map", ICON_EYEDROPPER);
        eyedropperItem.setToolTipText("Select a paint from the map");
        App app = App.getInstance();
        ColourScheme colourScheme = app.getColourScheme();
        if (this.mapSelectionListener != null) {
            eyedropperItem.addActionListener(e -> this.mapSelectionListener.mapSelectionRequested(descriptor, addAnother));
        } else {
            eyedropperItem.addActionListener(e -> App.getInstance().selectPaintOnMap(null, new Eyedropper.SelectionListener(){

                @Override
                public void terrainSelected(Terrain terrain) {
                    switch (descriptor) {
                        case "onlyOn": {
                            if (addAnother) {
                                BrushOptions.this.addOnlyOn(terrain);
                                break;
                            }
                            BrushOptions.this.setOnlyOn(terrain);
                            break;
                        }
                        case "exceptOn": {
                            if (addAnother) {
                                BrushOptions.this.addExceptOn(terrain);
                                break;
                            }
                            BrushOptions.this.setExceptOn(terrain);
                        }
                    }
                }

                @Override
                public void layerSelected(Layer layer, int value) {
                    switch (descriptor) {
                        case "onlyOn": {
                            if (addAnother) {
                                BrushOptions.this.addOnlyOn(layer, value);
                                break;
                            }
                            BrushOptions.this.setOnlyOn(layer, value);
                            break;
                        }
                        case "exceptOn": {
                            if (addAnother) {
                                BrushOptions.this.addExceptOn(layer, value);
                                break;
                            }
                            BrushOptions.this.setExceptOn(layer, value);
                        }
                    }
                }

                @Override
                public void selectionCancelled(boolean byUser) {
                }
            }));
        }
        popupMenu.add(eyedropperItem);
        JMenu terrainMenu = new JMenu("Terrain");
        JMenu customTerrainMenu = new JMenu("Custom");
        JMenu stainedClayTerrainMenu = new JMenu("Stained Terracotta");
        Terrain[] terrainArray = Terrain.getConfiguredValues();
        int n = terrainArray.length;
        for (int i = 0; i < n; ++i) {
            Terrain terrain;
            Terrain selectedTerrain = terrain = terrainArray[i];
            String name2 = terrain.getName();
            ImageIcon icon2 = new ImageIcon(terrain.getScaledIcon(16, colourScheme));
            JMenuItem menuItem = new JMenuItem(name2, icon2);
            menuItem.addActionListener(e -> listener.objectSelected(selectedTerrain, name2, icon2));
            if (terrain.isCustom()) {
                customTerrainMenu.add(menuItem);
                continue;
            }
            if (Terrain.STAINED_TERRACOTTAS.contains(terrain)) {
                stainedClayTerrainMenu.add(menuItem);
                continue;
            }
            terrainMenu.add(menuItem);
        }
        terrainMenu.add(stainedClayTerrainMenu);
        if (customTerrainMenu.getMenuComponentCount() > 0) {
            terrainMenu.add(customTerrainMenu);
        }
        popupMenu.add(terrainMenu);
        JMenu layerMenu = new JMenu("Layer");
        LayerManager.getInstance().getLayers().stream().filter(layer -> !layer.equals((Object)Biome.INSTANCE)).forEach(layer -> {
            JMenuItem menuItem = new JMenuItem(layer.getName(), new ImageIcon(layer.getIcon()));
            menuItem.addActionListener(e -> listener.objectSelected(layer, layer.getName(), new ImageIcon(layer.getIcon())));
            layerMenu.add(menuItem);
        });
        List<CustomLayer> customLayers = app.getCustomLayers();
        if (customLayers.size() > 15) {
            app.getCustomLayersByPalette().entrySet().stream().map(entry -> {
                String palette = (String)entry.getKey();
                JMenu paletteMenu = new JMenu(palette != null ? palette : "Hidden Layers");
                ((Collection)entry.getValue()).forEach(layer -> {
                    JMenuItem menuItem = new JMenuItem(layer.getName(), new ImageIcon(layer.getIcon()));
                    menuItem.addActionListener(e -> listener.objectSelected(layer, layer.getName(), new ImageIcon(layer.getIcon())));
                    paletteMenu.add(menuItem);
                });
                return paletteMenu;
            }).forEach(layerMenu::add);
        } else {
            customLayers.forEach(layer -> {
                JMenuItem menuItem = new JMenuItem(layer.getName(), new ImageIcon(layer.getIcon()));
                menuItem.addActionListener(e -> listener.objectSelected(layer, layer.getName(), new ImageIcon(layer.getIcon())));
                layerMenu.add(menuItem);
            });
        }
        popupMenu.add(layerMenu);
        JMenu biomeMenu = new JMenu("Biome");
        CustomBiomeManager customBiomeManager = app.getCustomBiomeManager();
        BiomeHelper biomeHelper = new BiomeHelper(colourScheme, customBiomeManager, this.platform);
        List customBiomes = customBiomeManager.getCustomBiomes();
        if (!customBiomes.isEmpty()) {
            JMenu customBiomeMenu = new JMenu("Custom");
            for (CustomBiome customBiome : customBiomes) {
                int selectedBiome = customBiome.getId();
                String name3 = biomeHelper.getBiomeName(selectedBiome);
                Icon icon3 = biomeHelper.getBiomeIcon(selectedBiome);
                JMenuItem menuItem = new JMenuItem(name3, icon3);
                menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, selectedBiome), name3, icon3));
                customBiomeMenu.add(menuItem);
            }
            biomeMenu.add(customBiomeMenu);
        }
        BiomeScheme biomeScheme = BiomeUtils.getBiomeScheme((Platform)this.platform);
        if (this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
            TreeMap<String, Integer> biomes = new TreeMap<String, Integer>();
            for (int i = 0; i < biomeScheme.getBiomeCount(); ++i) {
                if (!biomeScheme.isBiomePresent(i)) continue;
                biomes.put(biomeHelper.getBiomeName(i), i);
            }
            biomes.forEach((name, id) -> {
                Icon icon = biomeHelper.getBiomeIcon((int)id);
                JMenuItem menuItem = new JMenuItem((String)name, icon);
                menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, id.intValue()), (String)name, icon));
                biomeMenu.add(menuItem);
            });
        } else {
            for (int i = 0; i < biomeScheme.getBiomeCount(); ++i) {
                if (!biomeScheme.isBiomePresent(i)) continue;
                int selectedBiome = i;
                String name4 = biomeHelper.getBiomeName(i);
                Icon icon4 = biomeHelper.getBiomeIcon(i);
                JMenuItem menuItem = new JMenuItem(name4, icon4);
                menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, selectedBiome), name4, icon4));
                biomeMenu.add(menuItem);
            }
        }
        JMenu autoBiomeSubMenu = new JMenu("Auto Biomes");
        JMenuItem autoBiomesMenuItem = new JMenuItem("All Auto Biomes");
        autoBiomesMenuItem.addActionListener(e -> listener.objectSelected("Automatic Biomes", "All Auto Biomes", null));
        autoBiomeSubMenu.add(autoBiomesMenuItem);
        for (int autoBiome : Dimension.POSSIBLE_AUTO_BIOMES) {
            int selectedBiome = -autoBiome;
            String name5 = biomeHelper.getBiomeName(autoBiome);
            Icon icon5 = biomeHelper.getBiomeIcon(autoBiome);
            JMenuItem menuItem = new JMenuItem(name5, icon5);
            menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Biome.INSTANCE, selectedBiome), name5, icon5));
            autoBiomeSubMenu.add(menuItem);
        }
        biomeMenu.add(autoBiomeSubMenu);
        popupMenu.add(biomeMenu);
        JMenu annotationsMenu = new JMenu("Annotations");
        JMenuItem menuItem = new JMenuItem("All Annotations");
        menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Annotations.INSTANCE), "All Annotations", null));
        annotationsMenu.add(menuItem);
        int i = 1;
        while (i < 16) {
            int layerValue = i++;
            Icon icon6 = IconUtils.createScaledColourIcon((int)Annotations.getColour((int)layerValue, (ColourScheme)colourScheme));
            String colourName = Annotations.getColourName((int)layerValue);
            menuItem = new JMenuItem(colourName, icon6);
            menuItem.addActionListener(e -> listener.objectSelected(new DefaultFilter.LayerValue((Layer)Annotations.INSTANCE, layerValue), colourName + " Annotations", icon6));
            annotationsMenu.add(menuItem);
        }
        popupMenu.add(annotationsMenu);
        if (!addAnother && currentSelection != null) {
            JMenu subMenu = this.createObjectSelectionMenu(descriptor, (object, name, icon) -> {
                ArrayList<Object> selection;
                if (currentSelection instanceof List) {
                    selection = (ArrayList<Object>)currentSelection;
                } else {
                    selection = new ArrayList<Object>();
                    selection.add(currentSelection);
                }
                selection.add(object);
                listener.objectSelected(selection, "Multiple", ICON_PLUS);
            }, true, currentSelection);
            subMenu.setText("Add Another");
            subMenu.setIcon(ICON_PLUS);
            popupMenu.add(subMenu);
        }
        popupMenu = this.breakUpLongMenus(popupMenu, 25);
        return popupMenu;
    }

    private JMenu breakUpLongMenus(JMenu menu, int maxLength) {
        if (menu.getMenuComponentCount() > maxLength) {
            JMenu replacementMenu = new JMenu(menu.getText());
            replacementMenu.setToolTipText(menu.getToolTipText());
            for (Component menuItem : menu.getMenuComponents()) {
                if (!(menuItem instanceof JMenu)) continue;
                menu.remove(menuItem);
                replacementMenu.add(this.breakUpLongMenus((JMenu)menuItem, maxLength));
            }
            int index = 0;
            while (replacementMenu.getMenuComponentCount() < maxLength - 1 && menu.getMenuComponentCount() > 0) {
                Component menuItem = menu.getMenuComponent(0);
                menu.remove(0);
                replacementMenu.add(menuItem, index++);
            }
            if (menu.getMenuComponentCount() > 0) {
                menu.setText("More");
                menu.setToolTipText(null);
                replacementMenu.add((Component)this.breakUpLongMenus(menu, maxLength), index);
            }
            return replacementMenu;
        }
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (!(menu.getMenuComponent(i) instanceof JMenu)) continue;
            JMenu subMenu = (JMenu)menu.getMenuComponent(i);
            menu.remove(i);
            menu.add((Component)this.breakUpLongMenus(subMenu, maxLength), i);
        }
        return menu;
    }

    private void showReplaceMenu() {
        App.getInstance().cancelPaintSelection();
        JPopupMenu menu = this.createReplaceMenu();
        menu.show(this, this.buttonReplace.getX() + this.buttonReplace.getWidth(), this.buttonReplace.getY());
    }

    private void showExceptOnMenu() {
        App.getInstance().cancelPaintSelection();
        JPopupMenu menu = this.createExceptOnMenu();
        menu.show(this, this.buttonExceptOn.getX() + this.buttonExceptOn.getWidth(), this.buttonExceptOn.getY());
    }

    private void filterChanged() {
        if (this.listener != null) {
            DefaultFilter filter = this.getFilter();
            if (logger.isTraceEnabled()) {
                logger.trace("Reporting new filter " + (Filter)filter + " to listener " + this.listener);
            }
            this.listener.filterChanged((Filter)filter);
        }
    }

    private void initComponents() {
        this.checkBoxAbove = new JCheckBox();
        this.spinnerAbove = new JSpinner();
        this.checkBoxBelow = new JCheckBox();
        this.spinnerBelow = new JSpinner();
        this.checkBoxReplace = new JCheckBox();
        this.buttonReplace = new JButton();
        this.checkBoxFeather = new JCheckBox();
        this.checkBoxExceptOn = new JCheckBox();
        this.buttonExceptOn = new JButton();
        this.checkBoxAboveSlope = new JCheckBox();
        this.checkBoxBelowSlope = new JCheckBox();
        this.spinnerSlope = new JSpinner();
        this.jLabel1 = new JLabel();
        this.checkBoxInSelection = new JCheckBox();
        this.checkBoxOutsideSelection = new JCheckBox();
        this.checkBoxAbove.setFont(this.checkBoxAbove.getFont().deriveFont((float)this.checkBoxAbove.getFont().getSize() - 1.0f));
        this.checkBoxAbove.setText("at or above");
        this.checkBoxAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxAboveActionPerformed(evt);
            }
        });
        this.spinnerAbove.setFont(this.spinnerAbove.getFont().deriveFont((float)this.spinnerAbove.getFont().getSize() - 1.0f));
        this.spinnerAbove.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerAbove.setEnabled(false);
        this.spinnerAbove.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BrushOptions.this.spinnerAboveStateChanged(evt);
            }
        });
        this.checkBoxBelow.setFont(this.checkBoxBelow.getFont().deriveFont((float)this.checkBoxBelow.getFont().getSize() - 1.0f));
        this.checkBoxBelow.setText("at or below");
        this.checkBoxBelow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxBelowActionPerformed(evt);
            }
        });
        this.spinnerBelow.setFont(this.spinnerBelow.getFont().deriveFont((float)this.spinnerBelow.getFont().getSize() - 1.0f));
        this.spinnerBelow.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinnerBelow.setEnabled(false);
        this.spinnerBelow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BrushOptions.this.spinnerBelowStateChanged(evt);
            }
        });
        this.checkBoxReplace.setFont(this.checkBoxReplace.getFont().deriveFont((float)this.checkBoxReplace.getFont().getSize() - 1.0f));
        this.checkBoxReplace.setText("only on");
        this.checkBoxReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxReplaceActionPerformed(evt);
            }
        });
        this.buttonReplace.setFont(this.buttonReplace.getFont().deriveFont((float)this.buttonReplace.getFont().getSize() - 1.0f));
        this.buttonReplace.setText("...");
        this.buttonReplace.setEnabled(false);
        this.buttonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.buttonReplaceActionPerformed(evt);
            }
        });
        this.checkBoxFeather.setFont(this.checkBoxFeather.getFont().deriveFont((float)this.checkBoxFeather.getFont().getSize() - 1.0f));
        this.checkBoxFeather.setText("feather");
        this.checkBoxFeather.setEnabled(false);
        this.checkBoxFeather.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxFeatherActionPerformed(evt);
            }
        });
        this.checkBoxExceptOn.setFont(this.checkBoxExceptOn.getFont().deriveFont((float)this.checkBoxExceptOn.getFont().getSize() - 1.0f));
        this.checkBoxExceptOn.setText("except on");
        this.checkBoxExceptOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxExceptOnActionPerformed(evt);
            }
        });
        this.buttonExceptOn.setFont(this.buttonExceptOn.getFont().deriveFont((float)this.buttonExceptOn.getFont().getSize() - 1.0f));
        this.buttonExceptOn.setText("...");
        this.buttonExceptOn.setEnabled(false);
        this.buttonExceptOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.buttonExceptOnActionPerformed(evt);
            }
        });
        this.checkBoxAboveSlope.setFont(this.checkBoxAboveSlope.getFont().deriveFont((float)this.checkBoxAboveSlope.getFont().getSize() - 1.0f));
        this.checkBoxAboveSlope.setText("above");
        this.checkBoxAboveSlope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxAboveSlopeActionPerformed(evt);
            }
        });
        this.checkBoxBelowSlope.setFont(this.checkBoxBelowSlope.getFont().deriveFont((float)this.checkBoxBelowSlope.getFont().getSize() - 1.0f));
        this.checkBoxBelowSlope.setText("below");
        this.checkBoxBelowSlope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxBelowSlopeActionPerformed(evt);
            }
        });
        this.spinnerSlope.setFont(this.spinnerSlope.getFont().deriveFont((float)this.spinnerSlope.getFont().getSize() - 1.0f));
        this.spinnerSlope.setModel(new SpinnerNumberModel(45, 0, 89, 1));
        this.spinnerSlope.setEnabled(false);
        this.spinnerSlope.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BrushOptions.this.spinnerSlopeStateChanged(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 1.0f));
        this.jLabel1.setText("degrees");
        this.checkBoxInSelection.setFont(this.checkBoxInSelection.getFont().deriveFont((float)this.checkBoxInSelection.getFont().getSize() - 1.0f));
        this.checkBoxInSelection.setText("inside selection");
        this.checkBoxInSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxInSelectionActionPerformed(evt);
            }
        });
        this.checkBoxOutsideSelection.setFont(this.checkBoxOutsideSelection.getFont().deriveFont((float)this.checkBoxOutsideSelection.getFont().getSize() - 1.0f));
        this.checkBoxOutsideSelection.setText("outside selection");
        this.checkBoxOutsideSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrushOptions.this.checkBoxOutsideSelectionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxInSelection).addComponent(this.checkBoxBelow).addComponent(this.checkBoxReplace).addComponent(this.checkBoxExceptOn).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxAboveSlope).addGap(0, 0, 0).addComponent(this.checkBoxBelowSlope)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerAbove, -2, -1, -2).addComponent(this.spinnerBelow, -2, -1, -2).addComponent(this.checkBoxFeather).addComponent(this.buttonReplace).addComponent(this.buttonExceptOn).addGroup(layout.createSequentialGroup().addComponent(this.spinnerSlope, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel1)))).addComponent(this.checkBoxAbove).addComponent(this.checkBoxOutsideSelection));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.checkBoxInSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxOutsideSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxAbove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerAbove, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxBelow).addGap(0, 0, 0).addComponent(this.spinnerBelow, -2, -1, -2).addGap(0, 0, 0).addComponent(this.checkBoxFeather).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxReplace).addGap(0, 0, 0).addComponent(this.buttonReplace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxExceptOn).addGap(0, 0, 0).addComponent(this.buttonExceptOn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxAboveSlope).addComponent(this.checkBoxBelowSlope)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerSlope, -2, -1, -2).addComponent(this.jLabel1))));
    }

    private void initialiseIfNecessary() {
        if (!this.initialised) {
            AbstractAction nullAction = new AbstractAction("Do nothing"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.getActionMap().put("doNothing", nullAction);
            InputMap inputMap = this.getInputMap(1);
            App app = App.getInstance();
            inputMap.put(app.ACTION_INTENSITY_10_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_20_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_30_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_40_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_50_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_60_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_70_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_80_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_90_PERCENT.getAcceleratorKey(), "doNothing");
            inputMap.put(app.ACTION_INTENSITY_100_PERCENT.getAcceleratorKey(), "doNothing");
            this.initialised = true;
        }
    }

    private void checkBoxAboveActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        this.setControlStates();
        this.filterChanged();
    }

    private void checkBoxBelowActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        this.setControlStates();
        this.filterChanged();
    }

    private void checkBoxReplaceActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        this.setControlStates();
        if (this.checkBoxReplace.isSelected() && this.onlyOn == null) {
            this.showReplaceMenu();
        } else {
            this.filterChanged();
        }
    }

    private void buttonReplaceActionPerformed(ActionEvent evt) {
        this.showReplaceMenu();
    }

    private void spinnerAboveStateChanged(ChangeEvent evt) {
        this.filterChanged();
    }

    private void spinnerBelowStateChanged(ChangeEvent evt) {
        this.filterChanged();
    }

    private void checkBoxFeatherActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void checkBoxExceptOnActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        this.setControlStates();
        if (this.checkBoxExceptOn.isSelected() && this.exceptOn == null) {
            this.showExceptOnMenu();
        } else {
            this.filterChanged();
        }
    }

    private void buttonExceptOnActionPerformed(ActionEvent evt) {
        this.showExceptOnMenu();
    }

    private void checkBoxAboveSlopeActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        if (this.checkBoxAboveSlope.isSelected()) {
            this.checkBoxBelowSlope.setSelected(false);
        }
        this.setControlStates();
        this.filterChanged();
    }

    private void checkBoxBelowSlopeActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        if (this.checkBoxBelowSlope.isSelected()) {
            this.checkBoxAboveSlope.setSelected(false);
        }
        this.setControlStates();
        this.filterChanged();
    }

    private void spinnerSlopeStateChanged(ChangeEvent evt) {
        this.filterChanged();
    }

    private void checkBoxInSelectionActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        if (this.checkBoxInSelection.isSelected() && this.checkBoxOutsideSelection.isSelected()) {
            this.checkBoxOutsideSelection.setSelected(false);
        }
        this.filterChanged();
    }

    private void checkBoxOutsideSelectionActionPerformed(ActionEvent evt) {
        this.initialiseIfNecessary();
        if (this.checkBoxOutsideSelection.isSelected() && this.checkBoxInSelection.isSelected()) {
            this.checkBoxInSelection.setSelected(false);
        }
        this.filterChanged();
    }

    public static interface Listener {
        public void filterChanged(Filter var1);
    }

    public static interface MapSelectionListener {
        public void mapSelectionRequested(String var1, boolean var2);
    }

    public static interface ObjectSelectionListener {
        public void objectSelected(Object var1, String var2, Icon var3);
    }
}

