/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.palettes;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pepsoft.worldpainter.CustomLayerController;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.palettes.Palette;

public class PaletteManager {
    private final List<Palette> paletteList = new ArrayList<Palette>();
    private final Map<String, Palette> palettesByName = new HashMap<String, Palette>();
    private final CustomLayerController customLayerController;

    public PaletteManager(CustomLayerController customLayerController) {
        this.customLayerController = customLayerController;
    }

    public List<Palette> getPalettes() {
        return Collections.unmodifiableList(this.paletteList);
    }

    public List<CustomLayer> getLayers() {
        ArrayList<CustomLayer> layers = new ArrayList<CustomLayer>();
        for (Palette palette : this.paletteList) {
            layers.addAll(palette.getLayers());
        }
        return layers;
    }

    public Map<String, Collection<CustomLayer>> getLayersByPalette() {
        HashMap<String, Collection<CustomLayer>> layers = new HashMap<String, Collection<CustomLayer>>(this.paletteList.size());
        for (Palette palette : this.paletteList) {
            layers.put(palette.getName(), palette.getLayers());
        }
        return layers;
    }

    public boolean contains(Layer layer) {
        for (Palette palette : this.paletteList) {
            if (!palette.contains(layer)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.paletteList.isEmpty();
    }

    public Palette getPalette(String name) {
        return this.palettesByName.get(name);
    }

    public Palette create(String name) {
        if (this.palettesByName.containsKey(name)) {
            throw new IllegalStateException("There is already a palette named \"" + name + "\"");
        }
        Palette palette = new Palette(name, this.customLayerController.createPopupMenuButton(), this);
        this.paletteList.add(palette);
        this.palettesByName.put(name, palette);
        return palette;
    }

    public Palette register(CustomLayer layer) {
        Palette palette = this.getPaletteContaining(layer);
        boolean paletteCreated = false;
        if (palette == null) {
            palette = new Palette(layer.getPalette(), this.customLayerController.createPopupMenuButton(), this);
            paletteCreated = true;
            this.paletteList.add(palette);
            this.palettesByName.put(layer.getPalette(), palette);
        }
        palette.add(layer, this.customLayerController.createCustomLayerButton(layer));
        return paletteCreated ? palette : null;
    }

    public Palette getPaletteContaining(CustomLayer layer) {
        return this.palettesByName.get(layer.getPalette());
    }

    public void activate(CustomLayer layer) {
        this.getPaletteContaining(layer).activate(layer);
    }

    public void deactivate(CustomLayer layer) {
        this.getPaletteContaining(layer).deactivate(layer);
    }

    public Palette move(CustomLayer layer, Palette destPalette) {
        Palette palette = this.getPaletteContaining(layer);
        List<Component> button = palette.remove(layer);
        destPalette.add(layer, button);
        layer.setPalette(destPalette.getName());
        return palette;
    }

    public Palette unregister(CustomLayer layer) {
        Palette palette = this.getPaletteContaining(layer);
        palette.remove(layer);
        this.customLayerController.layerRemoved(layer);
        return palette;
    }

    public void delete(Palette palette) {
        this.paletteList.remove(palette);
        this.palettesByName.remove(palette.getName());
    }

    public List<Palette> clear() {
        ArrayList<Palette> oldPaletteList = new ArrayList<Palette>(this.paletteList);
        this.paletteList.clear();
        this.palettesByName.clear();
        return oldPaletteList;
    }

    public void rename(Palette palette, String newName) {
        if (this.palettesByName.containsKey(newName)) {
            throw new IllegalArgumentException("New name \"" + newName + "\" already in use");
        }
        this.palettesByName.remove(palette.getName());
        palette.setName(newName);
        this.palettesByName.put(newName, palette);
    }
}

