/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.palettes;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.palettes.Palette;
import org.pepsoft.worldpainter.palettes.PaletteManager;

public class EditPaletteDialog
extends WorldPainterDialog {
    private JButton buttonBottom;
    private JButton buttonCancel;
    private JButton buttonDown;
    private JButton buttonOk;
    private JButton buttonReset;
    private JButton buttonSort;
    private JButton buttonTop;
    private JButton buttonUp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JList<CustomLayer> listLayers;
    private JTextField textFieldName;
    private final PaletteManager paletteManager;
    private final Palette palette;
    private boolean orderChanged;

    public EditPaletteDialog(Window parent, PaletteManager paletteManager, Palette palette) {
        super(parent);
        Objects.requireNonNull(palette, "palette");
        this.paletteManager = paletteManager;
        this.palette = palette;
        this.initComponents();
        DefaultListModel listModel = new DefaultListModel();
        palette.getLayers().forEach(listModel::addElement);
        this.listLayers.setModel(listModel);
        this.listLayers.setCellRenderer(new LayerListCellRenderer());
        this.textFieldName.setText(palette.getName());
        this.textFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditPaletteDialog.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditPaletteDialog.this.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditPaletteDialog.this.nameChanged();
            }
        });
        this.listLayers.addListSelectionListener(e -> this.setControlStates());
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.scaleToUI();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
    }

    private void setControlStates() {
        boolean rowsSelected = !this.listLayers.isSelectionEmpty();
        this.buttonTop.setEnabled(rowsSelected && !this.listLayers.isSelectedIndex(0));
        this.buttonUp.setEnabled(rowsSelected && !this.listLayers.isSelectedIndex(0));
        this.buttonDown.setEnabled(rowsSelected && !this.listLayers.isSelectedIndex(this.listLayers.getModel().getSize() - 1));
        this.buttonBottom.setEnabled(rowsSelected && !this.listLayers.isSelectedIndex(this.listLayers.getModel().getSize() - 1));
    }

    private boolean saveData() {
        boolean paletteChanged = false;
        String newName = this.textFieldName.getText();
        if (!newName.equals(this.palette.getName())) {
            Palette existingPalette = this.paletteManager.getPalette(newName);
            if (existingPalette != null && existingPalette != this.palette) {
                MessageUtils.beepAndShowError((Component)this, (String)("There already is a palette named \"" + newName + "\""), (String)"Name Already In Use");
                return false;
            }
            this.paletteManager.rename(this.palette, newName);
            paletteChanged = true;
        }
        if (this.orderChanged) {
            CustomLayer layer;
            Enumeration e = ((DefaultListModel)this.listLayers.getModel()).elements();
            while (e.hasMoreElements()) {
                layer = (CustomLayer)e.nextElement();
                this.paletteManager.unregister(layer);
                layer.setPaletteIndex(null);
            }
            e = ((DefaultListModel)this.listLayers.getModel()).elements();
            while (e.hasMoreElements()) {
                layer = (CustomLayer)e.nextElement();
                this.paletteManager.register(layer);
            }
            paletteChanged = true;
        }
        if (paletteChanged) {
            App.getInstance().getDimension().changed();
        }
        return true;
    }

    private void moveSelectedLayers(int destinationIndex) {
        int sourceIndex = this.listLayers.getSelectedIndex();
        List<CustomLayer> selectedLayers = this.removeSelectedLayers();
        this.insertLayers(destinationIndex, selectedLayers);
        this.listLayers.ensureIndexIsVisible(sourceIndex < destinationIndex ? destinationIndex + selectedLayers.size() - 1 : destinationIndex);
        this.orderChanged();
    }

    private List<CustomLayer> removeSelectedLayers() {
        int sourceIndex = this.listLayers.getSelectedIndex();
        List<CustomLayer> selectedRows = this.listLayers.getSelectedValuesList();
        DefaultListModel model = (DefaultListModel)this.listLayers.getModel();
        selectedRows.forEach(row -> model.remove(sourceIndex));
        return selectedRows;
    }

    private void insertLayers(int index, List<CustomLayer> layers) {
        DefaultListModel model = (DefaultListModel)this.listLayers.getModel();
        for (int i = 0; i < layers.size(); ++i) {
            model.add(index + i, layers.get(i));
        }
        this.listLayers.addSelectionInterval(index, index + layers.size() - 1);
    }

    private void sortLayers() {
        ArrayList<CustomLayer> layers = new ArrayList<CustomLayer>(this.palette.getLayers());
        layers.sort(Comparator.comparing(Layer::getName));
        DefaultListModel listModel = new DefaultListModel();
        layers.forEach(listModel::addElement);
        this.listLayers.setModel(listModel);
        this.orderChanged();
        this.buttonSort.setEnabled(false);
    }

    private void reset() {
        DefaultListModel listModel = new DefaultListModel();
        this.palette.getLayers().forEach(listModel::addElement);
        this.listLayers.setModel(listModel);
        this.textFieldName.setText(this.palette.getName());
        this.buttonReset.setEnabled(false);
        this.buttonOk.setEnabled(false);
        this.buttonSort.setEnabled(true);
        this.orderChanged = false;
    }

    private void nameChanged() {
        this.buttonOk.setEnabled(true);
        this.buttonReset.setEnabled(true);
        this.buttonSort.setEnabled(true);
    }

    private void orderChanged() {
        this.nameChanged();
        this.orderChanged = true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.listLayers = new JList();
        this.buttonTop = new JButton();
        this.buttonUp = new JButton();
        this.buttonDown = new JButton();
        this.buttonBottom = new JButton();
        this.buttonSort = new JButton();
        this.jLabel3 = new JLabel();
        this.buttonReset = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Palette");
        this.jLabel1.setLabelFor(this.textFieldName);
        this.jLabel1.setText("Name:");
        this.textFieldName.setText("jTextField1");
        this.jLabel2.setLabelFor(this.listLayers);
        this.jLabel2.setText("Layer order:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText("OK");
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.listLayers.setSelectionMode(1);
        this.jScrollPane1.setViewportView(this.listLayers);
        this.buttonTop.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/top.png")));
        this.buttonTop.setText("Top");
        this.buttonTop.setToolTipText("Move the selected layers to the top");
        this.buttonTop.setEnabled(false);
        this.buttonTop.setHorizontalAlignment(10);
        this.buttonTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonTopActionPerformed(evt);
            }
        });
        this.buttonUp.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/up.png")));
        this.buttonUp.setText("Up");
        this.buttonUp.setToolTipText("Move the selected layers up one row");
        this.buttonUp.setEnabled(false);
        this.buttonUp.setHorizontalAlignment(10);
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonUpActionPerformed(evt);
            }
        });
        this.buttonDown.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/down.png")));
        this.buttonDown.setText("Down");
        this.buttonDown.setToolTipText("Move the selected layers down one row");
        this.buttonDown.setEnabled(false);
        this.buttonDown.setHorizontalAlignment(10);
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonDownActionPerformed(evt);
            }
        });
        this.buttonBottom.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/bottom.png")));
        this.buttonBottom.setText("Bottom");
        this.buttonBottom.setToolTipText("Move the selected layers to the bottom");
        this.buttonBottom.setEnabled(false);
        this.buttonBottom.setHorizontalAlignment(10);
        this.buttonBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonBottomActionPerformed(evt);
            }
        });
        this.buttonSort.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/a_z.png")));
        this.buttonSort.setText("Sort");
        this.buttonSort.setToolTipText("Sort all the layers alphabetically by name");
        this.buttonSort.setHorizontalAlignment(10);
        this.buttonSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonSortActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 2));
        this.jLabel3.setLabelFor(this.listLayers);
        this.jLabel3.setText("Hold shift to select multiple rows");
        this.buttonReset.setText("Reset");
        this.buttonReset.setEnabled(false);
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaletteDialog.this.buttonResetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonReset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonBottom, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonDown, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonUp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonTop, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonSort, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldName)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.textFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 206, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk).addComponent(this.buttonReset))).addGroup(layout.createSequentialGroup().addComponent(this.buttonTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonBottom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSort).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        if (this.saveData()) {
            this.ok();
        }
    }

    private void buttonTopActionPerformed(ActionEvent evt) {
        this.moveSelectedLayers(0);
    }

    private void buttonUpActionPerformed(ActionEvent evt) {
        this.moveSelectedLayers(this.listLayers.getSelectedIndex() - 1);
    }

    private void buttonDownActionPerformed(ActionEvent evt) {
        this.moveSelectedLayers(this.listLayers.getSelectedIndex() + 1);
    }

    private void buttonBottomActionPerformed(ActionEvent evt) {
        this.moveSelectedLayers(this.listLayers.getModel().getSize() - (this.listLayers.getMaxSelectionIndex() - this.listLayers.getMinSelectionIndex() + 1));
    }

    private void buttonSortActionPerformed(ActionEvent evt) {
        this.sortLayers();
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        this.reset();
    }
}

