/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.painting.AbstractPaint;

public final class TerrainPaint
extends AbstractPaint {
    private final Terrain terrain;

    public TerrainPaint(Terrain terrain) {
        this.terrain = terrain;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    @Override
    public String getId() {
        return "Terrain/" + this.terrain.ordinal();
    }

    @Override
    public void apply(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.applyPixel(dimension, centreX, centreY);
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            if (this.dither) {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setTerrain(x, y, this.terrain);
                    }
                }
            } else {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.75f)) continue;
                        tile.setTerrain(x, y, this.terrain);
                    }
                }
            }
        } else if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, x, y);
                    if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.setTerrainAt(x, y, this.terrain);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.75f)) continue;
                    dimension.setTerrainAt(x, y, this.terrain);
                }
            }
        }
    }

    @Override
    public void remove(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.removePixel(dimension, centreX, centreY);
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.applyTheme(x, y);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.75f)) continue;
                    dimension.applyTheme(x, y);
                }
            }
        }
    }

    @Override
    public void applyPixel(Dimension dimension, int x, int y) {
        dimension.setTerrainAt(x, y, this.terrain);
    }

    @Override
    public void removePixel(Dimension dimension, int x, int y) {
        dimension.applyTheme(x, y);
    }

    @Override
    public BufferedImage getIcon(ColourScheme colourScheme) {
        return this.terrain.getScaledIcon(16, colourScheme);
    }
}

