/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.Rectangle;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.painting.LayerPaint;

public class NibbleLayerPaint
extends LayerPaint {
    public NibbleLayerPaint(Layer layer) {
        super(layer);
        if (layer.getDataSize() != Layer.DataSize.NIBBLE) {
            throw new IllegalArgumentException("Layer " + layer + " not nibble-sized");
        }
    }

    @Override
    public void apply(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.applyPixel(dimension, centreX, centreY);
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            for (int y = y1InTile; y <= y2InTile; ++y) {
                for (int x = x1InTile; x <= x2InTile; ++x) {
                    int targetValue;
                    int currentValue = tile.getLayerValue(this.layer, x, y);
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                    if (strength == 0.0f || (targetValue = 1 + Math.round(strength * 14.0f)) <= currentValue) continue;
                    tile.setLayerValue(this.layer, x, y, targetValue);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    int targetValue;
                    int currentValue = dimension.getLayerValueAt(this.layer, x, y);
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, x, y);
                    if (strength == 0.0f || (targetValue = 1 + Math.round(strength * 14.0f)) <= currentValue) continue;
                    dimension.setLayerValueAt(this.layer, x, y, targetValue);
                }
            }
        }
    }

    @Override
    public void remove(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.removePixel(dimension, centreX, centreY);
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            for (int y = y1InTile; y <= y2InTile; ++y) {
                for (int x = x1InTile; x <= x2InTile; ++x) {
                    int targetValue;
                    int currentValue = tile.getLayerValue(this.layer, x, y);
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                    if (strength == 0.0f || (targetValue = 14 - Math.round(strength * 14.0f)) >= currentValue) continue;
                    tile.setLayerValue(this.layer, x, y, targetValue);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    int targetValue;
                    int currentValue = dimension.getLayerValueAt(this.layer, x, y);
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (strength == 0.0f || (targetValue = 14 - (int)(strength * 14.0f + 0.0f)) >= currentValue) continue;
                    dimension.setLayerValueAt(this.layer, x, y, targetValue);
                }
            }
        }
    }

    @Override
    public void applyPixel(Dimension dimension, int x, int y) {
        Tile tile = dimension.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            int xInTile = x & 0x7F;
            int yInTile = y & 0x7F;
            int value = 1 + Math.round(this.brush.getLevel() * 14.0f);
            if (tile.getLayerValue(this.layer, xInTile, yInTile) < value) {
                tile.setLayerValue(this.layer, xInTile, yInTile, value);
            }
        }
    }

    @Override
    public void removePixel(Dimension dimension, int x, int y) {
        dimension.setLayerValueAt(this.layer, x, y, 0);
    }
}

