/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.brushes.LineBrush;
import org.pepsoft.worldpainter.brushes.SymmetricBrush;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.painting.DiscreteLayerPaint;
import org.pepsoft.worldpainter.painting.GeneralQueueLinearFloodFiller;
import org.pepsoft.worldpainter.painting.LayerPaint;
import org.pepsoft.worldpainter.painting.Paint;
import org.pepsoft.worldpainter.painting.PaintFactory;
import org.pepsoft.worldpainter.painting.TerrainPaint;

public final class DimensionPainter {
    private Paint paint;
    private int textAngle;
    private boolean undo;
    private Font font;
    public static final int ANGLE_0_DEGREES = 0;
    public static final int ANGLE_90_DEGREES = 1;
    public static final int ANGLE_180_DEGREES = 2;
    public static final int ANGLE_270_DEGREES = 3;
    private static final Brush MY_CONSTANT_CIRCLE = SymmetricBrush.CONSTANT_CIRCLE.clone();

    public void drawPoint(Dimension dimension, int x, int y) {
        if (this.undo) {
            this.paint.remove(dimension, x, y, 1.0f);
        } else {
            this.paint.apply(dimension, x, y, 1.0f);
        }
    }

    public void drawPoint(Dimension dimension, int x, int y, float dynamicLevel) {
        if (this.undo) {
            this.paint.remove(dimension, x, y, dynamicLevel);
        } else {
            this.paint.apply(dimension, x, y, dynamicLevel);
        }
    }

    public void drawLine(Dimension dimension, int x1, int y1, int x2, int y2) {
        this.drawLine(dimension, x1, y1, x2, y2, 1.0f, false);
    }

    public void drawLine(Dimension dimension, int x1, int y1, int x2, int y2, boolean fast) {
        this.drawLine(dimension, x1, y1, x2, y2, 1.0f, fast);
    }

    public void drawLine(Dimension dimension, int x1, int y1, int x2, int y2, float dynamicLevel) {
        this.drawLine(dimension, x1, y1, x2, y2, dynamicLevel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(Dimension dimension, int x1, int y1, int x2, int y2, float dynamicLevel, boolean fast) {
        Brush currentBrush = this.paint.getBrush();
        if (currentBrush == null) {
            return;
        }
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        if (fast && this.paint.getBrush().getRadius() == 0) {
            fast = false;
        }
        if (dx < dy) {
            if (y2 < y1) {
                int tmp = y1;
                y1 = y2;
                y2 = tmp;
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (!fast) {
                float x = (float)x1 - 0.5f;
                float fDx = (float)(x2 - x1) / (float)dy;
                for (int y = y1; y <= y2; ++y) {
                    this.drawPoint(dimension, Math.round(x), y, dynamicLevel);
                    x += fDx;
                }
            }
        } else {
            if (x2 < x1) {
                int tmp = y1;
                y1 = y2;
                y2 = tmp;
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (!fast) {
                float y = (float)y1 - 0.5f;
                float fDy = (float)(y2 - y1) / (float)dx;
                for (int x = x1; x <= x2; ++x) {
                    this.drawPoint(dimension, x, Math.round(y), dynamicLevel);
                    y += fDy;
                }
            }
        }
        if (fast) {
            LineBrush lineBrush;
            if (currentBrush.getBrushShape() == BrushShape.CIRCLE) {
                lineBrush = LineBrush.of((Brush)currentBrush, (int)(x2 - x1), (int)(y2 - y1));
            } else {
                MY_CONSTANT_CIRCLE.setRadius(currentBrush.getRadius());
                MY_CONSTANT_CIRCLE.setLevel(currentBrush.getLevel());
                lineBrush = LineBrush.of((Brush)MY_CONSTANT_CIRCLE, (int)(x2 - x1), (int)(y2 - y1));
            }
            this.paint.setBrush((Brush)lineBrush);
            try {
                if (this.undo) {
                    this.paint.remove(dimension, x1 + (x2 - x1) / 2, y1 + (y2 - y1) / 2, dynamicLevel);
                } else {
                    this.paint.apply(dimension, x1 + (x2 - x1) / 2, y1 + (y2 - y1) / 2, dynamicLevel);
                }
            }
            finally {
                this.paint.setBrush(currentBrush);
            }
        }
    }

    public void drawText(Dimension dimension, int x, int y, String text) {
        String[] lines;
        block6: for (String line : lines = text.split("\\n")) {
            int lineHeight = this.drawTextLine(dimension, x, y, line);
            switch (this.textAngle) {
                case 0: {
                    y += lineHeight;
                    continue block6;
                }
                case 1: {
                    x += lineHeight;
                    continue block6;
                }
                case 2: {
                    y -= lineHeight;
                    continue block6;
                }
                case 3: {
                    x -= lineHeight;
                }
            }
        }
    }

    public boolean fill(Dimension dimension, int x, int y, Window parent) {
        AbstractDimensionPaintFillMethod fillMethod;
        if (this.paint instanceof LayerPaint) {
            final Layer layer = ((LayerPaint)this.paint).getLayer();
            switch (layer.getDataSize()) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    if (this.undo) {
                        fillMethod = new UndoDimensionPaintFillMethod("Removing " + layer, dimension, this.paint){

                            @Override
                            public boolean isBoundary(int x, int y) {
                                return !this.dimension.getBitLayerValueAt(layer, x, y);
                            }
                        };
                        break;
                    }
                    fillMethod = new DimensionPaintFillMethod("Applying " + layer, dimension, this.paint){

                        @Override
                        public boolean isBoundary(int x, int y) {
                            return this.dimension.getBitLayerValueAt(layer, x, y);
                        }
                    };
                    break;
                }
                case NIBBLE: 
                case BYTE: {
                    if (this.paint instanceof DiscreteLayerPaint) {
                        final int fillValue = dimension.getLayerValueAt(layer, x, y);
                        if (this.undo) {
                            fillMethod = new UndoDimensionPaintFillMethod("Removing " + layer, dimension, this.paint){

                                @Override
                                public boolean isBoundary(int x, int y) {
                                    return this.dimension.getLayerValueAt(layer, x, y) != fillValue;
                                }

                                @Override
                                boolean isFilled(int x, int y) {
                                    return this.dimension.getLayerValueAt(layer, x, y) == layer.getDefaultValue();
                                }
                            };
                            break;
                        }
                        fillMethod = new DimensionPaintFillMethod("Applying " + layer, dimension, this.paint){

                            @Override
                            public boolean isBoundary(int x, int y) {
                                return this.dimension.getLayerValueAt(layer, x, y) != fillValue;
                            }

                            @Override
                            boolean isFilled(int x, int y) {
                                return this.dimension.getLayerValueAt(layer, x, y) == ((DiscreteLayerPaint)this.paint).getValue();
                            }
                        };
                        break;
                    }
                    if (this.undo) {
                        fillMethod = new UndoDimensionPaintFillMethod("Removing " + layer, dimension, this.paint){

                            @Override
                            public boolean isBoundary(int x, int y) {
                                return this.dimension.getLayerValueAt(layer, x, y) == 0;
                            }
                        };
                        break;
                    }
                    fillMethod = new DimensionPaintFillMethod("Applying " + layer, dimension, this.paint){
                        final int targetValue;
                        {
                            super(description, dimension, paint);
                            this.targetValue = 1 + Math.round(layer.getDataSize() == Layer.DataSize.NIBBLE ? this.paint.getBrush().getLevel() * 14.0f : this.paint.getBrush().getLevel() * 254.0f);
                        }

                        @Override
                        public boolean isBoundary(int x, int y) {
                            return this.dimension.getLayerValueAt(layer, x, y) >= this.targetValue;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know how to fill with layer with data size " + layer.getDataSize());
                }
            }
        } else if (this.paint instanceof TerrainPaint) {
            final Terrain terrainToFill = dimension.getTerrainAt(x, y);
            fillMethod = this.undo ? new UndoDimensionPaintFillMethod("Removing " + terrainToFill, dimension, this.paint){

                @Override
                public boolean isBoundary(int x, int y) {
                    return this.dimension.getTerrainAt(x, y) != terrainToFill;
                }

                @Override
                boolean isFilled(int x, int y) {
                    return this.dimension.getTerrainAt(x, y) == ((TerrainPaint)this.paint).getTerrain();
                }
            } : new DimensionPaintFillMethod("Applying " + ((TerrainPaint)this.paint).getTerrain(), dimension, this.paint){

                @Override
                public boolean isBoundary(int x, int y) {
                    return this.dimension.getTerrainAt(x, y) != terrainToFill;
                }

                @Override
                boolean isFilled(int x, int y) {
                    return this.dimension.getTerrainAt(x, y) == ((TerrainPaint)this.paint).getTerrain();
                }
            };
        } else {
            if (this.paint instanceof PaintFactory.NullPaint) {
                return true;
            }
            throw new IllegalArgumentException("Don't know how to fill with paint " + this.paint);
        }
        if (!fillMethod.isFilled(x, y)) {
            GeneralQueueLinearFloodFiller filler = new GeneralQueueLinearFloodFiller(fillMethod);
            filler.floodFill(x, y, parent);
            return !filler.isBoundsHit();
        }
        return true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public void setTextAngle(int textAngle) {
        if (textAngle < 0 || textAngle > 3) {
            throw new IllegalArgumentException();
        }
        this.textAngle = textAngle;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setUndo(boolean undo) {
        this.undo = undo;
    }

    public boolean isUndo() {
        return this.undo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drawTextLine(Dimension dimension, int x, int y, String text) {
        int textHeight;
        int textWidth;
        Rectangle2D bounds;
        BufferedImage image = new BufferedImage(1000, 100, 12);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        try {
            g2.setFont(this.font);
            FontRenderContext frc = g2.getFontRenderContext();
            bounds = this.font.getStringBounds(text, frc);
            textWidth = (int)Math.ceil(bounds.getWidth());
            textHeight = (int)Math.ceil(bounds.getHeight());
            if (textWidth < 1 || textHeight < 1) {
                int n = (int)bounds.getHeight();
                return n;
            }
            if (textWidth > 1000 || textHeight > 100) {
                g2.dispose();
                image = new BufferedImage(textWidth, textHeight, 12);
                g2 = image.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2.setFont(this.font);
            }
            g2.drawString(text, (int)(-bounds.getX()), (int)(-bounds.getY()));
        }
        finally {
            g2.dispose();
        }
        if (this.undo) {
            for (int xx = 0; xx < textWidth; ++xx) {
                block17: for (int yy = 0; yy < textHeight; ++yy) {
                    if ((image.getRGB(xx, yy) & 1) == 0) continue;
                    switch (this.textAngle) {
                        case 0: {
                            this.paint.removePixel(dimension, x + xx, y + yy);
                            continue block17;
                        }
                        case 1: {
                            this.paint.removePixel(dimension, x + yy, y - xx);
                            continue block17;
                        }
                        case 2: {
                            this.paint.removePixel(dimension, x - xx, y - yy);
                            continue block17;
                        }
                        case 3: {
                            this.paint.removePixel(dimension, x - yy, y + xx);
                        }
                    }
                }
            }
        } else {
            for (int xx = 0; xx < textWidth; ++xx) {
                block19: for (int yy = 0; yy < textHeight; ++yy) {
                    if ((image.getRGB(xx, yy) & 1) == 0) continue;
                    switch (this.textAngle) {
                        case 0: {
                            this.paint.applyPixel(dimension, x + xx, y + yy);
                            continue block19;
                        }
                        case 1: {
                            this.paint.applyPixel(dimension, x + yy, y - xx);
                            continue block19;
                        }
                        case 2: {
                            this.paint.applyPixel(dimension, x - xx, y - yy);
                            continue block19;
                        }
                        case 3: {
                            this.paint.applyPixel(dimension, x - yy, y + xx);
                        }
                    }
                }
            }
        }
        return (int)bounds.getHeight();
    }

    static abstract class AbstractDimensionPaintFillMethod
    implements GeneralQueueLinearFloodFiller.FillMethod {
        private final String description;
        private final Rectangle bounds;
        protected final Dimension dimension;
        protected final Paint paint;

        protected AbstractDimensionPaintFillMethod(String description, Dimension dimension, Paint paint) {
            this.description = description;
            this.dimension = dimension;
            this.paint = paint;
            this.bounds = new Rectangle(dimension.getLowestX() << 7, dimension.getLowestY() << 7, dimension.getWidth() << 7, dimension.getHeight() << 7);
        }

        @Override
        public final Rectangle getBounds() {
            return this.bounds;
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        boolean isFilled(int x, int y) {
            return this.isBoundary(x, y);
        }
    }

    static abstract class UndoDimensionPaintFillMethod
    extends AbstractDimensionPaintFillMethod {
        UndoDimensionPaintFillMethod(String description, Dimension dimension, Paint paint) {
            super(description, dimension, paint);
        }

        @Override
        public final void fill(int x, int y) {
            this.paint.removePixel(this.dimension, x, y);
        }
    }

    static abstract class DimensionPaintFillMethod
    extends AbstractDimensionPaintFillMethod {
        DimensionPaintFillMethod(String description, Dimension dimension, Paint paint) {
            super(description, dimension, paint);
        }

        @Override
        public final void fill(int x, int y) {
            this.paint.applyPixel(this.dimension, x, y);
        }
    }
}

