/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.Rectangle;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.painting.NibbleLayerPaint;

public final class CombinedLayerPaint
extends NibbleLayerPaint {
    public CombinedLayerPaint(CombinedLayer layer) {
        super((Layer)layer);
    }

    @Override
    public void apply(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        boolean biomeConfigured;
        super.apply(dimension, centreX, centreY, dynamicLevel);
        CombinedLayer combinedLayer = (CombinedLayer)this.layer;
        if (combinedLayer.isApplyTerrainAndBiomeOnExport() || this.brush.getRadius() == 0) {
            return;
        }
        Terrain terrain = combinedLayer.getTerrain();
        int biome = combinedLayer.getBiome();
        boolean terrainConfigured = terrain != null;
        boolean bl = biomeConfigured = biome != -1;
        if (!terrainConfigured && !biomeConfigured) {
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            if (this.dither) {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (strength == 0.0f) continue;
                        if (terrainConfigured && (strength > 0.95f || Math.random() < (double)strength)) {
                            tile.setTerrain(x, y, terrain);
                        }
                        if (!biomeConfigured || !(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, biome);
                    }
                }
            } else {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        if (!(dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y) > 0.75f)) continue;
                        if (terrainConfigured) {
                            tile.setTerrain(x, y, terrain);
                        }
                        if (!biomeConfigured) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, biome);
                    }
                }
            }
        } else if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, x, y);
                    if (strength == 0.0f) continue;
                    if (terrainConfigured && (strength > 0.95f || Math.random() < (double)strength)) {
                        dimension.setTerrainAt(x, y, terrain);
                    }
                    if (!biomeConfigured || !(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.setLayerValueAt((Layer)Biome.INSTANCE, x, y, biome);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    if (!(dynamicLevel * this.getFullStrength(centreX, centreY, x, y) > 0.75f)) continue;
                    if (terrainConfigured) {
                        dimension.setTerrainAt(x, y, terrain);
                    }
                    if (!biomeConfigured) continue;
                    dimension.setLayerValueAt((Layer)Biome.INSTANCE, x, y, biome);
                }
            }
        }
    }

    @Override
    public void remove(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        boolean biomeConfigured;
        super.remove(dimension, centreX, centreY, dynamicLevel);
        CombinedLayer combinedLayer = (CombinedLayer)this.layer;
        if (combinedLayer.isApplyTerrainAndBiomeOnExport() || this.brush.getRadius() == 0) {
            return;
        }
        boolean terrainConfigured = combinedLayer.getTerrain() != null;
        boolean bl = biomeConfigured = combinedLayer.getBiome() != -1;
        if (!terrainConfigured && !biomeConfigured) {
            return;
        }
        Rectangle boundingBox = this.brush.getBoundingBox();
        int x1 = centreX + boundingBox.x;
        int y1 = centreY + boundingBox.y;
        int x2 = x1 + boundingBox.width - 1;
        int y2 = y1 + boundingBox.height - 1;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2 && !terrainConfigured) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            if (this.dither) {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (strength == 0.0f || !(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, 255);
                    }
                }
            } else {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        if (!(dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y) > 0.75f)) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, 255);
                    }
                }
            }
        } else if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (strength == 0.0f) continue;
                    if (terrainConfigured && (strength > 0.95f || Math.random() < (double)strength)) {
                        dimension.applyTheme(x, y);
                    }
                    if (!biomeConfigured || !(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.setLayerValueAt((Layer)Biome.INSTANCE, x, y, 255);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    if (!(dynamicLevel * this.getFullStrength(centreX, centreY, x, y) > 0.75f)) continue;
                    if (terrainConfigured) {
                        dimension.applyTheme(x, y);
                    }
                    if (!biomeConfigured) continue;
                    dimension.setLayerValueAt((Layer)Biome.INSTANCE, x, y, 255);
                }
            }
        }
    }

    @Override
    public void applyPixel(Dimension dimension, int x, int y) {
        Tile tile;
        boolean biomeConfigured;
        super.applyPixel(dimension, x, y);
        CombinedLayer combinedLayer = (CombinedLayer)this.layer;
        Terrain terrain = combinedLayer.getTerrain();
        int biome = combinedLayer.getBiome();
        boolean terrainConfigured = terrain != null;
        boolean bl = biomeConfigured = biome != -1;
        if (!combinedLayer.isApplyTerrainAndBiomeOnExport() && (terrainConfigured || biomeConfigured) && (tile = dimension.getTileForEditing(x >> 7, y >> 7)) != null) {
            int xInTile = x & 0x7F;
            int yInTile = y & 0x7F;
            if (terrainConfigured) {
                tile.setTerrain(xInTile, yInTile, terrain);
            }
            if (biomeConfigured) {
                tile.setLayerValue((Layer)Biome.INSTANCE, xInTile, yInTile, biome);
            }
        }
    }

    @Override
    public void removePixel(Dimension dimension, int x, int y) {
        boolean biomeConfigured;
        super.removePixel(dimension, x, y);
        CombinedLayer combinedLayer = (CombinedLayer)this.layer;
        boolean terrainConfigured = combinedLayer.getTerrain() != null;
        boolean bl = biomeConfigured = combinedLayer.getBiome() != -1;
        if (!combinedLayer.isApplyTerrainAndBiomeOnExport() && (terrainConfigured || biomeConfigured)) {
            if (terrainConfigured) {
                dimension.applyTheme(x, y);
                if (biomeConfigured) {
                    dimension.setLayerValueAt((Layer)Biome.INSTANCE, x, y, 255);
                }
            } else {
                Tile tile = dimension.getTileForEditing(x >> 7, y >> 7);
                if (tile != null) {
                    tile.setLayerValue((Layer)Biome.INSTANCE, x & 0x7F, y & 0x7F, 255);
                }
            }
        }
    }
}

