/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;

public class Sponge
extends AbstractBrushOperation {
    private static final JPanel OPTIONS_PANEL = new StandardOptionsPanel("Sponge", "<ul><li>Left-click to remove water and lava<li>Right-click to reset to the default fluid type and height</ul>");

    public Sponge(WorldPainterView view) {
        super("Sponge", "Dry up or reset water and lava", view, 100, "operation.sponge");
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        int minHeight = dimension.getMinHeight();
        TileFactory tileFactory = dimension.getTileFactory();
        int waterHeight = tileFactory instanceof HeightMapTileFactory ? ((HeightMapTileFactory)tileFactory).getWaterHeight() : -1;
        dimension.setEventsInhibited(true);
        try {
            int radius = this.getEffectiveRadius();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    if (this.getStrength(centreX, centreY, centreX + dx, centreY + dy) == 0.0f) continue;
                    if (inverse) {
                        if (waterHeight == -1) continue;
                        dimension.setWaterLevelAt(centreX + dx, centreY + dy, waterHeight);
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, centreX + dx, centreY + dy, false);
                        continue;
                    }
                    dimension.setWaterLevelAt(centreX + dx, centreY + dy, minHeight);
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

