/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;

public class SetSpawnPoint
extends MouseOrTabletOperation {
    private static final JPanel OPTIONS_PANEL = new StandardOptionsPanel("Spawn", "<p>Click to set the location of the initial spawn point");

    public SetSpawnPoint(WorldPainter view) {
        super("Spawn", "Change the spawn point", (WorldPainterView)view, "operation.setSpawnPoint", "spawn");
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        if (first) {
            Dimension dimension = this.getDimension();
            if (dimension == null) {
                return;
            }
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.dim != 0) {
                throw new IllegalArgumentException("Cannot set spawn point on dimensions other than DIM_NORMAL");
            }
            World2 world = dimension.getWorld();
            int spawnHeight = dimension.getIntHeightAt(centreX, centreY);
            if (spawnHeight == Integer.MIN_VALUE && JOptionPane.showConfirmDialog((Component)this.getView(), "<html>Are you sure you want to set the spawn <em>outside</em> the boundary of the world?</html>") != 0) {
                return;
            }
            world.setSpawnPoint(new Point(centreX, centreY));
            world.setSpawnPointDimension(anchor.role == Dimension.Role.DETAIL ? null : anchor);
        }
    }
}

