/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;

public class RaiseRotatedPyramid
extends MouseOrTabletOperation {
    private static final StandardOptionsPanel OPTIONS_PANEL = new StandardOptionsPanel("Raise Rotated Pyramid", "<p>Click to raise a 45&deg; rotated four-sided sandstone pyramid from the ground");

    public RaiseRotatedPyramid(WorldPainter worldPainter) {
        super("Raise Rotated Pyramid", "Raises a square, but rotated 45 degrees, pyramid out of the ground", worldPainter, 100, "operation.raiseRotatedPyramid", "pyramid");
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        float height = dimension.getHeightAt(centreX, centreY);
        dimension.setEventsInhibited(true);
        try {
            if (height < (float)dimension.getMaxHeight() - 1.5f) {
                dimension.setHeightAt(centreX, centreY, height + 1.0f);
            }
            dimension.setTerrainAt(centreX, centreY, Terrain.SANDSTONE);
            int maxR = dimension.getMaxHeight() - dimension.getMinHeight();
            for (int r = 1; r < maxR; ++r) {
                float f = height;
                height = f - 1.0f;
                if (this.raiseRing(dimension, centreX, centreY, r, f)) continue;
                break;
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }

    private boolean raiseRing(Dimension dimension, int x, int y, int r, float desiredHeight) {
        boolean raised = false;
        for (int i = 0; i < r; ++i) {
            float actualHeight = dimension.getHeightAt(x - r + i, y - i);
            if (actualHeight < desiredHeight) {
                raised = true;
                dimension.setHeightAt(x - r + i, y - i, desiredHeight);
                dimension.setTerrainAt(x - r + i, y - i, Terrain.SANDSTONE);
            }
            if ((actualHeight = dimension.getHeightAt(x + i, y - r + i)) < desiredHeight) {
                raised = true;
                dimension.setHeightAt(x + i, y - r + i, desiredHeight);
                dimension.setTerrainAt(x + i, y - r + i, Terrain.SANDSTONE);
            }
            if ((actualHeight = dimension.getHeightAt(x + r - i, y + i)) < desiredHeight) {
                raised = true;
                dimension.setHeightAt(x + r - i, y + i, desiredHeight);
                dimension.setTerrainAt(x + r - i, y + i, Terrain.SANDSTONE);
            }
            if (!((actualHeight = dimension.getHeightAt(x - i, y + r - i)) < desiredHeight)) continue;
            raised = true;
            dimension.setHeightAt(x - i, y + r - i, desiredHeight);
            dimension.setTerrainAt(x - i, y + r - i, Terrain.SANDSTONE);
        }
        return raised;
    }
}

