/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.TerrainShapingOptions;
import org.pepsoft.worldpainter.operations.TerrainShapingOptionsPanel;

public class RaiseMountain
extends AbstractBrushOperation {
    private final PerlinNoise perlinNoise = new PerlinNoise(67L);
    private final TerrainShapingOptions<RaiseMountain> options = new TerrainShapingOptions();
    private final TerrainShapingOptionsPanel optionsPanel;
    private int peakDX;
    private int peakDY;
    private float peakFactor;

    public RaiseMountain(WorldPainter view) {
        super("Raise Mountain", "Raises a mountain out of the ground", view, 100, "operation.raiseMountain", "mountain");
        this.options.setApplyTheme(true);
        this.optionsPanel = new TerrainShapingOptionsPanel("Mountain", "<ul><li>Left-click to raise a mountain in the shape of the brush and its base at bedrock<li>Right-click to dig a hole in the shape of the brush and its base at build height</ul>", this.options);
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        float adjustment = (float)Math.pow(this.getLevel() * dynamicLevel * 2.0f, 2.0);
        int minZ = dimension.getMinHeight();
        int maxRange = dimension.getMaxHeight() - 1 - minZ;
        float peakHeight = dimension.getHeightAt(centreX + this.peakDX, centreY + this.peakDY) - (float)minZ + (inverse ? -adjustment : adjustment);
        if (peakHeight < 0.0f) {
            peakHeight = 0.0f;
        } else if (peakHeight > (float)maxRange) {
            peakHeight = maxRange;
        }
        dimension.setEventsInhibited(true);
        try {
            int radius = this.getEffectiveRadius();
            boolean applyTheme = this.options.isApplyTheme();
            for (int x = centreX - radius; x <= centreX + radius; ++x) {
                for (int y = centreY - radius; y <= centreY + radius; ++y) {
                    float currentHeight = dimension.getHeightAt(x, y);
                    float targetHeight = this.getTargetHeight(minZ, maxRange, centreX, centreY, x, y, peakHeight, inverse);
                    if (!(inverse ? targetHeight < currentHeight : targetHeight > currentHeight)) continue;
                    dimension.setHeightAt(x, y, targetHeight);
                    if (!applyTheme) continue;
                    dimension.applyTheme(x, y);
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }

    @Override
    protected final void brushChanged(Brush brush) {
        super.brushChanged(brush);
        if (brush == null) {
            return;
        }
        int radius = this.getEffectiveRadius();
        float strength = brush.getFullStrength(0, 0);
        if (strength == 1.0f) {
            this.peakDX = 0;
            this.peakDY = 0;
            this.peakFactor = 1.0f;
            return;
        }
        float highestStrength = 0.0f;
        for (int r = 1; r <= radius; ++r) {
            for (int i = -r + 1; i <= r; ++i) {
                strength = brush.getFullStrength(i, -r);
                if (strength > highestStrength) {
                    this.peakDX = i;
                    this.peakDY = -r;
                    this.peakFactor = 1.0f / strength;
                    highestStrength = strength;
                    if (strength == 1.0f) {
                        return;
                    }
                }
                if ((strength = brush.getFullStrength(r, i)) > highestStrength) {
                    this.peakDX = r;
                    this.peakDY = i;
                    this.peakFactor = 1.0f / strength;
                    highestStrength = strength;
                    if (strength == 1.0f) {
                        return;
                    }
                }
                if ((strength = brush.getFullStrength(-i, r)) > highestStrength) {
                    this.peakDX = -i;
                    this.peakDY = r;
                    this.peakFactor = 1.0f / strength;
                    highestStrength = strength;
                    if (strength == 1.0f) {
                        return;
                    }
                }
                if (!((strength = brush.getFullStrength(-r, -i)) > highestStrength)) continue;
                this.peakDX = -r;
                this.peakDY = -i;
                this.peakFactor = 1.0f / strength;
                highestStrength = strength;
                if (strength != 1.0f) continue;
                return;
            }
        }
    }

    private float getTargetHeight(int minZ, int maxRange, int centerX, int centerY, int x, int y, float peakHeight, boolean undo) {
        return (undo ? Math.max((float)maxRange - ((float)maxRange - peakHeight) * this.peakFactor * this.getNoisyStrength(x, y, this.getBrush().getFullStrength(x - centerX, y - centerY)), 0.0f) : Math.min(peakHeight * this.peakFactor * this.getNoisyStrength(x, y, this.getBrush().getFullStrength(x - centerX, y - centerY)), (float)maxRange)) + (float)minZ;
    }

    private float getNoisyStrength(int x, int y, float strength) {
        float allowableNoiseRange = (0.5f - Math.abs(strength - 0.5f)) / 5.0f;
        float noise = this.perlinNoise.getPerlinNoise((double)((float)x / 32.771f), (double)((float)y / 32.771f));
        if ((double)(strength += noise * allowableNoiseRange * strength) < 0.0) {
            return 0.0f;
        }
        if ((double)strength > 1.0) {
            return 1.0f;
        }
        return strength;
    }
}

