/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Point;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.AbstractPaintOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.painting.DimensionPainter;
import org.pepsoft.worldpainter.painting.Paint;

public class Pencil
extends AbstractPaintOperation {
    private final DimensionPainter painter = new DimensionPainter();
    private int previousX = Integer.MIN_VALUE;
    private int previousY = Integer.MIN_VALUE;
    private int lockedX = Integer.MIN_VALUE;
    private int lockedY = Integer.MIN_VALUE;
    private Axis lockedAxis;
    private boolean inhibitDrag;
    private boolean fastMode = true;
    private final StandardOptionsPanel optionsPanel = new StandardOptionsPanel("Pencil", "<ul><li>Drag for freeform lines\n<li>Click for dots\n<li>Shift+click for straight lines\n<li>Hold Ctrl for 45 degree angles</ul>\n<p>Right mouse button undoes.\n"){

        @Override
        protected void addAdditionalComponents(GridBagConstraints constraints) {
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton buttonFast = new JRadioButton("Fast mode", true);
            buttonFast.addActionListener(event -> {
                Pencil.this.fastMode = true;
            });
            buttonGroup.add(buttonFast);
            this.add((Component)buttonFast, constraints);
            this.add((Component)new JLabel("<html><em>Much faster but only supports circular brushes for lines</em></html>"), constraints);
            JRadioButton buttonSlow = new JRadioButton("Slow mode");
            buttonSlow.addActionListener(event -> {
                Pencil.this.fastMode = false;
            });
            buttonGroup.add(buttonSlow);
            this.add((Component)buttonSlow, constraints);
            this.add((Component)new JLabel("<html><em>Very slow but accurate</em></html>"), constraints);
        }
    };

    public Pencil(WorldPainterView view) {
        super("Pencil", "Draw dots and straight or freehand lines with any terrain or layer", view, 100, "operation.pencil");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean undo, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        dimension.setEventsInhibited(true);
        try {
            this.painter.setUndo(undo);
            if (first) {
                this.lockedX = centreX;
                this.lockedY = centreY;
                this.lockedAxis = null;
                if (this.isShiftDown()) {
                    if (this.previousX != Integer.MIN_VALUE && this.previousY != Integer.MIN_VALUE) {
                        if (this.isCtrlDown()) {
                            int[] snappedCoords = this.snapCoords(this.previousX, this.previousY, centreX, centreY, this.getAxis(this.previousX, this.previousY, centreX, centreY));
                            centreX = snappedCoords[0];
                            centreY = snappedCoords[1];
                        }
                        this.painter.drawLine(dimension, this.previousX, this.previousY, centreX, centreY, this.fastMode);
                    }
                    this.inhibitDrag = true;
                } else {
                    this.painter.drawPoint(dimension, centreX, centreY);
                    this.inhibitDrag = false;
                }
                this.previousX = centreX;
                this.previousY = centreY;
            } else if (!this.inhibitDrag) {
                if (this.isCtrlDown()) {
                    if (this.lockedAxis == null) {
                        this.lockedAxis = this.getAxis(this.lockedX, this.lockedY, centreX, centreY);
                    }
                    int[] snappedCoords = this.snapCoords(this.lockedX, this.lockedY, centreX, centreY, this.lockedAxis);
                    centreX = snappedCoords[0];
                    centreY = snappedCoords[1];
                }
                if (centreX != this.previousX || centreY != this.previousY) {
                    if (Math.abs(centreX - this.previousX) <= 1 && Math.abs(centreY - this.previousY) <= 1) {
                        this.painter.drawPoint(dimension, centreX, centreY);
                    } else {
                        this.painter.drawLine(dimension, this.previousX, this.previousY, centreX, centreY, this.fastMode);
                    }
                    this.previousX = centreX;
                    this.previousY = centreY;
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }

    @Override
    protected void paintChanged(Paint newPaint) {
        newPaint.setDither(false);
        this.painter.setPaint(this.getPaint());
    }

    private Axis getAxis(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        double angle = Math.atan((double)(y2 - y1) / (double)(x2 - x1));
        if (x2 < x1) {
            angle += Math.PI;
        } else if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        switch ((int)Math.round(angle * 4.0 / Math.PI)) {
            case 0: 
            case 4: 
            case 8: {
                return Axis.W_E;
            }
            case 1: 
            case 5: {
                return Axis.NW_SE;
            }
            case 2: 
            case 6: {
                return Axis.N_S;
            }
            case 3: 
            case 7: {
                return Axis.NE_SW;
            }
        }
        throw new InternalError();
    }

    private int[] snapCoords(int x1, int y1, int x2, int y2, Axis axis) {
        if (axis == null) {
            return new int[]{x2, y2};
        }
        switch (axis) {
            case W_E: {
                return new int[]{x2, y1};
            }
            case NW_SE: {
                Point closestPoint = this.closestPoint(new Point(x1, y1), new Point(x1 + 1000, y1 + 1000), new Point(x2, y2));
                return new int[]{closestPoint.x, closestPoint.y};
            }
            case N_S: {
                return new int[]{x1, y2};
            }
            case NE_SW: {
                Point closestPoint = this.closestPoint(new Point(x1, y1), new Point(x1 + 1000, y1 - 1000), new Point(x2, y2));
                return new int[]{closestPoint.x, closestPoint.y};
            }
        }
        throw new IllegalArgumentException();
    }

    private Point closestPoint(Point p1, Point p2, Point p3) {
        double xDelta = p2.getX() - p1.getX();
        double yDelta = p2.getY() - p1.getY();
        if (xDelta == 0.0 && yDelta == 0.0) {
            throw new IllegalArgumentException("p1 and p2 cannot be the same point");
        }
        double u = ((p3.getX() - p1.getX()) * xDelta + (p3.getY() - p1.getY()) * yDelta) / (xDelta * xDelta + yDelta * yDelta);
        return new Point((int)Math.round(p1.getX() + u * xDelta), (int)Math.round(p1.getY() + u * yDelta));
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    static enum Axis {
        W_E,
        NW_SE,
        N_S,
        NE_SW;

    }
}

