/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pepsoft.worldpainter.operations.Operation;
import org.pepsoft.worldpainter.plugins.OperationProvider;
import org.pepsoft.worldpainter.plugins.WPPluginManager;

public class OperationManager {
    private final List<Operation> operations;
    private final Map<String, Operation> operationsByName = new HashMap<String, Operation>();
    private static final OperationManager INSTANCE = new OperationManager();

    private OperationManager() {
        this.operations = new ArrayList<Operation>();
        List operationProviders = WPPluginManager.getInstance().getPlugins(OperationProvider.class);
        for (OperationProvider operationProvider : operationProviders) {
            this.operations.addAll(operationProvider.getOperations());
        }
        for (Operation operation : this.operations) {
            this.operationsByName.put(operation.getName(), operation);
        }
    }

    public List<Operation> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public Operation getOperation(String name) {
        return this.operationsByName.get(name);
    }

    public static OperationManager getInstance() {
        return INSTANCE;
    }
}

