/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.PScrollEvent;
import jpen.event.PenListener;
import jpen.owner.multiAwt.AwtPenToolkit;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.AbstractOperation;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MouseOrTabletOperation
extends AbstractOperation
implements PenListener,
MouseListener,
MouseMotionListener {
    protected final boolean legacy;
    private final int delay;
    private final boolean oneShot;
    private final String statisticsKey;
    private final String statisticsKeyUndo;
    private volatile Timer timer;
    private volatile boolean altDown;
    private volatile boolean ctrlDown;
    private volatile boolean shiftDown;
    private volatile boolean first = true;
    private volatile boolean undo;
    private volatile float dynamicLevel = 1.0f;
    private volatile float x;
    private volatile float y;
    private float level = 1.0f;
    private volatile int operationStartedWithButton;
    private static final Map<String, Long> operationCounts = new HashMap<String, Long>();
    private static final Logger logger = LoggerFactory.getLogger(MouseOrTabletOperation.class);

    protected MouseOrTabletOperation(String name, String description, String statisticsKey, String iconName) {
        this(name, description, -1, true, statisticsKey, iconName);
    }

    protected MouseOrTabletOperation(String name, String description, int delay, String statisticsKey, String iconName) {
        this(name, description, delay, false, statisticsKey, iconName);
    }

    protected MouseOrTabletOperation(String name, String description, String statisticsKey) {
        this(name, description, -1, true, statisticsKey, null);
    }

    protected MouseOrTabletOperation(String name, String description, int delay, String statisticsKey) {
        this(name, description, delay, false, statisticsKey, null);
    }

    @Deprecated
    protected MouseOrTabletOperation(String name, String description, WorldPainterView view, String statisticsKey) {
        this(name, description, -1, true, statisticsKey, null);
        this.setView(view);
    }

    @Deprecated
    protected MouseOrTabletOperation(String name, String description, WorldPainterView view, String statisticsKey, String iconName) {
        this(name, description, -1, true, statisticsKey, iconName);
        this.setView(view);
    }

    @Deprecated
    protected MouseOrTabletOperation(String name, String description, WorldPainterView view, int delay, String statisticsKey) {
        this(name, description, delay, false, statisticsKey, null);
        this.setView(view);
    }

    @Deprecated
    protected MouseOrTabletOperation(String name, String description, WorldPainterView view, int delay, String statisticsKey, String iconName) {
        this(name, description, delay, false, statisticsKey, iconName);
        this.setView(view);
    }

    private MouseOrTabletOperation(String name, String description, int delay, boolean oneshot, String statisticsKey, String iconName) {
        super(name, description, iconName != null ? iconName : name.toLowerCase().replaceAll("\\s", ""));
        this.delay = delay;
        this.oneShot = oneshot;
        this.statisticsKey = statisticsKey;
        this.statisticsKeyUndo = statisticsKey + ".undo";
        boolean bl = this.legacy = SystemUtils.isMac() && System.getProperty("os.version").startsWith("10.4.") || "true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.disableTabletSupport")) || SystemUtils.isLinux() && System.getenv("XDG_SESSION_TYPE") != null && System.getenv("XDG_SESSION_TYPE").equalsIgnoreCase("wayland");
        if (this.legacy) {
            logger.warn("Tablet support disabled for operation " + name);
        }
    }

    @Override
    public void setView(WorldPainterView view) {
        if (this.getView() != null) {
            this.deactivate();
        }
        super.setView(view);
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.level = level;
    }

    public void interrupt() {
        if (this.timer != null) {
            AwtUtils.doOnEventThreadAndWait(() -> {
                if (this.timer != null) {
                    MouseOrTabletOperation.logOperation(this.undo ? this.statisticsKeyUndo : this.statisticsKey);
                    this.timer.stop();
                    this.timer = null;
                    this.finished();
                    Dimension dimension = this.getDimension();
                    if (dimension != null) {
                        dimension.armSavePoint();
                    }
                    App.getInstance().resumeAutosave();
                }
            });
        }
    }

    public void penLevelEvent(PLevelEvent ple) {
        block5: for (PLevel pLevel : ple.levels) {
            switch ((PLevel.Type)pLevel.getType()) {
                case PRESSURE: {
                    this.dynamicLevel = ((Float)pLevel.value).floatValue();
                    continue block5;
                }
                case X: {
                    this.x = ((Float)pLevel.value).floatValue();
                    continue block5;
                }
                case Y: {
                    this.y = ((Float)pLevel.value).floatValue();
                    continue block5;
                }
            }
        }
    }

    public void penButtonEvent(PButtonEvent pbe) {
        boolean eraser;
        PKind.Type penKindType = (PKind.Type)pbe.pen.getKind().getType();
        boolean stylus = penKindType == PKind.Type.STYLUS;
        boolean bl = eraser = penKindType == PKind.Type.ERASER;
        if (!stylus && !eraser && penKindType != PKind.Type.CURSOR) {
            return;
        }
        PButton.Type buttonType = (PButton.Type)pbe.button.getType();
        switch (buttonType) {
            case ALT: {
                this.altDown = (Boolean)pbe.button.value;
                break;
            }
            case CONTROL: {
                this.ctrlDown = (Boolean)pbe.button.value;
                break;
            }
            case SHIFT: {
                this.shiftDown = (Boolean)pbe.button.value;
                break;
            }
            case LEFT: 
            case RIGHT: {
                if (((Boolean)pbe.button.value).booleanValue()) {
                    this.first = true;
                    this.undo = eraser || buttonType == PButton.Type.RIGHT || this.altDown;
                    WorldPainterView view = this.getView();
                    if (!this.oneShot) {
                        this.interrupt();
                        this.timer = new Timer(this.delay, e -> {
                            Point worldCoords = view.viewToWorld((int)this.x, (int)this.y);
                            this.tick(worldCoords.x, worldCoords.y, this.undo, this.first, stylus || eraser ? this.dynamicLevel : 1.0f);
                            view.updateStatusBar(worldCoords.x, worldCoords.y);
                            this.first = false;
                        });
                        this.timer.setInitialDelay(0);
                        this.timer.start();
                        this.operationStartedWithButton = buttonType.ordinal();
                        App.getInstance().pauseAutosave();
                        break;
                    }
                    Point worldCoords = view.viewToWorld((int)this.x, (int)this.y);
                    SwingUtilities.invokeLater(() -> {
                        App.getInstance().pauseAutosave();
                        try {
                            this.tick(worldCoords.x, worldCoords.y, this.undo, true, 1.0f);
                            view.updateStatusBar(worldCoords.x, worldCoords.y);
                            Dimension dimension = this.getDimension();
                            if (dimension != null) {
                                dimension.armSavePoint();
                            }
                            MouseOrTabletOperation.logOperation(this.undo ? this.statisticsKeyUndo : this.statisticsKey);
                        }
                        finally {
                            App.getInstance().resumeAutosave();
                        }
                    });
                    break;
                }
                if (buttonType.ordinal() != this.operationStartedWithButton) break;
                this.interrupt();
            }
        }
    }

    public void penKindEvent(PKindEvent pke) {
    }

    public void penScrollEvent(PScrollEvent pse) {
    }

    public void penTock(long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent me) {
        if (me.getButton() != 1 && me.getButton() != 3) {
            return;
        }
        this.x = me.getX();
        this.y = me.getY();
        this.altDown = me.isAltDown() || me.isAltGraphDown();
        this.undo = me.getButton() == 3 || this.altDown;
        this.ctrlDown = me.isControlDown() || me.isMetaDown();
        this.shiftDown = me.isShiftDown();
        this.first = true;
        WorldPainterView view = this.getView();
        if (!this.oneShot) {
            this.interrupt();
            this.timer = new Timer(this.delay, e -> {
                Point worldCoords = view.viewToWorld((int)this.x, (int)this.y);
                this.tick(worldCoords.x, worldCoords.y, this.undo, this.first, 1.0f);
                view.updateStatusBar(worldCoords.x, worldCoords.y);
                this.first = false;
            });
            this.timer.setInitialDelay(0);
            this.timer.start();
            this.operationStartedWithButton = me.getButton();
            App.getInstance().pauseAutosave();
        } else {
            Point worldCoords = view.viewToWorld((int)this.x, (int)this.y);
            App.getInstance().pauseAutosave();
            try {
                this.tick(worldCoords.x, worldCoords.y, this.undo, true, 1.0f);
                view.updateStatusBar(worldCoords.x, worldCoords.y);
                Dimension dimension = this.getDimension();
                if (dimension != null) {
                    dimension.armSavePoint();
                }
                MouseOrTabletOperation.logOperation(this.undo ? this.statisticsKeyUndo : this.statisticsKey);
            }
            finally {
                App.getInstance().resumeAutosave();
            }
        }
        me.consume();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.getButton() != 1 && me.getButton() != 3) {
            return;
        }
        if (me.getButton() == this.operationStartedWithButton) {
            this.interrupt();
            me.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.x = me.getX();
        this.y = me.getY();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.altDown = me.isAltDown() || me.isAltGraphDown();
        this.ctrlDown = me.isControlDown() || me.isMetaDown();
        this.shiftDown = me.isShiftDown();
    }

    @Override
    protected void activate() throws PropertyVetoException {
        WorldPainterView view = this.getView();
        if (this.legacy) {
            view.addMouseListener((MouseListener)this);
            view.addMouseMotionListener((MouseMotionListener)this);
        } else {
            AwtPenToolkit.addPenListener((Component)view, (PenListener)this);
        }
        this.shiftDown = false;
        this.ctrlDown = false;
        this.altDown = false;
    }

    @Override
    protected void deactivate() {
        this.interrupt();
        WorldPainterView view = this.getView();
        if (this.legacy) {
            view.removeMouseMotionListener((MouseMotionListener)this);
            view.removeMouseListener((MouseListener)this);
        } else {
            AwtPenToolkit.removePenListener((Component)view, (PenListener)this);
        }
    }

    protected abstract void tick(int var1, int var2, boolean var3, boolean var4, float var5);

    protected void finished() {
    }

    protected final boolean isAltDown() {
        return this.altDown;
    }

    protected final boolean isCtrlDown() {
        return this.ctrlDown;
    }

    protected final boolean isShiftDown() {
        return this.shiftDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushEvents(EventLogger eventLogger) {
        Map<String, Long> map = operationCounts;
        synchronized (map) {
            for (Map.Entry<String, Long> entry : operationCounts.entrySet()) {
                eventLogger.logEvent(new EventVO(entry.getKey()).count(entry.getValue().longValue()));
            }
            operationCounts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logOperation(String key) {
        Map<String, Long> map = operationCounts;
        synchronized (map) {
            if (operationCounts.containsKey(key)) {
                operationCounts.put(key, operationCounts.get(key) + 1L);
            } else {
                operationCounts.put(key, 1L);
            }
        }
    }
}

