/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.TerrainShapingOptions;
import org.pepsoft.worldpainter.operations.TerrainShapingOptionsPanel;
import org.pepsoft.worldpainter.panels.DefaultFilter;

public class Height
extends AbstractBrushOperation {
    private final TerrainShapingOptions<Height> options = new TerrainShapingOptions();
    private final TerrainShapingOptionsPanel optionsPanel = new TerrainShapingOptionsPanel("Height", "<ul><li>Left-click to raise the terrain<li>Right-click to lower the terrain</ul>", this.options);

    public Height(WorldPainter view) {
        super("Height", "Raise or lower the terrain", (WorldPainterView)view, 100, "operation.height");
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        float maxZ;
        float minZ;
        float adjustment = (float)Math.pow(dynamicLevel * this.getLevel() * 2.0f, 2.0);
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        if (this.getFilter() instanceof DefaultFilter) {
            DefaultFilter filter = (DefaultFilter)this.getFilter();
            minZ = filter.getAboveLevel() != Integer.MIN_VALUE ? (float)Math.max(filter.getAboveLevel(), dimension.getMinHeight()) : (float)dimension.getMinHeight();
            maxZ = filter.getBelowLevel() != Integer.MIN_VALUE ? (float)Math.min(filter.getBelowLevel(), dimension.getMaxHeight()) : (float)(dimension.getMaxHeight() - 1);
        } else {
            minZ = dimension.getMinHeight();
            maxZ = dimension.getMaxHeight() - 1;
        }
        boolean applyTheme = this.options.isApplyTheme();
        dimension.setEventsInhibited(true);
        try {
            int radius = this.getEffectiveRadius();
            for (int x = centreX - radius; x <= centreX + radius; ++x) {
                for (int y = centreY - radius; y <= centreY + radius; ++y) {
                    float currentHeight = dimension.getHeightAt(x, y);
                    float targetHeight = inverse ? Math.max(currentHeight - adjustment, minZ) : Math.min(currentHeight + adjustment, maxZ);
                    float strength = this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.0f)) continue;
                    float newHeight = strength * targetHeight + (1.0f - strength) * currentHeight;
                    if (!(inverse ? newHeight < currentHeight : newHeight > currentHeight)) continue;
                    dimension.setHeightAt(x, y, newHeight);
                    if (!applyTheme) continue;
                    dimension.applyTheme(x, y);
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

