/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class FontListCellRenderer
extends DefaultListCellRenderer {
    private final Map<String, Font> fontCache = new HashMap<String, Font>();
    private final int size;

    public FontListCellRenderer(int size) {
        this.size = size;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            Font font = this.fontCache.get(value);
            if (font == null) {
                font = new Font((String)value, 0, this.size);
                this.fontCache.put((String)value, font);
            }
            this.setFont(font);
        }
        return this;
    }
}

