/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.TerrainShapingOptions;
import org.pepsoft.worldpainter.operations.TerrainShapingOptionsPanel;

public class Flatten
extends AbstractBrushOperation {
    private final TerrainShapingOptions<Flatten> options = new TerrainShapingOptions();
    private final TerrainShapingOptionsPanel optionsPanel = new TerrainShapingOptionsPanel("Flatten", "<p>Click to flatten the terrain", this.options);
    private float targetHeight = -3.4028235E38f;

    public Flatten(WorldPainter view) {
        super("Flatten", "Flatten an area", (WorldPainterView)view, 100, "operation.flatten");
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        if (first) {
            this.targetHeight = dimension.getHeightAt(centreX, centreY);
            if (this.targetHeight == -3.4028235E38f) {
                DesktopUtils.beep();
            }
        }
        if (this.targetHeight == -3.4028235E38f) {
            return;
        }
        dimension.setEventsInhibited(true);
        try {
            int radius = this.getEffectiveRadius();
            boolean applyTheme = this.options.isApplyTheme();
            for (int x = centreX - radius; x <= centreX + radius; ++x) {
                for (int y = centreY - radius; y <= centreY + radius; ++y) {
                    float currentHeight = dimension.getHeightAt(x, y);
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, x, y);
                    if (!(strength > 0.0f)) continue;
                    float newHeight = strength * this.targetHeight + (1.0f - strength) * currentHeight;
                    dimension.setHeightAt(x, y, newHeight);
                    if (!applyTheme) continue;
                    dimension.applyTheme(x, y);
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

