/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.operations.PaintOperation;
import org.pepsoft.worldpainter.painting.Paint;

public abstract class AbstractPaintOperation
extends AbstractBrushOperation
implements PaintOperation {
    private Paint paint;

    protected AbstractPaintOperation(String name, String description, int delay, String statisticsKey) {
        super(name, description, delay, statisticsKey);
    }

    @Deprecated
    protected AbstractPaintOperation(String name, String description, WorldPainterView view, int delay, String statisticsKey) {
        super(name, description, view, delay, statisticsKey);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.getBrush() != null) {
            paint.setBrush(this.getBrush());
        }
        if (this.getFilter() != null) {
            paint.setFilter(this.getFilter());
        }
        this.paintChanged(paint);
    }

    @Override
    protected void brushChanged(Brush newBrush) {
        super.brushChanged(newBrush);
        if (this.paint != null) {
            this.paint.setBrush(newBrush);
        }
    }

    @Override
    public void setFilter(Filter filter) {
        super.setFilter(filter);
        if (this.paint != null) {
            this.paint.setFilter(filter);
        }
    }

    protected void paintChanged(Paint newPaint) {
    }
}

