/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import org.pepsoft.worldpainter.MapDragControl;
import org.pepsoft.worldpainter.RadiusControl;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.operations.BrushOperation;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.operations.FilteredOperation;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;

public abstract class AbstractBrushOperation
extends MouseOrTabletOperation
implements BrushOperation,
FilteredOperation {
    private RadiusControl radiusControl;
    private MapDragControl mapDragControl;
    private Brush brush;
    private int radius;
    private boolean filterEnabled;
    private Filter filter = null;

    protected AbstractBrushOperation(String name, String description, String statisticsKey) {
        super(name, description, statisticsKey);
    }

    protected AbstractBrushOperation(String name, String description, String statisticsKey, String iconName) {
        super(name, description, statisticsKey, iconName);
    }

    protected AbstractBrushOperation(String name, String description, int delay, String statisticsKey) {
        super(name, description, delay, statisticsKey);
    }

    protected AbstractBrushOperation(String name, String description, int delay, String statisticsKey, String iconName) {
        super(name, description, delay, statisticsKey, iconName);
    }

    @Deprecated
    protected AbstractBrushOperation(String name, String description, WorldPainterView view, String statisticsKey) {
        super(name, description, view, statisticsKey);
    }

    @Deprecated
    protected AbstractBrushOperation(String name, String description, WorldPainterView view, String statisticsKey, String iconName) {
        super(name, description, view, statisticsKey, iconName);
    }

    @Deprecated
    protected AbstractBrushOperation(String name, String description, WorldPainterView view, int delay, String statisticsKey) {
        super(name, description, view, delay, statisticsKey);
    }

    @Deprecated
    protected AbstractBrushOperation(String name, String description, WorldPainterView view, int delay, String statisticsKey, String iconName) {
        super(name, description, view, delay, statisticsKey, iconName);
    }

    public final float getStrength(int centerX, int centerY, int x, int y) {
        return this.filterEnabled ? this.filter.modifyStrength(x, y, this.getBrush().getStrength(x - centerX, y - centerY)) : this.getBrush().getStrength(x - centerX, y - centerY);
    }

    public final float getFullStrength(int centerX, int centerY, int x, int y) {
        return this.filterEnabled ? this.filter.modifyStrength(x, y, this.getBrush().getFullStrength(x - centerX, y - centerY)) : this.getBrush().getFullStrength(x - centerX, y - centerY);
    }

    public final int getEffectiveRadius() {
        return this.getBrush() != null ? this.getBrush().getEffectiveRadius() : this.radius;
    }

    @Override
    public final Brush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(Brush brush) {
        this.brush = brush;
        if (brush != null) {
            brush.setLevel(this.getLevel());
        }
        this.brushChanged(brush);
    }

    @Override
    public final int getRadius() {
        return this.radius;
    }

    @Override
    public final void setRadius(int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException();
        }
        this.radius = radius;
        Brush brush = this.getBrush();
        if (brush != null) {
            brush.setRadius(radius);
            this.brushChanged(brush);
        }
    }

    @Override
    public void setView(WorldPainterView view) {
        super.setView(view);
        this.radiusControl = view.getRadiusControl();
        this.mapDragControl = view.getMapDragControl();
    }

    @Override
    public void setLevel(float level) {
        super.setLevel(level);
        if (this.brush != null) {
            this.brush.setLevel(level);
        }
    }

    @Override
    public void penKindEvent(PKindEvent pke) {
        PKind.Type type = (PKind.Type)pke.kind.getType();
        if (type != PKind.Type.ERASER && type != PKind.Type.STYLUS) {
            SwingUtilities.invokeLater(() -> this.mapDragControl.setMapDraggingInhibited(false));
        }
        super.penKindEvent(pke);
    }

    @Override
    public void penButtonEvent(PButtonEvent pbe) {
        PKind.Type penKindType = (PKind.Type)pbe.pen.getKind().getType();
        PButton.Type buttonType = (PButton.Type)pbe.button.getType();
        if (!(!((Boolean)pbe.button.value).booleanValue() || penKindType != PKind.Type.STYLUS && penKindType != PKind.Type.ERASER || buttonType != PButton.Type.CENTER && buttonType != PButton.Type.RIGHT)) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    if (buttonType == PButton.Type.CENTER) {
                        this.radiusControl.decreaseRadius(1);
                    } else {
                        this.radiusControl.increaseRadius(1);
                    }
                    if (!this.mapDragControl.isMapDraggingInhibited()) {
                        this.mapDragControl.setMapDraggingInhibited(true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread interrupted while processing radius event", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while processing radius event", e);
            }
        } else {
            super.penButtonEvent(pbe);
        }
    }

    @Override
    protected void deactivate() {
        this.mapDragControl.setMapDraggingInhibited(false);
        super.deactivate();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
        this.filterEnabled = filter != null;
    }

    protected void brushChanged(Brush newBrush) {
        if (newBrush != null) {
            newBrush.setRadius(this.radius);
        }
    }
}

