/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.layers.bo2.Bo2Object;
import org.pepsoft.worldpainter.objects.WPObject;

public class WPObjectRenderer {
    private final WPObject object;
    private final Point3i dim;
    private final int width;
    private final int height;
    private final ColourScheme colourScheme;
    private final int blockSize;

    public WPObjectRenderer(WPObject object, ColourScheme colourScheme, int blockSize) {
        this.object = object;
        this.dim = object.getDimensions();
        this.colourScheme = colourScheme;
        this.blockSize = blockSize;
        this.width = this.getImageCoordinates((int)(this.dim.x - 1), (int)0, (int)0).x + 2 * blockSize;
        this.height = -this.getImageCoordinates((int)(this.dim.x - 1), (int)(this.dim.y - 1), (int)(this.dim.z - 1)).y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage render() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g2 = image.createGraphics();
        try {
            for (int z = 0; z < this.dim.z; ++z) {
                for (int y = this.dim.y - 1; y >= 0; --y) {
                    for (int x = this.dim.x - 1; x >= 0; --x) {
                        if (!this.object.getMask(x, this.dim.y - y - 1, z)) continue;
                        Material material = this.object.getMaterial(x, this.dim.y - y - 1, z);
                        if (material.empty) continue;
                        Point coords = this.getImageCoordinates(x, y, z);
                        int blockType = material.blockType;
                        int alpha = blockType == 18 || blockType == 161 ? 192 : 255;
                        this.paintBlock(g2, coords.x, coords.y, material, alpha);
                    }
                }
            }
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    private void paintBlock(Graphics2D g2, int x, int y, Material material, int alpha) {
        int dx;
        Color colour;
        if (alpha < 255) {
            colour = new Color(this.colourScheme.getColour(material) | alpha << 24, true);
            g2.setColor(new Color(colour.brighter().getRGB() | alpha << 24, true));
        } else {
            colour = new Color(this.colourScheme.getColour(material));
            g2.setColor(colour.brighter());
        }
        for (dx = 0; dx < this.blockSize; ++dx) {
            g2.drawLine(x + dx, y + this.blockSize + dx, x + dx, y + this.blockSize * 2 - 1 + dx);
        }
        if (alpha < 255) {
            g2.setColor(new Color(colour.darker().getRGB() | alpha << 24, true));
        } else {
            g2.setColor(colour.darker());
        }
        for (dx = 0; dx < this.blockSize; ++dx) {
            g2.drawLine(x + this.blockSize * 2 - 1 - dx, y + this.blockSize + dx, x + this.blockSize * 2 - 1 - dx, y + this.blockSize * 2 - 1 + dx);
        }
        g2.setColor(colour);
        for (int i = 0; i < this.blockSize; ++i) {
            g2.drawLine(x + this.blockSize - 1 - i, y + i, x + this.blockSize + i, y + i);
            if (i >= this.blockSize - 1) continue;
            g2.drawLine(x + this.blockSize - 1 - i, y + (this.blockSize - 1) * 2 - i, x + this.blockSize + i, y + (this.blockSize - 1) * 2 - i);
        }
    }

    private Point getImageCoordinates(int x, int y, int z) {
        return new Point((x + this.dim.y - 1 - y) * this.blockSize, this.height - 1 - ((y + x + z + 3) * this.blockSize - 2));
    }

    public static void main(String[] args) throws IOException {
        Bo2Object object = Bo2Object.load((File)new File("/home/pepijn/NetBeansProjects/Minecraft/BOBPlugins/wessex_tallredwood.bo2"));
        ColourScheme colourScheme = ColourScheme.DEFAULT;
        WPObjectRenderer renderer = new WPObjectRenderer((WPObject)object, colourScheme, 10);
        BufferedImage image = renderer.render();
        ImageIcon icon = new ImageIcon(image);
        JLabel label = new JLabel(icon);
        JFrame frame = new JFrame("WPObjectRenderer Test");
        frame.getContentPane().add((Component)label, "Center");
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

