/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeListCellRenderer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.DimensionPropertiesDialog;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialChooser;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.NoiseSettingsTableCellRenderer;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.LayerTableCellRenderer;
import org.pepsoft.worldpainter.layers.renderers.PaintPicker;
import org.pepsoft.worldpainter.layers.tunnel.FloatingLayerExporter;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerDialog;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayersTableModel;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.JSpinnerTableCellEditor;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class FloatingLayerDialog
extends TunnelLayerDialog {
    private JButton buttonAddRoofLayer;
    private JButton buttonCancel;
    private JButton buttonEditRoofLayer;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JButton buttonNewRoofLayer;
    private JButton buttonOK;
    private JButton buttonRemoveRoofLayer;
    private JButton buttonReset;
    private JCheckBox checkBoxApplyBiomesSubsurface;
    private JCheckBox checkBoxApplyBiomesSurface;
    private JCheckBox checkBoxBeaches;
    private JCheckBox checkBoxFloodWithLava1;
    private JComboBox<Integer> comboBoxBiome1;
    private JComboBox<Terrain> comboBoxTerrain;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel labelEditDimensionProperties;
    private JLabel labelPreview;
    private MixedMaterialChooser mixedMaterialChooserBottom;
    private NoiseSettingsEditor noiseSettingsEditorBottom;
    private PaintPicker paintPicker1;
    private JRadioButton radioButtonBottomFixedHeight;
    private JRadioButton radioButtonBottomFixedLevel;
    private JRadioButton radioButtonLinearEdge;
    private JRadioButton radioButtonRoundedEdge;
    private JRadioButton radioButtonSheerEdge;
    private JRadioButton radioButtonSmoothEdge;
    private JSpinner spinnerBiomeHeight;
    private JSpinner spinnerBottomLevel;
    private JSpinner spinnerBottomMax;
    private JSpinner spinnerBottomMin;
    private JSpinner spinnerEdgeWidth;
    private JSpinner spinnerFloodLevel1;
    private JSpinner spinnerFloorLevel;
    private JSpinner spinnerRange;
    private JSpinner spinnerScale;
    private JTable tableRoofLayers;
    private JTextField textFieldName;
    private static final String PAINT_FLOATING_LAYER_KEY = "org.pepsoft.worldpainter.FloatingLayer.paintLayer";
    private static final long FLOOR_DIMENSION_SEED_OFFSET = 27981L;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatingLayerDialog(Window parent, Platform platform, TunnelLayer layer, Dimension dimension, boolean extendedBlockIds, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int minHeight, int maxHeight, int baseHeight, int waterLevel) {
        super(parent, platform, layer, dimension, extendedBlockIds, colourScheme, customBiomeManager, minHeight, maxHeight, baseHeight, waterLevel, false);
        this.programmaticChange = true;
        try {
            this.initComponents();
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            this.comboBoxTerrain.setRenderer(new TerrainListCellRenderer(colourScheme));
            this.comboBoxTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.getConfiguredValues()));
            this.comboBoxBiome1.setRenderer(new BiomeListCellRenderer(colourScheme, null, "automatic", platform));
            this.comboBoxBiome1.setModel(new DefaultComboBoxModel<Integer>(CollectionUtils.nullAnd((Collection)BiomeUtils.getAllBiomes((Platform)platform, null)).toArray(new Integer[0])));
            this.tableRoofLayers.getSelectionModel().addListSelectionListener(this);
            this.mixedMaterialChooserBottom.setPlatform(platform);
            this.mixedMaterialChooserBottom.setExtendedBlockIds(extendedBlockIds);
            this.mixedMaterialChooserBottom.setColourScheme(colourScheme);
            this.labelPreview.setPreferredSize(new java.awt.Dimension(128, 0));
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerBottomLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerBottomLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerBottomMin.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerBottomMin.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerBottomMax.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerBottomMax.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        }
        finally {
            this.programmaticChange = false;
        }
        this.loadSettings();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.noiseSettingsEditorBottom.addChangeListener(this);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
        AwtUtils.doLaterOnEventThread(this::updatePreview);
    }

    @Override
    protected void ok() {
        if (this.tableRoofLayers.isEditing()) {
            this.tableRoofLayers.getCellEditor().stopCellEditing();
        }
        if (this.layer.getFloorDimensionId() == null) {
            Dimension floorDimension = this.createFloorDimension();
            this.layer.setFloorDimensionId(Integer.valueOf(floorDimension.getAnchor().id));
            Configuration config = Configuration.getInstance();
            if (!config.isMessageDisplayedCountAtLeast(PAINT_FLOATING_LAYER_KEY, 3)) {
                AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(App.getInstance(), "Use the paint tools to paint the Floating Dimension in the desired shape.\nThen right-click on the [" + this.layer.getName() + "] button on the [" + this.layer.getPalette() + "] panel\nand select \"Edit floating dimension\" to paint on, and vertically shape, the dimension floor."));
                config.setMessageDisplayed(PAINT_FLOATING_LAYER_KEY);
            }
        }
        this.saveSettingsTo(this.layer, true);
        this.dismiss();
    }

    @Override
    protected void generatePreview() {
        TunnelLayer layer = new TunnelLayer("tmp", TunnelLayer.LayerMode.FLOATING, null, this.platform);
        this.saveSettingsTo(layer, false);
        Insets insets = this.labelPreview.getInsets();
        int width = this.labelPreview.getWidth() - insets.left - insets.right;
        int height = this.labelPreview.getHeight() - insets.top - insets.bottom;
        if (width > 0 && height > 0) {
            int baseHeight = (Integer)this.spinnerFloorLevel.getValue();
            BufferedImage preview = FloatingLayerExporter.generatePreview((Dimension)this.dimension, (TunnelLayer)layer, (int)width, (int)height, (int)(baseHeight + (Integer)this.spinnerFloodLevel1.getValue()), (int)this.minHeight, (int)baseHeight, (int)((Integer)this.spinnerRange.getValue()));
            this.labelPreview.setIcon(new ImageIcon(preview));
        } else {
            this.labelPreview.setIcon(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        this.programmaticChange = true;
        try {
            this.spinnerFloorLevel.setValue(this.layer.getFloorLevel());
            this.spinnerBottomLevel.setValue(this.layer.getRoofLevel());
            this.spinnerBottomMin.setValue(Math.max(this.layer.getRoofMin(), this.minHeight));
            this.spinnerBottomMax.setValue(Math.min(this.layer.getRoofMax(), this.maxHeight - 1));
            this.mixedMaterialChooserBottom.setMaterial(this.layer.getRoofMaterial());
            switch (this.layer.getRoofMode()) {
                case FIXED_HEIGHT: {
                    this.radioButtonBottomFixedLevel.setSelected(true);
                    break;
                }
                case FIXED_HEIGHT_ABOVE_FLOOR: {
                    this.radioButtonBottomFixedHeight.setSelected(true);
                }
            }
            NoiseSettings bottomNoise = this.layer.getRoofNoise();
            if (bottomNoise == null) {
                bottomNoise = new NoiseSettings();
            }
            this.noiseSettingsEditorBottom.setNoiseSettings(bottomNoise);
            this.spinnerEdgeWidth.setValue(this.layer.getRoofWallDepth());
            this.textFieldName.setText(this.layer.getName());
            this.paintPicker1.setPaint(this.layer.getPaint());
            this.paintPicker1.setOpacity(this.layer.getOpacity());
            List roofLayers = this.layer.getRoofLayers();
            this.roofLayersTableModel = new TunnelLayersTableModel(roofLayers, this.minHeight, this.maxHeight);
            this.tableRoofLayers.setModel(this.roofLayersTableModel);
            this.tableRoofLayers.getColumnModel().getColumn(0).setCellRenderer(new LayerTableCellRenderer());
            SpinnerNumberModel spinnerModel = new SpinnerNumberModel(50, 0, 100, 1);
            this.tableRoofLayers.getColumnModel().getColumn(1).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            this.tableRoofLayers.getColumnModel().getColumn(2).setCellRenderer(new NoiseSettingsTableCellRenderer());
            spinnerModel = new SpinnerNumberModel(this.minHeight, this.minHeight, this.maxHeight - 1, 1);
            this.tableRoofLayers.getColumnModel().getColumn(3).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            spinnerModel = new SpinnerNumberModel(this.maxHeight - 1, this.minHeight, this.maxHeight - 1, 1);
            this.tableRoofLayers.getColumnModel().getColumn(4).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            if (this.layer.getFloorDimensionId() == null) {
                Configuration config = Configuration.getInstance();
                this.spinnerFloorLevel.setValue(Math.min(config.getLevel() + 32, this.maxHeight - 1));
                this.spinnerFloodLevel1.setValue(config.getWaterLevel() - config.getLevel());
                this.spinnerRange.setValue(config.isHilly() ? Math.round(config.getDefaultRange()) : 0);
                this.spinnerScale.setValue((int)Math.round(config.getDefaultScale() * 100.0));
                this.checkBoxFloodWithLava1.setSelected(config.isLava());
                this.comboBoxTerrain.setSelectedItem(config.getSurface());
                this.checkBoxBeaches.setSelected(config.isBeaches());
                this.comboBoxBiome1.setSelectedItem(null);
                this.jPanel1.remove(this.labelEditDimensionProperties);
            } else {
                this.jLabel7.setText("<html>To change the floor height and shape, close this window,<br>right-click the layer button and select \"Edit floating dimension\".</html>");
                this.jPanel1.remove(this.jLabel3);
                this.jPanel1.remove(this.spinnerFloorLevel);
                this.jPanel1.remove(this.jLabel21);
                this.jPanel1.remove(this.spinnerRange);
                this.jPanel1.remove(this.jLabel22);
                this.jPanel1.remove(this.spinnerScale);
                this.jPanel1.remove(this.jLabel5);
                this.jPanel1.remove(this.jLabel27);
                this.jPanel1.remove(this.spinnerFloodLevel1);
                this.jPanel1.remove(this.checkBoxFloodWithLava1);
                this.jPanel1.remove(this.jLabel2);
                this.jPanel1.remove(this.comboBoxTerrain);
                this.jPanel1.remove(this.jLabel25);
                this.jPanel1.remove(this.comboBoxBiome1);
                this.jPanel1.remove(this.checkBoxBeaches);
            }
            switch (this.layer.getBottomEdgeShape()) {
                case LINEAR: {
                    this.radioButtonLinearEdge.setSelected(true);
                    break;
                }
                case SHEER: {
                    this.radioButtonSheerEdge.setSelected(true);
                    break;
                }
                case SMOOTH: {
                    this.radioButtonSmoothEdge.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this.radioButtonRoundedEdge.setSelected(true);
                }
            }
            if (this.platform.capabilities.contains(Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
                this.checkBoxApplyBiomesSurface.setSelected(this.layer.isApplyBiomesAboveGround());
                this.checkBoxApplyBiomesSubsurface.setSelected(this.layer.isApplyBiomesBelowGround());
                this.spinnerBiomeHeight.setValue(this.layer.getBiomeHeightAboveGround());
            } else {
                this.checkBoxApplyBiomesSurface.setEnabled(false);
                this.checkBoxApplyBiomesSubsurface.setEnabled(false);
            }
        }
        finally {
            this.programmaticChange = false;
        }
        this.setControlStates();
    }

    private void saveSettingsTo(TunnelLayer layer, boolean registerMaterials) {
        layer.setFloorLevel(((Integer)this.spinnerFloorLevel.getValue()).intValue());
        layer.setFloorMode(TunnelLayer.Mode.CUSTOM_DIMENSION);
        layer.setRoofLevel(((Integer)this.spinnerBottomLevel.getValue()).intValue());
        layer.setRoofMin((Integer)this.spinnerBottomMin.getValue() <= this.minHeight ? Integer.MIN_VALUE : (Integer)this.spinnerBottomMin.getValue());
        layer.setRoofMax((Integer)this.spinnerBottomMax.getValue() >= this.maxHeight - 1 ? Integer.MAX_VALUE : (Integer)this.spinnerBottomMax.getValue());
        MixedMaterial bottomMaterial = this.mixedMaterialChooserBottom.getMaterial();
        if (bottomMaterial != null && registerMaterials) {
            bottomMaterial = MixedMaterialManager.getInstance().register(bottomMaterial);
        }
        layer.setRoofMaterial(bottomMaterial);
        if (this.radioButtonBottomFixedLevel.isSelected()) {
            layer.setRoofMode(TunnelLayer.Mode.FIXED_HEIGHT);
        } else {
            layer.setRoofMode(TunnelLayer.Mode.FIXED_HEIGHT_ABOVE_FLOOR);
        }
        NoiseSettings bottomNoiseSettings = this.noiseSettingsEditorBottom.getNoiseSettings();
        if (bottomNoiseSettings.getRange() == 0) {
            layer.setRoofNoise(null);
        } else {
            layer.setRoofNoise(bottomNoiseSettings);
        }
        layer.setRoofWallDepth(((Integer)this.spinnerEdgeWidth.getValue()).intValue());
        layer.setName(this.textFieldName.getText().trim());
        layer.setPaint(this.paintPicker1.getPaint());
        layer.setOpacity(this.paintPicker1.getOpacity());
        List<TunnelLayer.LayerSettings> roofLayers = this.roofLayersTableModel.getLayers();
        layer.setRoofLayers(roofLayers != null && !roofLayers.isEmpty() ? roofLayers : null);
        layer.setFloodWithLava(this.checkBoxFloodWithLava1.isSelected());
        if (this.radioButtonLinearEdge.isSelected()) {
            layer.setBottomEdgeShape(TunnelLayer.EdgeShape.LINEAR);
        } else if (this.radioButtonRoundedEdge.isSelected()) {
            layer.setBottomEdgeShape(TunnelLayer.EdgeShape.ROUNDED);
        } else if (this.radioButtonSheerEdge.isSelected()) {
            layer.setBottomEdgeShape(TunnelLayer.EdgeShape.SHEER);
        } else if (this.radioButtonSmoothEdge.isSelected()) {
            layer.setBottomEdgeShape(TunnelLayer.EdgeShape.SMOOTH);
        }
        layer.setApplyBiomesAboveGround(this.checkBoxApplyBiomesSurface.isSelected());
        layer.setApplyBiomesBelowGround(this.checkBoxApplyBiomesSubsurface.isSelected());
        layer.setBiomeHeightAboveGround(((Integer)this.spinnerBiomeHeight.getValue()).intValue());
    }

    @Override
    protected void setControlStates() {
        this.spinnerBottomMin.setEnabled(!this.radioButtonBottomFixedLevel.isSelected());
        this.spinnerBottomMax.setEnabled(!this.radioButtonBottomFixedLevel.isSelected());
        int selectedRoofRowCount = this.tableRoofLayers.getSelectedRowCount();
        this.buttonRemoveRoofLayer.setEnabled(selectedRoofRowCount > 0);
        this.buttonEditRoofLayer.setEnabled(selectedRoofRowCount == 1 && this.roofLayersTableModel.getLayer(this.tableRoofLayers.getSelectedRow()) instanceof CustomLayer);
        this.spinnerBiomeHeight.setEnabled(this.checkBoxApplyBiomesSurface.isSelected());
    }

    private void removeRoofLayers() {
        if (this.tableRoofLayers.isEditing()) {
            this.tableRoofLayers.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.tableRoofLayers.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.roofLayersTableModel.removeLayer(selectedRows[i]);
        }
    }

    private void editRoofLayer() {
        this.editLayer(this.tableRoofLayers, this.roofLayersTableModel);
    }

    private void addRoofLayer() {
        this.addLayer(this.buttonAddRoofLayer, this.roofLayersTableModel);
    }

    private void newRoofLayer() {
        this.newLayer(this.buttonNewRoofLayer, this.roofLayersTableModel);
    }

    private void editRoofLayerVariation() {
        this.editLayerVariation(this.tableRoofLayers, this.roofLayersTableModel);
    }

    private Dimension createFloorDimension() {
        int minHeight = this.dimension.getMinHeight();
        int maxHeight = this.dimension.getMaxHeight();
        int dim = this.dimension.getAnchor().dim;
        boolean invert = this.dimension.getAnchor().invert;
        World2 world = this.dimension.getWorld();
        int id = this.findNextId(world, dim, Dimension.Role.FLOATING_FLOOR, invert);
        this.layer.setFloorDimensionId(Integer.valueOf(id));
        long seed = this.dimension.getSeed() + 1L + (long)id;
        int floorLevel = (Integer)this.spinnerFloorLevel.getValue();
        int range = (Integer)this.spinnerRange.getValue();
        float scale = (float)((Integer)this.spinnerScale.getValue()).intValue() / 100.0f;
        int waterHeight = floorLevel + (Integer)this.spinnerFloodLevel1.getValue();
        boolean floodWithLava = this.checkBoxFloodWithLava1.isSelected();
        Integer biome = (Integer)this.comboBoxBiome1.getSelectedItem();
        boolean beaches = this.checkBoxBeaches.isSelected();
        Terrain terrain = (Terrain)this.comboBoxTerrain.getSelectedItem();
        HeightMapTileFactory tileFactory = range != 0 ? TileFactoryFactory.createNoiseTileFactory((long)seed, (Terrain)terrain, (int)minHeight, (int)maxHeight, (int)floorLevel, (int)waterHeight, (boolean)floodWithLava, (boolean)beaches, (float)range, (double)scale) : TileFactoryFactory.createFlatTileFactory((long)seed, (Terrain)terrain, (int)minHeight, (int)maxHeight, (int)floorLevel, (int)waterHeight, (boolean)floodWithLava, (boolean)beaches);
        if (biome != null) {
            SimpleTheme theme = (SimpleTheme)tileFactory.getTheme();
            theme.setLayerMap(Collections.singletonMap(Filter.EVERYWHERE, Biome.INSTANCE));
            theme.setDiscreteValues(Collections.singletonMap(Biome.INSTANCE, biome));
        }
        Dimension floorDimension = new Dimension(world, null, seed, (TileFactory)tileFactory, new Dimension.Anchor(dim, Dimension.Role.FLOATING_FLOOR, invert, id));
        world.addDimension(floorDimension);
        this.layer.updateFloorDimension(this.dimension, this.textFieldName.getText() + " Floor");
        this.layer.setFloorLevel(floorLevel);
        this.layer.setFloodLevel(waterHeight);
        this.layer.setFloodWithLava(floodWithLava);
        this.layer.setBiome(biome != null ? biome : -1);
        return floorDimension;
    }

    private void editFloorDimensionProperties() {
        Dimension floorDimension = this.dimension.getWorld().getDimension(new Dimension.Anchor(this.dimension.getAnchor().dim, Dimension.Role.FLOATING_FLOOR, this.dimension.getAnchor().invert, this.layer.getFloorDimensionId().intValue()));
        DimensionPropertiesDialog dialog = new DimensionPropertiesDialog((Window)this, floorDimension, App.getInstance().getColourScheme(), this.customBiomeManager);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.buttonReset = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.textFieldName = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.spinnerBottomLevel = new JSpinner();
        this.jLabel12 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel17 = new JLabel();
        this.spinnerBottomMin = new JSpinner();
        this.spinnerBottomMax = new JSpinner();
        this.jLabel13 = new JLabel();
        this.noiseSettingsEditorBottom = new NoiseSettingsEditor();
        this.jLabel8 = new JLabel();
        this.jLabel16 = new JLabel();
        this.spinnerEdgeWidth = new JSpinner();
        this.jLabel6 = new JLabel();
        this.radioButtonBottomFixedLevel = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.labelPreview = new JLabel();
        this.radioButtonBottomFixedHeight = new JRadioButton();
        this.mixedMaterialChooserBottom = new MixedMaterialChooser(true);
        this.jLabel25 = new JLabel();
        this.comboBoxBiome1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel27 = new JLabel();
        this.spinnerFloorLevel = new JSpinner();
        this.spinnerFloodLevel1 = new JSpinner();
        this.checkBoxFloodWithLava1 = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.comboBoxTerrain = new JComboBox();
        this.jLabel28 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel18 = new JLabel();
        this.radioButtonSheerEdge = new JRadioButton();
        this.radioButtonLinearEdge = new JRadioButton();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.radioButtonSmoothEdge = new JRadioButton();
        this.jLabel19 = new JLabel();
        this.radioButtonRoundedEdge = new JRadioButton();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.spinnerRange = new JSpinner();
        this.jLabel22 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel5 = new JLabel();
        this.checkBoxApplyBiomesSurface = new JCheckBox();
        this.checkBoxApplyBiomesSubsurface = new JCheckBox();
        this.checkBoxBeaches = new JCheckBox();
        this.jLabel29 = new JLabel();
        this.spinnerBiomeHeight = new JSpinner();
        this.jLabel30 = new JLabel();
        this.labelEditDimensionProperties = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel24 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tableRoofLayers = new JTable();
        this.buttonNewRoofLayer = new JButton();
        this.buttonAddRoofLayer = new JButton();
        this.buttonEditRoofLayer = new JButton();
        this.buttonRemoveRoofLayer = new JButton();
        this.paintPicker1 = new PaintPicker();
        this.jLabel23 = new JLabel();
        this.jLabel26 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("[ALPHA] Configure Floating Dimension");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonReset.setText("Reset");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonResetActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Create a floating dimension with the following properties:");
        this.jLabel4.setText("Name:");
        this.textFieldName.setColumns(20);
        this.textFieldName.setText("jTextField1");
        this.jLabel11.setText("Paint");
        this.spinnerBottomLevel.setModel(new SpinnerNumberModel(8, 0, 255, 1));
        this.spinnerBottomLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerBottomLevelStateChanged(evt);
            }
        });
        this.jLabel12.setText("Edges:");
        this.jLabel9.setText("Variation:");
        this.jLabel17.setText(", max:");
        this.spinnerBottomMin.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerBottomMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerBottomMinStateChanged(evt);
            }
        });
        this.spinnerBottomMax.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinnerBottomMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerBottomMaxStateChanged(evt);
            }
        });
        this.jLabel13.setText("Width:");
        this.jLabel8.setText("Level:");
        this.jLabel16.setText("Absolute min:");
        this.spinnerEdgeWidth.setModel(new SpinnerNumberModel(8, 0, 255, 1));
        this.spinnerEdgeWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerEdgeWidthStateChanged(evt);
            }
        });
        this.jLabel6.setText("Bottom:");
        this.buttonGroup3.add(this.radioButtonBottomFixedLevel);
        this.radioButtonBottomFixedLevel.setText("fixed level");
        this.radioButtonBottomFixedLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonBottomFixedLevelActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Material:");
        this.labelPreview.setBorder(BorderFactory.createBevelBorder(1));
        this.buttonGroup3.add(this.radioButtonBottomFixedHeight);
        this.radioButtonBottomFixedHeight.setSelected(true);
        this.radioButtonBottomFixedHeight.setText("fixed depth below floor");
        this.radioButtonBottomFixedHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonBottomFixedHeightActionPerformed(evt);
            }
        });
        this.mixedMaterialChooserBottom.setEnabled(false);
        this.jLabel25.setLabelFor(this.comboBoxBiome1);
        this.jLabel25.setText("Biome:");
        this.jLabel3.setLabelFor(this.spinnerFloorLevel);
        this.jLabel3.setText("Level:");
        this.jLabel27.setLabelFor(this.spinnerFloodLevel1);
        this.jLabel27.setText("Relative water level:");
        this.spinnerFloorLevel.setModel(new SpinnerNumberModel(128, -64, 319, 1));
        this.spinnerFloorLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerFloorLevelStateChanged(evt);
            }
        });
        this.spinnerFloodLevel1.setModel(new SpinnerNumberModel(4, -384, 384, 1));
        this.spinnerFloodLevel1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerFloodLevel1StateChanged(evt);
            }
        });
        this.checkBoxFloodWithLava1.setText("Lava instead of water:");
        this.checkBoxFloodWithLava1.setHorizontalTextPosition(10);
        this.checkBoxFloodWithLava1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.checkBoxFloodWithLava1ActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.comboBoxTerrain);
        this.jLabel2.setText("Surface material:");
        this.jLabel28.setText("Floor defaults:");
        this.jLabel7.setText("<html>These are the default settings. They can only be set when creating the<br>layer. Once created, edit the floor dimension to change height and shape.</html>");
        this.jLabel18.setText("Shape:");
        this.buttonGroup4.add(this.radioButtonSheerEdge);
        this.radioButtonSheerEdge.setText("sheer");
        this.radioButtonSheerEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonSheerEdgeActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.radioButtonLinearEdge);
        this.radioButtonLinearEdge.setText("linear");
        this.radioButtonLinearEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonLinearEdgeActionPerformed(evt);
            }
        });
        this.jLabel14.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/edge_sheer.png")));
        this.jLabel15.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/edge_linear.png")));
        this.buttonGroup4.add(this.radioButtonSmoothEdge);
        this.radioButtonSmoothEdge.setText("smooth");
        this.radioButtonSmoothEdge.setEnabled(false);
        this.radioButtonSmoothEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonSmoothEdgeActionPerformed(evt);
            }
        });
        this.jLabel19.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/edge_smooth.png")));
        this.buttonGroup4.add(this.radioButtonRoundedEdge);
        this.radioButtonRoundedEdge.setSelected(true);
        this.radioButtonRoundedEdge.setText("rounded");
        this.radioButtonRoundedEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.radioButtonRoundedEdgeActionPerformed(evt);
            }
        });
        this.jLabel20.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/edge_rounded.png")));
        this.jLabel21.setLabelFor(this.spinnerRange);
        this.jLabel21.setText("Hill height:");
        this.spinnerRange.setModel(new SpinnerNumberModel(20, 0, 255, 1));
        this.spinnerRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerRangeStateChanged(evt);
            }
        });
        this.jLabel22.setLabelFor(this.spinnerScale);
        this.jLabel22.setText("Horizontal hill size:");
        this.spinnerScale.setModel(new SpinnerNumberModel(100, 1, 999, 1));
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FloatingLayerDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.jLabel5.setText("%");
        this.checkBoxApplyBiomesSurface.setText("apply above ground biomes");
        this.checkBoxApplyBiomesSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.checkBoxApplyBiomesSurfaceActionPerformed(evt);
            }
        });
        this.checkBoxApplyBiomesSubsurface.setText("apply underground biomes");
        this.checkBoxBeaches.setSelected(true);
        this.checkBoxBeaches.setText("Beaches:");
        this.checkBoxBeaches.setHorizontalTextPosition(10);
        this.jLabel29.setText("Biomes:");
        this.spinnerBiomeHeight.setModel(new SpinnerNumberModel(1, 1, 384, 1));
        this.spinnerBiomeHeight.setEnabled(false);
        this.jLabel30.setText("Height:");
        this.labelEditDimensionProperties.setForeground(new Color(0, 0, 255));
        this.labelEditDimensionProperties.setText("<html><u>Edit Floor Dimension Properties...</u><html>");
        this.labelEditDimensionProperties.setCursor(new Cursor(12));
        this.labelEditDimensionProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FloatingLayerDialog.this.labelEditDimensionPropertiesMouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel6).addComponent(this.jLabel28).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerEdgeWidth, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonBottomFixedHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBottomFixedLevel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerBottomLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerBottomMin, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerBottomMax, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mixedMaterialChooserBottom, -2, -1, -2).addComponent(this.noiseSettingsEditorBottom, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloorLevel, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrain, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxBeaches)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome1, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloodLevel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxFloodWithLava1)).addComponent(this.jLabel7, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSheerEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonLinearEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSmoothEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRoundedEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRange, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel5)).addComponent(this.labelEditDimensionProperties, -2, -1, -2))).addComponent(this.jLabel29).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel30).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerBiomeHeight, -2, -1, -2)).addComponent(this.checkBoxApplyBiomesSurface)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxApplyBiomesSubsurface))).addGap(99, 99, 99).addComponent(this.labelPreview, -1, 116, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel28).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelEditDimensionProperties, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerFloorLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.spinnerRange, -2, -1, -2).addComponent(this.jLabel22).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.spinnerFloodLevel1, -2, -1, -2).addComponent(this.checkBoxFloodWithLava1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboBoxTerrain, -2, -1, -2).addComponent(this.checkBoxBeaches)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.comboBoxBiome1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonBottomFixedLevel).addComponent(this.radioButtonBottomFixedHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spinnerBottomLevel, -2, -1, -2).addComponent(this.jLabel16).addComponent(this.spinnerBottomMin, -2, -1, -2).addComponent(this.jLabel17).addComponent(this.spinnerBottomMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.noiseSettingsEditorBottom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.mixedMaterialChooserBottom, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel20).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonSheerEdge).addComponent(this.radioButtonLinearEdge).addComponent(this.radioButtonSmoothEdge).addComponent(this.radioButtonRoundedEdge).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel19).addComponent(this.jLabel18))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.spinnerEdgeWidth, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxApplyBiomesSurface).addComponent(this.checkBoxApplyBiomesSubsurface)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel30).addComponent(this.spinnerBiomeHeight, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.labelPreview, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Floating Dimension", this.jPanel1);
        this.jLabel24.setText("<html>You can add custom layers here which will be rendered on the bottom of the floating dimension:<br> <strong>Note:</strong> these layers will be inverted! This includes Custom Objects.<br> A later release will make this optional.</html>");
        this.tableRoofLayers.setSelectionMode(2);
        this.tableRoofLayers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FloatingLayerDialog.this.tableRoofLayersMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tableRoofLayers);
        this.buttonNewRoofLayer.setText("Create New");
        this.buttonNewRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonNewRoofLayerActionPerformed(evt);
            }
        });
        this.buttonAddRoofLayer.setText("Copy Existing");
        this.buttonAddRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonAddRoofLayerActionPerformed(evt);
            }
        });
        this.buttonEditRoofLayer.setText("Edit");
        this.buttonEditRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonEditRoofLayerActionPerformed(evt);
            }
        });
        this.buttonRemoveRoofLayer.setText("Remove");
        this.buttonRemoveRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloatingLayerDialog.this.buttonRemoveRoofLayerActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel24, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 530, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonAddRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonNewRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonEditRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonRemoveRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel24, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 484, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonNewRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEditRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRoofLayer))).addContainerGap()));
        this.jTabbedPane1.addTab("Bottom Layers", this.jPanel3);
        this.jLabel23.setFont(this.jLabel23.getFont().deriveFont(this.jLabel23.getFont().getStyle() | 2 | 1, this.jLabel23.getFont().getSize() + 6));
        this.jLabel23.setText("ALPHA");
        this.jLabel26.setText("<html>This is an alpha version of the floating dimension functionality. It is not finished and<br>may not work correctly. Functionality may change. Please post feedback on the subreddit.</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonReset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addGap(11, 11, 11)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paintPicker1, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel23).addComponent(this.jLabel26, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel26, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textFieldName, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.paintPicker1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK).addComponent(this.buttonReset)).addContainerGap()));
        this.pack();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        this.loadSettings();
        this.updatePreview();
    }

    private void buttonRemoveRoofLayerActionPerformed(ActionEvent evt) {
        this.removeRoofLayers();
    }

    private void buttonEditRoofLayerActionPerformed(ActionEvent evt) {
        this.editRoofLayer();
    }

    private void buttonAddRoofLayerActionPerformed(ActionEvent evt) {
        this.addRoofLayer();
    }

    private void buttonNewRoofLayerActionPerformed(ActionEvent evt) {
        this.newRoofLayer();
    }

    private void tableRoofLayersMouseClicked(MouseEvent evt) {
        if (!evt.isPopupTrigger() && evt.getClickCount() == 2) {
            int column = this.tableRoofLayers.columnAtPoint(evt.getPoint());
            if (column == 0) {
                this.editRoofLayer();
            } else if (column == 2) {
                this.editRoofLayerVariation();
            }
        }
    }

    private void radioButtonBottomFixedHeightActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void radioButtonBottomFixedLevelActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void spinnerEdgeWidthStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerBottomMaxStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerBottomMax.getValue() < (Integer)this.spinnerBottomMin.getValue()) {
                this.spinnerBottomMin.setValue(this.spinnerBottomMax.getValue());
            }
            this.updatePreview();
        }
    }

    private void spinnerBottomMinStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerBottomMax.getValue() < (Integer)this.spinnerBottomMin.getValue()) {
                this.spinnerBottomMax.setValue(this.spinnerBottomMin.getValue());
            }
            this.updatePreview();
        }
    }

    private void spinnerBottomLevelStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void radioButtonSheerEdgeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void radioButtonLinearEdgeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void radioButtonSmoothEdgeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void radioButtonRoundedEdgeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerFloorLevelStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerFloodLevel1StateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void checkBoxFloodWithLava1ActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerRangeStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void checkBoxApplyBiomesSurfaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void labelEditDimensionPropertiesMouseClicked(MouseEvent evt) {
        this.editFloorDimensionProperties();
    }
}

