/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class RendererPreviewer
extends JComponent {
    private Color colour = Color.ORANGE;
    private BufferedImage pattern;
    private float opacity = 1.0f;
    private static final int GRID_SIZE = 10;

    public RendererPreviewer() {
        this.setOpaque(true);
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.pattern = null;
        }
        this.repaint();
    }

    public BufferedImage getPattern() {
        return this.pattern;
    }

    public void setPattern(BufferedImage pattern) {
        this.pattern = pattern;
        if (pattern != null) {
            this.colour = null;
        }
        this.repaint();
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity != this.opacity) {
            this.opacity = opacity;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g2.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.colour != null ? this.opacity < 1.0f : this.pattern.getTransparency() != 1) {
            this.paintBackground(g, clip);
        }
        if (this.opacity < 1.0f) {
            g2.setComposite(AlphaComposite.getInstance(3, this.opacity));
        }
        if (this.colour != null) {
            g2.setColor(this.colour);
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        } else if (this.pattern != null) {
            int w = this.pattern.getWidth();
            int h = this.pattern.getHeight();
            int x1 = clip.x / w;
            int x2 = (clip.x + clip.width) / w;
            int y1 = clip.y / h;
            int y2 = (clip.y + clip.height) / h;
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    g2.drawImage((Image)this.pattern, x * w, y * h, null);
                }
            }
        } else {
            g2.clearRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip) {
        g.clearRect(clip.x, clip.y, clip.width, clip.height);
        int x1 = clip.x / 10;
        int x2 = (clip.x + clip.width) / 10;
        int y1 = clip.y / 10;
        int y2 = (clip.y + clip.height) / 10;
        g.setColor(Color.LIGHT_GRAY);
        for (int x = x1; x <= x2; x += 2) {
            for (int y = y1; y <= y2; y += 2) {
                g.fillRect(x * 10, y * 10, 10, 10);
                g.fillRect((x + 1) * 10, (y + 1) * 10, 10, 10);
            }
        }
    }
}

