/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.pepsoft.worldpainter.layers.renderers.EditPaintDialog;
import org.pepsoft.worldpainter.layers.renderers.RendererPreviewer;

public class PaintPicker
extends JPanel {
    private JButton buttonPickPaint;
    private RendererPreviewer rendererPreviewer1;
    private Color colour = Color.ORANGE;
    private BufferedImage pattern;
    private float opacity = 1.0f;
    private boolean opacityEnabled = true;

    public PaintPicker() {
        this.initComponents();
        this.updatePreview();
    }

    public Object getPaint() {
        if (this.colour != null) {
            return this.colour;
        }
        return this.pattern;
    }

    public void setPaint(Object paint) {
        if (paint instanceof Color) {
            this.colour = (Color)paint;
            this.pattern = null;
        } else if (paint instanceof BufferedImage) {
            this.pattern = (BufferedImage)paint;
            this.colour = null;
        } else {
            throw new IllegalArgumentException("Paint type " + paint.getClass() + " not supported");
        }
        this.updatePreview();
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity != this.opacity) {
            this.opacity = opacity;
            this.updatePreview();
        }
    }

    public boolean isOpacityEnabled() {
        return this.opacityEnabled;
    }

    public void setOpacityEnabled(boolean opacityEnabled) {
        if (opacityEnabled != this.opacityEnabled) {
            this.opacityEnabled = opacityEnabled;
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.buttonPickPaint.getBaseline(width, height);
    }

    private void updatePreview() {
        if (this.colour != null) {
            this.rendererPreviewer1.setColour(this.colour);
        } else if (this.pattern != null) {
            this.rendererPreviewer1.setPattern(this.pattern);
        }
        this.rendererPreviewer1.setOpacity(this.opacity);
    }

    private void pickPaint() {
        EditPaintDialog dialog = new EditPaintDialog(SwingUtilities.getWindowAncestor(this), this.colour != null ? this.colour : this.pattern, this.opacity, this.opacityEnabled);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            Object paint = dialog.getSelectedPaint();
            if (paint instanceof Color) {
                this.colour = (Color)paint;
                this.pattern = null;
            } else {
                this.pattern = (BufferedImage)paint;
                this.colour = null;
            }
            if (this.opacityEnabled) {
                this.opacity = dialog.getSelectedOpacity();
            }
            this.updatePreview();
        }
    }

    private void initComponents() {
        this.rendererPreviewer1 = new RendererPreviewer();
        this.buttonPickPaint = new JButton();
        this.rendererPreviewer1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.rendererPreviewer1.setPreferredSize(new Dimension(64, 0));
        this.buttonPickPaint.setText("...");
        this.buttonPickPaint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaintPicker.this.buttonPickPaintActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rendererPreviewer1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonPickPaint)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonPickPaint, -1, -1, Short.MAX_VALUE).addComponent(this.rendererPreviewer1, -1, -1, Short.MAX_VALUE));
    }

    private void buttonPickPaintActionPerformed(ActionEvent evt) {
        this.pickPaint();
    }
}

