/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import com.jidesoft.swing.JideLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ImageUtils;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.renderers.RendererPreviewer;
import org.pepsoft.worldpainter.util.IconEditor;

public class EditPaintDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonClear;
    private ButtonGroup buttonGroupColours;
    private ButtonGroup buttonGroupTools;
    private ButtonGroup buttonGroupType;
    private JButton buttonOk;
    private JButton buttonSelectSolidColour;
    private JButton buttonSolidColour;
    private IconEditor iconEditor1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JideLabel labelOpacity;
    private JPanel panelColours;
    private JRadioButton radioButtonPattern;
    private JRadioButton radioButtonSolidColour;
    private RendererPreviewer rendererPreviewer1;
    private JSlider sliderOpacity;
    private JToggleButton toggleButtonEraser;
    private JToggleButton toggleButtonPencil;
    private Color colour;
    private Color paintColour = Color.BLACK;
    private int eraseColour;
    private BufferedImage pattern;
    private float opacity;
    private static final int[] EGA_COLOURS = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xAA5500, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
    private static final String[] EGA_NAMES = new String[]{"Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "Light Grey", "Dark Grey", "Bright Blue", "Bright Green", "Bright Cyan", "Bright Red", "Bright Magenta", "Bright Yellow", "Bright White"};

    public EditPaintDialog(Window parent, Object paint, float opacity, boolean opacityEnabled) {
        super(parent);
        if (paint instanceof Color) {
            this.colour = (Color)paint;
        } else if (paint instanceof BufferedImage) {
            this.pattern = ImageUtils.clone((BufferedImage)((BufferedImage)paint));
        } else {
            throw new IllegalArgumentException("Paint type " + paint.getClass() + " not supported");
        }
        this.initComponents();
        this.opacity = opacity;
        this.sliderOpacity.setValue(Math.round(opacity * 100.0f));
        this.rendererPreviewer1.setOpacity(this.opacity);
        if (!opacityEnabled) {
            this.sliderOpacity.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        if (this.colour != null) {
            this.iconEditor1.setIcon(ImageUtils.createColourSquare((int)16, (int)this.colour.getRGB()));
            this.eraseColour = this.colour.getRGB();
            this.radioButtonSolidColour.setSelected(true);
        } else {
            this.iconEditor1.setIcon(this.pattern);
            this.eraseColour = this.findBackgroundColour(this.pattern);
            this.radioButtonPattern.setSelected(true);
        }
        this.iconEditor1.setEraseColour(this.eraseColour);
        this.updatePreview();
        this.iconEditor1.addPropertyChangeListener("icon", evt -> {
            this.colour = null;
            this.pattern = (BufferedImage)evt.getNewValue();
            this.updatePreview();
        });
        this.scaleToUI();
        this.createColourButtons();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setControlStates();
    }

    public Object getSelectedPaint() {
        return this.colour != null ? this.colour : this.pattern;
    }

    public float getSelectedOpacity() {
        return this.opacity;
    }

    @Override
    protected void ok() {
        this.colour = this.getSolidColour();
        this.pattern = this.colour == null ? this.iconEditor1.getIcon() : null;
        super.ok();
    }

    private void setControlStates() {
        boolean patternMode = this.radioButtonPattern.isSelected();
        this.buttonSelectSolidColour.setEnabled(!patternMode);
        this.iconEditor1.setEditable(patternMode);
        this.buttonSolidColour.setEnabled(patternMode);
        this.toggleButtonPencil.setEnabled(patternMode);
        this.toggleButtonEraser.setEnabled(patternMode);
        this.buttonClear.setEnabled(patternMode);
        for (Component component : this.panelColours.getComponents()) {
            component.setEnabled(patternMode);
        }
    }

    private void createColourButtons() {
        this.panelColours.removeAll();
        this.labelOpacity.setOrientation(1);
        this.labelOpacity.setClockwise(false);
        for (int ega = 0; ega < 16; ++ega) {
            JToggleButton button = new JToggleButton(IconUtils.createScaledColourIcon((int)EGA_COLOURS[ega]));
            button.setToolTipText(EGA_NAMES[ega]);
            button.setMargin(new Insets(2, 2, 2, 2));
            Color colour = new Color(EGA_COLOURS[ega]);
            button.addActionListener(e -> {
                this.paintColour = colour;
                this.iconEditor1.setPaintColour(colour.getRGB());
                if (!this.toggleButtonPencil.isSelected()) {
                    this.toggleButtonPencil.setSelected(true);
                }
            });
            if (ega == 0) {
                button.setSelected(true);
            }
            this.buttonGroupColours.add(button);
            this.panelColours.add(button);
        }
    }

    private void updatePreview() {
        if (this.colour != null) {
            this.rendererPreviewer1.setColour(this.colour);
        } else if (this.pattern != null) {
            this.rendererPreviewer1.setPattern(this.pattern);
        }
    }

    private Color getSolidColour() {
        BufferedImage pattern = this.iconEditor1.getIcon();
        int solidColour = pattern.getRGB(0, 0);
        for (int x = 0; x < pattern.getWidth(); ++x) {
            for (int y = 0; y < pattern.getHeight(); ++y) {
                if (pattern.getRGB(x, y) == solidColour) continue;
                return null;
            }
        }
        return new Color(solidColour);
    }

    private int findBackgroundColour(BufferedImage image) {
        HashMap<Integer, Integer> weightedCounts = new HashMap<Integer, Integer>();
        int w = image.getWidth();
        int h = image.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = image.getRGB(x, y);
                int distanceFromEdge = Math.min(Math.min(x, w - 1 - x), Math.min(y, h - 1 - y));
                int weight = Math.max(3 - distanceFromEdge, 1);
                int weightedCount = weightedCounts.getOrDefault(rgb, 0);
                weightedCounts.put(rgb, weightedCount + weight);
            }
        }
        ArrayList entries = new ArrayList(weightedCounts.entrySet());
        entries.sort(Comparator.comparingInt(Map.Entry::getValue));
        return (Integer)((Map.Entry)entries.get(entries.size() - 1)).getValue();
    }

    private void initComponents() {
        this.buttonGroupTools = new ButtonGroup();
        this.buttonGroupColours = new ButtonGroup();
        this.buttonGroupType = new ButtonGroup();
        this.iconEditor1 = new IconEditor();
        this.buttonSolidColour = new JButton();
        this.toggleButtonPencil = new JToggleButton();
        this.toggleButtonEraser = new JToggleButton();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.panelColours = new JPanel();
        this.jButton1 = new JButton();
        this.rendererPreviewer1 = new RendererPreviewer();
        this.buttonClear = new JButton();
        this.jLabel1 = new JLabel();
        this.sliderOpacity = new JSlider();
        this.labelOpacity = new JideLabel();
        this.radioButtonSolidColour = new JRadioButton();
        this.radioButtonPattern = new JRadioButton();
        this.buttonSelectSolidColour = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Paint");
        this.iconEditor1.setEditable(false);
        this.buttonSolidColour.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/fill.png")));
        this.buttonSolidColour.setText("Make Solid Colour");
        this.buttonSolidColour.setToolTipText("<html>Select a colour and fill canvas completely<br>\nSelected colour will become background colour</html>");
        this.buttonSolidColour.setEnabled(false);
        this.buttonSolidColour.setHorizontalAlignment(10);
        this.buttonSolidColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.buttonSolidColourActionPerformed(evt);
            }
        });
        this.buttonGroupTools.add(this.toggleButtonPencil);
        this.toggleButtonPencil.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/pencil.png")));
        this.toggleButtonPencil.setSelected(true);
        this.toggleButtonPencil.setText("Pencil");
        this.toggleButtonPencil.setToolTipText("<html>Left-click to paint with selected colour<br>\nRight-click to paint with background colour</html>");
        this.toggleButtonPencil.setEnabled(false);
        this.toggleButtonPencil.setHorizontalAlignment(10);
        this.toggleButtonPencil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.toggleButtonPencilActionPerformed(evt);
            }
        });
        this.buttonGroupTools.add(this.toggleButtonEraser);
        this.toggleButtonEraser.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/sponge.png")));
        this.toggleButtonEraser.setText("Eraser");
        this.toggleButtonEraser.setToolTipText("Click to erase to transparency");
        this.toggleButtonEraser.setEnabled(false);
        this.toggleButtonEraser.setHorizontalAlignment(10);
        this.toggleButtonEraser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.toggleButtonEraserActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.panelColours.setLayout(new GridLayout(0, 4));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/shovel-icon_16.png")));
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.panelColours.add(this.jButton1);
        this.rendererPreviewer1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.rendererPreviewer1.setToolTipText("Preview of pattern");
        this.buttonClear.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/clear_selection.png")));
        this.buttonClear.setText("Clear");
        this.buttonClear.setToolTipText("<html>Clear entire canvas to transparency<br>\nSet background colour to transparency</html>");
        this.buttonClear.setEnabled(false);
        this.buttonClear.setHorizontalAlignment(10);
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.buttonClearActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 2));
        this.jLabel1.setText("Left-click to paint with selected colour; right-click for background colour");
        this.sliderOpacity.setOrientation(1);
        this.sliderOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditPaintDialog.this.sliderOpacityStateChanged(evt);
            }
        });
        this.labelOpacity.setText("Opacity");
        this.buttonGroupType.add(this.radioButtonSolidColour);
        this.radioButtonSolidColour.setSelected(true);
        this.radioButtonSolidColour.setText("Solid colour");
        this.radioButtonSolidColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.radioButtonSolidColourActionPerformed(evt);
            }
        });
        this.buttonGroupType.add(this.radioButtonPattern);
        this.radioButtonPattern.setText("Pattern:");
        this.radioButtonPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.radioButtonPatternActionPerformed(evt);
            }
        });
        this.buttonSelectSolidColour.setText("...");
        this.buttonSelectSolidColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPaintDialog.this.buttonSelectSolidColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.iconEditor1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonSolidColour, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.toggleButtonPencil, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.toggleButtonEraser, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonClear, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.panelColours, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent((Component)this.labelOpacity, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderOpacity, -2, -1, -2)).addComponent(this.rendererPreviewer1, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonPattern).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonSolidColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectSolidColour))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonSolidColour).addComponent(this.buttonSelectSolidColour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonPattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.buttonSolidColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleButtonPencil).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleButtonEraser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClear).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColours, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.labelOpacity, -2, -1, -2)))).addComponent(this.sliderOpacity, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rendererPreviewer1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.iconEditor1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk).addComponent(this.jLabel1)).addContainerGap()));
        this.pack();
    }

    private void buttonSolidColourActionPerformed(ActionEvent evt) {
        Color selectedColour = JColorChooser.showDialog(this, "Choose A Colour", this.paintColour);
        if (selectedColour != null) {
            this.iconEditor1.fill(selectedColour.getRGB());
            this.colour = selectedColour;
            this.eraseColour = selectedColour.getRGB();
            this.iconEditor1.setEraseColour(this.eraseColour);
            this.pattern = null;
            this.updatePreview();
        }
    }

    private void toggleButtonPencilActionPerformed(ActionEvent evt) {
        this.iconEditor1.setPaintColour(this.paintColour.getRGB());
        this.jLabel1.setText("Left-click to paint with selected colour; right-click for background colour");
    }

    private void toggleButtonEraserActionPerformed(ActionEvent evt) {
        this.iconEditor1.setPaintColour(0xFFFFFF);
        this.jLabel1.setText("Click to erase to transparency");
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonClearActionPerformed(ActionEvent evt) {
        this.iconEditor1.fill(0xFFFFFF);
        this.colour = null;
        this.eraseColour = 0xFFFFFF;
        this.iconEditor1.setEraseColour(this.eraseColour);
        this.pattern = this.iconEditor1.getIcon();
        this.updatePreview();
    }

    private void sliderOpacityStateChanged(ChangeEvent evt) {
        this.opacity = (float)this.sliderOpacity.getValue() / 100.0f;
        this.rendererPreviewer1.setOpacity(this.opacity);
    }

    private void radioButtonSolidColourActionPerformed(ActionEvent evt) {
        Color solidColour = this.getSolidColour();
        if (solidColour != null) {
            this.setControlStates();
        } else {
            Color selectedColour = JColorChooser.showDialog(this, "Choose A Colour", this.paintColour);
            if (selectedColour != null) {
                this.iconEditor1.fill(selectedColour.getRGB());
                this.colour = selectedColour;
                this.eraseColour = selectedColour.getRGB();
                this.iconEditor1.setEraseColour(this.eraseColour);
                this.pattern = null;
                this.updatePreview();
                this.setControlStates();
            } else {
                this.radioButtonPattern.setSelected(true);
            }
        }
    }

    private void buttonSelectSolidColourActionPerformed(ActionEvent evt) {
        this.buttonSolidColourActionPerformed(evt);
    }

    private void radioButtonPatternActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }
}

