/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.layers.AbstractLayerEditor;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.layers.plants.Plants;
import org.pepsoft.worldpainter.layers.renderers.PaintPicker;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;
import org.pepsoft.worldpainter.util.I18nHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantLayerEditor
extends AbstractLayerEditor<PlantLayer> {
    private JButton buttonClear;
    private JCheckBox checkBoxGenerateTilledDirt;
    private JCheckBox checkBoxOnlyValidBlocks;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private PaintPicker paintPicker1;
    private JPanel panelPlantControls;
    private final JSpinner[] spinners = new JSpinner[Plants.ALL_PLANTS.length];
    private final JLabel[] plantLabels = new JLabel[Plants.ALL_PLANTS.length];
    private final JLabel[] percentageLabels = new JLabel[Plants.ALL_PLANTS.length];
    private final JSpinner[] growthFromSpinners = new JSpinner[Plants.ALL_PLANTS.length];
    private final JSpinner[] growthToSpinners = new JSpinner[Plants.ALL_PLANTS.length];
    private long totalOccurrence;
    private boolean cropsSelected;
    private boolean initialised;
    private Font normalFont;
    private Font boldFont;
    private final ChangeListener percentageListener = e -> this.updatePercentages();
    private static final Map<String, BufferedImage> icons = new HashMap<String, BufferedImage>();
    private static final Logger logger = LoggerFactory.getLogger(PlantLayerEditor.class);

    public PlantLayerEditor() {
        this.initComponents();
        this.fieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlantLayerEditor.this.settingsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlantLayerEditor.this.settingsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlantLayerEditor.this.settingsChanged();
            }
        });
    }

    public List<Component> getAdditionalButtons() {
        return Collections.singletonList(this.buttonClear);
    }

    public PlantLayer createLayer() {
        return new PlantLayer("Plants", "A custom collection of plants", (Object)Color.GREEN);
    }

    public void setLayer(PlantLayer layer) {
        super.setLayer((Layer)layer);
        this.reset();
    }

    public void setContext(LayerEditor.LayerEditorContext context) {
        super.setContext(context);
        this.initPlantControls();
    }

    public void commit() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        this.saveSettings((PlantLayer)this.layer);
    }

    public void reset() {
        this.fieldName.setText(((PlantLayer)this.layer).getName());
        this.paintPicker1.setPaint(((PlantLayer)this.layer).getPaint());
        this.paintPicker1.setOpacity(((PlantLayer)this.layer).getOpacity());
        this.checkBoxGenerateTilledDirt.setSelected(((PlantLayer)this.layer).isGenerateFarmland());
        this.checkBoxOnlyValidBlocks.setSelected(((PlantLayer)this.layer).isOnlyOnValidBlocks());
        Platform platform = this.context.getDimension().getWorld().getPlatform();
        for (int i = 0; i < Plants.ALL_PLANTS.length; ++i) {
            PlantLayer.PlantSettings settings = ((PlantLayer)this.layer).getSettings(i);
            if (!this.isCompatibleWithPlatform(Plants.ALL_PLANTS[i], platform)) {
                this.spinners[i].setValue(0);
                if (settings != null && settings.occurrence > 0) {
                    this.plantLabels[i].setEnabled(true);
                    this.plantLabels[i].setText("<html><s>" + Plants.ALL_PLANTS[i].getName() + "</s></html>");
                } else {
                    this.plantLabels[i].setEnabled(false);
                    this.plantLabels[i].setText(Plants.ALL_PLANTS[i].getName());
                }
                this.plantLabels[i].setToolTipText("This plant is not compatible with the current map format");
                continue;
            }
            if (settings != null) {
                this.spinners[i].setValue(settings.occurrence);
                this.plantLabels[i].setEnabled(true);
                this.plantLabels[i].setText(Plants.ALL_PLANTS[i].getName());
                this.plantLabels[i].setToolTipText(null);
                if (this.growthFromSpinners[i] == null) continue;
                this.growthFromSpinners[i].setValue(settings.growthFrom);
                this.growthToSpinners[i].setValue(settings.growthTo);
                continue;
            }
            this.spinners[i].setValue(0);
            if (this.growthFromSpinners[i] != null) {
                this.growthFromSpinners[i].setValue(Math.max(Plants.ALL_PLANTS[i].getDefaultGrowth() / 2, 1));
                this.growthToSpinners[i].setValue(Plants.ALL_PLANTS[i].getDefaultGrowth());
            }
            this.plantLabels[i].setEnabled(true);
            this.plantLabels[i].setText(Plants.ALL_PLANTS[i].getName());
            this.plantLabels[i].setToolTipText(null);
        }
        this.updatePercentages();
        this.setControlStates();
    }

    public ExporterSettings getSettings() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        final PlantLayer previewLayer = this.saveSettings(null);
        return new ExporterSettings(){

            public boolean isApplyEverywhere() {
                return false;
            }

            public PlantLayer getLayer() {
                return previewLayer;
            }

            public ExporterSettings clone() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    public boolean isCommitAvailable() {
        return !this.fieldName.getText().trim().isEmpty() && this.totalOccurrence > 0L && this.totalOccurrence <= Integer.MAX_VALUE;
    }

    private void initPlantControls() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.panelPlantControls.add(panel);
        this.addCategory(panel, Category.PLANTS_AND_FLOWERS);
        this.addFiller(panel);
        panel = new JPanel(new GridBagLayout());
        this.panelPlantControls.add(panel);
        this.addCategory(panel, Category.SAPLINGS);
        this.addCategory(panel, Category.CROPS);
        this.addCategory(panel, "Various", Category.MUSHROOMS, Category.CACTUS, Category.SUGAR_CANE, Category.FLOATING_PLANTS, Category.END);
        this.addFiller(panel);
        panel = new JPanel(new GridBagLayout());
        this.panelPlantControls.add(panel);
        this.addCategory(panel, "Water plants", Category.WATER_PLANTS, Category.DRIPLEAF);
        this.addCategory(panel, Category.NETHER);
        this.addCategory(panel, "Hanging Plants", "For ceilings and cave/tunnel roofs", Category.HANGING_DRY_PLANTS, Category.HANGING_WATER_PLANTS);
        this.addFiller(panel);
        this.panelPlantControls.setPreferredSize(this.panelPlantControls.getMinimumSize());
    }

    private void addCategory(JPanel panel, Category category) {
        this.addCategory(panel, I18nHelper.m(category), category);
    }

    private void addCategory(JPanel panel, String title, Category ... categories) {
        this.addCategory(panel, title, (String)null, categories);
    }

    private void addCategory(JPanel panel, String title, String subTitle, Category ... categories) {
        boolean newColumn = panel.getComponentCount() == 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = newColumn ? 3 : 0;
        constraints.anchor = 512;
        constraints.insets = new Insets(4, 0, 4, 0);
        panel.add((Component)new JLabel("<html><b>" + title + "</b></html>"), constraints);
        constraints.gridwidth = 0;
        if (newColumn) {
            panel.add((Component)new JLabel("Growth:"), constraints);
        }
        if (subTitle != null) {
            panel.add((Component)new JLabel(subTitle), constraints);
        }
        Platform platform = this.context.getDimension().getWorld().getPlatform();
        for (Category category : categories) {
            for (int i = 0; i < Plants.ALL_PLANTS.length; ++i) {
                Plant plant = Plants.ALL_PLANTS[i];
                if (plant.getCategories()[0] != category) continue;
                this.addPlantRow(panel, plant, i, this.isCompatibleWithPlatform(plant, platform));
            }
        }
    }

    private boolean isCompatibleWithPlatform(Plant plant, Platform platform) {
        if (!platform.capabilities.contains(Platform.Capability.NAME_BASED)) {
            for (Material material : plant.getAllMaterials()) {
                if (material.blockType != -1) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlantRow(JPanel panel, Plant plant, int index, boolean enabled) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(1, 0, 1, 4);
        Map<String, BufferedImage> map = icons;
        synchronized (map) {
            BufferedImage icon = icons.get(plant.getIconNames()[0]);
            this.plantLabels[index] = icon != null ? new JLabel(plant.getName(), new ImageIcon(icon), 11) : new JLabel(plant.getName());
        }
        panel.add((Component)this.plantLabels[index], constraints);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.spinners[index] = new JSpinner(spinnerModel);
        ((JSpinner.NumberEditor)this.spinners[index].getEditor()).getTextField().setColumns(3);
        this.spinners[index].addChangeListener(this.percentageListener);
        panel.add((Component)this.spinners[index], constraints);
        this.percentageLabels[index] = new JLabel("100%");
        panel.add((Component)this.percentageLabels[index], constraints);
        if (!enabled) {
            this.spinners[index].setEnabled(false);
            this.spinners[index].setToolTipText("This plant is not compatible with the current map format");
        }
        if (plant.getMaxGrowth() > 1) {
            spinnerModel = new SpinnerNumberModel(Math.max(plant.getDefaultGrowth() / 2, 1), 1, plant.getMaxGrowth(), 1);
            this.growthFromSpinners[index] = new JSpinner(spinnerModel);
            this.growthFromSpinners[index].addChangeListener(e -> {
                int newValue = (Integer)this.growthFromSpinners[index].getValue();
                if ((Integer)this.growthToSpinners[index].getValue() < newValue) {
                    this.growthToSpinners[index].setValue(newValue);
                }
                this.settingsChanged();
            });
            panel.add((Component)this.growthFromSpinners[index], constraints);
            JLabel dashLabel = new JLabel("-");
            panel.add(dashLabel);
            constraints.gridwidth = 0;
            spinnerModel = new SpinnerNumberModel(plant.getDefaultGrowth(), 1, plant.getMaxGrowth(), 1);
            this.growthToSpinners[index] = new JSpinner(spinnerModel);
            this.growthToSpinners[index].addChangeListener(e -> {
                int newValue = (Integer)this.growthToSpinners[index].getValue();
                if ((Integer)this.growthFromSpinners[index].getValue() > newValue) {
                    this.growthFromSpinners[index].setValue(newValue);
                }
                this.settingsChanged();
            });
            panel.add((Component)this.growthToSpinners[index], constraints);
            if (!enabled) {
                this.growthFromSpinners[index].setEnabled(false);
                dashLabel.setEnabled(false);
                this.growthToSpinners[index].setEnabled(false);
            }
        } else {
            constraints.gridwidth = 0;
            panel.add((Component)new JLabel(), constraints);
        }
    }

    private void addFiller(JPanel panel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 1.0;
        panel.add(Box.createGlue(), constraints);
    }

    public static void loadIconsInBackground() {
        new Thread("Plant Icon Loader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<String, BufferedImage> map = icons;
                synchronized (map) {
                    File resourcesJar = BiomeSchemeManager.getLatestMinecraftJar();
                    if (resourcesJar == null) {
                        logger.warn("Could not find Minecraft jar for loading plant icons");
                        return;
                    }
                    logger.info("Loading plant icons from {}", (Object)resourcesJar);
                    try (JarFile jarFile = new JarFile(resourcesJar);){
                        block10: for (Plant plant : Plants.ALL_PLANTS) {
                            String[] iconNames;
                            for (String iconName : iconNames = plant.getIconNames()) {
                                BufferedImage icon = PlantLayerEditor.findIcon(jarFile, iconName);
                                if (icon == null) continue;
                                icons.put(iconNames[0], icon);
                                continue block10;
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error("I/O error while trying to load plant icons; not loading icons", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage findIcon(JarFile jarFile, String name) {
        try {
            JarEntry entry = jarFile.getJarEntry("assets/minecraft/textures/" + name);
            if (entry == null) {
                if (!logger.isDebugEnabled()) return null;
                logger.debug("Could not find plant icon " + name + " in Minecraft jar " + jarFile.getName());
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Loading plant icon " + name + " from " + jarFile.getName());
            }
            try (InputStream in = jarFile.getInputStream(entry);){
                BufferedImage icon = ImageIO.read(in);
                if (icon.getHeight() > icon.getWidth()) {
                    icon = icon.getSubimage(0, 0, icon.getWidth(), icon.getWidth());
                }
                BufferedImage bufferedImage = icon;
                return bufferedImage;
            }
        }
        catch (IOException e) {
            logger.error("I/O error while trying to load plant icon " + name + "; continuing without icon", (Throwable)e);
            return null;
        }
    }

    private void updatePercentages() {
        this.totalOccurrence = 0L;
        for (JSpinner spinner : this.spinners) {
            this.totalOccurrence += (long)((Integer)spinner.getValue()).intValue();
        }
        if (this.normalFont == null) {
            this.normalFont = this.plantLabels[0].getFont().deriveFont(0);
            this.boldFont = this.normalFont.deriveFont(1);
        }
        this.cropsSelected = false;
        for (int i = 0; i < this.spinners.length; ++i) {
            int percentage;
            int value = (Integer)this.spinners[i].getValue();
            if (value == 0 && this.percentageLabels[i].isEnabled()) {
                this.percentageLabels[i].setEnabled(false);
                this.plantLabels[i].setFont(this.normalFont);
                this.percentageLabels[i].setText("\u2007\u2007\u2007%");
                if (this.growthFromSpinners[i] == null || !this.growthFromSpinners[i].isEnabled()) continue;
                this.growthFromSpinners[i].setEnabled(false);
                this.growthToSpinners[i].setEnabled(false);
                continue;
            }
            if (value <= 0) continue;
            if (!this.percentageLabels[i].isEnabled()) {
                this.percentageLabels[i].setEnabled(true);
                this.plantLabels[i].setFont(this.boldFont);
            }
            if (Arrays.asList(Plants.ALL_PLANTS[i].getCategories()).contains(Category.CROPS)) {
                this.cropsSelected = true;
            }
            if ((percentage = (int)((long)(value * 100) / this.totalOccurrence)) < 10) {
                this.percentageLabels[i].setText("\u2007\u2007" + percentage + "%");
            } else if (percentage < 100) {
                this.percentageLabels[i].setText("\u2007" + percentage + "%");
            } else {
                this.percentageLabels[i].setText(percentage + "%");
            }
            if (this.growthFromSpinners[i] == null || this.growthFromSpinners[i].isEnabled()) continue;
            this.growthFromSpinners[i].setEnabled(true);
            this.growthToSpinners[i].setEnabled(true);
        }
        this.settingsChanged();
    }

    private void settingsChanged() {
        this.setControlStates();
        this.context.settingsChanged();
    }

    private void setControlStates() {
        this.checkBoxGenerateTilledDirt.setEnabled(this.cropsSelected);
    }

    private PlantLayer saveSettings(PlantLayer layer) {
        if (layer == null) {
            layer = this.createLayer();
        }
        layer.setName(this.fieldName.getText().trim());
        layer.setPaint(this.paintPicker1.getPaint());
        layer.setOpacity(this.paintPicker1.getOpacity());
        layer.setGenerateFarmland(this.checkBoxGenerateTilledDirt.isSelected());
        layer.setOnlyOnValidBlocks(this.checkBoxOnlyValidBlocks.isSelected());
        for (int i = 0; i < Plants.ALL_PLANTS.length; ++i) {
            PlantLayer.PlantSettings settings = new PlantLayer.PlantSettings();
            settings.occurrence = (short)((Integer)this.spinners[i].getValue()).intValue();
            if (this.growthFromSpinners[i] != null) {
                settings.growthFrom = (Integer)this.growthFromSpinners[i].getValue();
                settings.growthTo = (Integer)this.growthToSpinners[i].getValue();
            } else {
                settings.growthFrom = 1;
                settings.growthTo = 1;
            }
            layer.setSettings(i, settings);
        }
        return layer;
    }

    private void clear() {
        for (int i = 0; i < Plants.ALL_PLANTS.length; ++i) {
            this.spinners[i].setValue(0);
            if (this.growthFromSpinners[i] == null) continue;
            this.growthFromSpinners[i].setValue(Math.max(Plants.ALL_PLANTS[i].getDefaultGrowth() / 2, 1));
            this.growthToSpinners[i].setValue(Plants.ALL_PLANTS[i].getDefaultGrowth());
        }
        this.updatePercentages();
    }

    private void initComponents() {
        this.buttonClear = new JButton();
        this.jLabel1 = new JLabel();
        this.panelPlantControls = new JPanel();
        this.checkBoxGenerateTilledDirt = new JCheckBox();
        this.fieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.checkBoxOnlyValidBlocks = new JCheckBox();
        this.paintPicker1 = new PaintPicker();
        this.buttonClear.setText("Clear");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlantLayerEditor.this.buttonClearActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name:");
        this.panelPlantControls.setLayout(new BoxLayout(this.panelPlantControls, 2));
        this.checkBoxGenerateTilledDirt.setSelected(true);
        this.checkBoxGenerateTilledDirt.setText("turn grass and dirt beneath crops to tilled dirt");
        this.checkBoxGenerateTilledDirt.setEnabled(false);
        this.fieldName.setColumns(20);
        this.fieldName.setText("jTextField1");
        this.jLabel2.setText("Paint:");
        this.checkBoxOnlyValidBlocks.setSelected(true);
        this.checkBoxOnlyValidBlocks.setText("only place on valid blocks");
        this.checkBoxOnlyValidBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlantLayerEditor.this.checkBoxOnlyValidBlocksActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelPlantControls, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxGenerateTilledDirt).addGap(18, 18, 18).addComponent(this.checkBoxOnlyValidBlocks)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldName, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paintPicker1, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fieldName, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.paintPicker1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxGenerateTilledDirt).addComponent(this.checkBoxOnlyValidBlocks)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPlantControls, -1, -1, Short.MAX_VALUE)));
    }

    private void buttonClearActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void checkBoxOnlyValidBlocksActionPerformed(ActionEvent evt) {
        ExportSettings exportSettings;
        if (!this.checkBoxOnlyValidBlocks.isSelected() && ((exportSettings = this.context.getDimension().getExportSettings()) == null || exportSettings instanceof JavaExportSettings && ((JavaExportSettings)exportSettings).isRemovePlants())) {
            DesktopUtils.beep();
            MessageUtils.showInfo((Component)SwingUtilities.windowForComponent((Component)((Object)this)), (String)"You must also turn off \"Plants: remove from invalid blocks\"\non the Post Processing tab of the Export screen! Otherwise\nplants on invalid blocks will be removed during post-\nprocessing.", (String)"Reminder: Turn Off Remove Plants");
        }
    }
}

