/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.groundcover;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialChooser;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.layers.AbstractLayerEditor;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.renderers.PaintPicker;

public class GroundCoverLayerEditor
extends AbstractLayerEditor<GroundCoverLayer> {
    private ButtonGroup buttonGroup1;
    private JCheckBox checkBoxSmooth;
    private JComboBox<String> comboBoxLayerAnchor;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel labelWesterosCraftFeature;
    private MixedMaterialChooser mixedMaterialSelector1;
    private NoiseSettingsEditor noiseSettingsEditor1;
    private PaintPicker paintPicker1;
    private JRadioButton radioButtonLinearEdge;
    private JRadioButton radioButtonRoundedEdge;
    private JRadioButton radioButtonSheerEdge;
    private JRadioButton radioButtonSmoothEdge;
    private JSpinner spinnerEdgeWidth;
    private JSpinner spinnerThickness;
    private final Platform platform;
    private boolean programmaticChange = true;

    public GroundCoverLayerEditor(Platform platform) {
        this.initComponents();
        this.platform = platform;
        this.mixedMaterialSelector1.setPlatform(platform);
        if (!"true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.westerosCraftMode"))) {
            if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.smoothGroundCover"))) {
                this.labelWesterosCraftFeature.setVisible(false);
            } else {
                this.checkBoxSmooth.setVisible(false);
                this.labelWesterosCraftFeature.setVisible(false);
            }
        }
        int maxThickness = platform.maxMaxHeight - platform.minMinHeight;
        ((SpinnerNumberModel)this.spinnerThickness.getModel()).setMaximum(Integer.valueOf(maxThickness));
        ((SpinnerNumberModel)this.spinnerThickness.getModel()).setMinimum(Integer.valueOf(-maxThickness));
        this.setControlStates();
        this.fieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GroundCoverLayerEditor.this.settingsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GroundCoverLayerEditor.this.settingsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GroundCoverLayerEditor.this.settingsChanged();
            }
        });
        this.mixedMaterialSelector1.addPropertyChangeListener("material", event -> {
            if (((MixedMaterial)event.getNewValue()).getMode() != MixedMaterial.Mode.LAYERED || this.layer == null) {
                this.comboBoxLayerAnchor.setSelectedItem(null);
            } else {
                this.comboBoxLayerAnchor.setSelectedIndex(((GroundCoverLayer)this.layer).getLayerAnchor().ordinal());
            }
            this.settingsChanged();
        });
        this.programmaticChange = false;
    }

    public GroundCoverLayer createLayer() {
        return new GroundCoverLayer("My Ground Cover", MixedMaterial.create((Platform)this.platform, (Material)Material.ROSE), (Object)Color.RED);
    }

    public void setLayer(GroundCoverLayer layer) {
        super.setLayer((Layer)layer);
        this.reset();
    }

    public void commit() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        ((GroundCoverLayer)this.layer).setMaterial(MixedMaterialManager.getInstance().register(this.mixedMaterialSelector1.getMaterial()));
        this.saveSettings((GroundCoverLayer)this.layer);
    }

    public void reset() {
        this.fieldName.setText(((GroundCoverLayer)this.layer).getName());
        if (((GroundCoverLayer)this.layer).getMaterial().getMode() == MixedMaterial.Mode.LAYERED) {
            this.comboBoxLayerAnchor.setSelectedIndex(((GroundCoverLayer)this.layer).getLayerAnchor().ordinal());
        } else {
            this.comboBoxLayerAnchor.setSelectedItem(null);
        }
        this.spinnerThickness.setValue(((GroundCoverLayer)this.layer).getThickness());
        this.paintPicker1.setPaint(((GroundCoverLayer)this.layer).getPaint());
        this.paintPicker1.setOpacity(((GroundCoverLayer)this.layer).getOpacity());
        switch (((GroundCoverLayer)this.layer).getEdgeShape()) {
            case SHEER: {
                this.radioButtonSheerEdge.setSelected(true);
                break;
            }
            case LINEAR: {
                this.radioButtonLinearEdge.setSelected(true);
                break;
            }
            case SMOOTH: {
                this.radioButtonSmoothEdge.setSelected(true);
                break;
            }
            case ROUNDED: {
                this.radioButtonRoundedEdge.setSelected(true);
            }
        }
        this.spinnerEdgeWidth.setValue(((GroundCoverLayer)this.layer).getEdgeWidth());
        if (((GroundCoverLayer)this.layer).getNoiseSettings() != null) {
            this.noiseSettingsEditor1.setNoiseSettings(((GroundCoverLayer)this.layer).getNoiseSettings());
        }
        this.checkBoxSmooth.setSelected(((GroundCoverLayer)this.layer).isSmooth());
        this.mixedMaterialSelector1.setMaterial(((GroundCoverLayer)this.layer).getMaterial());
        this.settingsChanged();
    }

    public ExporterSettings getSettings() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        final GroundCoverLayer previewLayer = this.saveSettings(null);
        return new ExporterSettings(){

            public boolean isApplyEverywhere() {
                return false;
            }

            public GroundCoverLayer getLayer() {
                return previewLayer;
            }

            public ExporterSettings clone() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    public boolean isCommitAvailable() {
        return (Integer)this.spinnerThickness.getValue() != 0 && !this.fieldName.getText().trim().isEmpty();
    }

    public void setContext(LayerEditor.LayerEditorContext context) {
        super.setContext(context);
        this.mixedMaterialSelector1.setColourScheme(context.getColourScheme());
        this.mixedMaterialSelector1.setExtendedBlockIds(context.isExtendedBlockIds());
    }

    private void settingsChanged() {
        if (this.programmaticChange) {
            return;
        }
        this.setControlStates();
        this.context.settingsChanged();
    }

    private void setControlStates() {
        int thickness = (Integer)this.spinnerThickness.getValue();
        this.spinnerEdgeWidth.setEnabled((thickness < -1 || thickness > 1) && !this.radioButtonSheerEdge.isSelected());
        this.radioButtonSheerEdge.setEnabled(thickness < -1 || thickness > 1);
        this.radioButtonLinearEdge.setEnabled(thickness < -1 || thickness > 1);
        this.radioButtonSmoothEdge.setEnabled(thickness < -1 || thickness > 1);
        this.radioButtonRoundedEdge.setEnabled(thickness < -1 || thickness > 1);
        this.comboBoxLayerAnchor.setEnabled(this.mixedMaterialSelector1.getMaterial() != null && this.mixedMaterialSelector1.getMaterial().getMode() == MixedMaterial.Mode.LAYERED);
    }

    private GroundCoverLayer saveSettings(GroundCoverLayer layer) {
        if (layer == null) {
            layer = new GroundCoverLayer(this.fieldName.getText(), this.mixedMaterialSelector1.getMaterial(), this.paintPicker1.getPaint());
        } else {
            layer.setName(this.fieldName.getText());
            layer.setPaint(this.paintPicker1.getPaint());
        }
        layer.setOpacity(this.paintPicker1.getOpacity());
        if (this.mixedMaterialSelector1.getMaterial().getMode() == MixedMaterial.Mode.LAYERED) {
            layer.setLayerAnchor(GroundCoverLayer.LayerAnchor.values()[this.comboBoxLayerAnchor.getSelectedIndex()]);
        }
        layer.setThickness(((Integer)this.spinnerThickness.getValue()).intValue());
        if (this.radioButtonSheerEdge.isSelected()) {
            layer.setEdgeShape(GroundCoverLayer.EdgeShape.SHEER);
        } else if (this.radioButtonLinearEdge.isSelected()) {
            layer.setEdgeShape(GroundCoverLayer.EdgeShape.LINEAR);
        } else if (this.radioButtonSmoothEdge.isSelected()) {
            layer.setEdgeShape(GroundCoverLayer.EdgeShape.SMOOTH);
        } else if (this.radioButtonRoundedEdge.isSelected()) {
            layer.setEdgeShape(GroundCoverLayer.EdgeShape.ROUNDED);
        }
        layer.setEdgeWidth(((Integer)this.spinnerEdgeWidth.getValue()).intValue());
        NoiseSettings noiseSettings = this.noiseSettingsEditor1.getNoiseSettings();
        if (noiseSettings.getRange() == 0) {
            layer.setNoiseSettings(null);
        } else {
            layer.setNoiseSettings(noiseSettings);
        }
        layer.setSmooth(this.checkBoxSmooth.isSelected());
        return layer;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.radioButtonRoundedEdge = new JRadioButton();
        this.jLabel13 = new JLabel();
        this.noiseSettingsEditor1 = new NoiseSettingsEditor();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.checkBoxSmooth = new JCheckBox();
        this.labelWesterosCraftFeature = new JLabel();
        this.jLabel6 = new JLabel();
        this.mixedMaterialSelector1 = new MixedMaterialChooser();
        this.fieldName = new JTextField();
        this.jLabel7 = new JLabel();
        this.spinnerThickness = new JSpinner();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.radioButtonSheerEdge = new JRadioButton();
        this.radioButtonLinearEdge = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.radioButtonSmoothEdge = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel12 = new JLabel();
        this.spinnerEdgeWidth = new JSpinner();
        this.comboBoxLayerAnchor = new JComboBox();
        this.jLabel16 = new JLabel();
        this.paintPicker1 = new PaintPicker();
        this.buttonGroup1.add(this.radioButtonRoundedEdge);
        this.radioButtonRoundedEdge.setText("rounded");
        this.radioButtonRoundedEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroundCoverLayerEditor.this.radioButtonRoundedEdgeActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Variation:");
        this.jLabel1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/pepsoft/worldpainter/icons/edge_sheer.png")));
        this.jLabel3.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/pepsoft/worldpainter/icons/edge_linear.png")));
        this.jLabel8.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/pepsoft/worldpainter/icons/edge_smooth.png")));
        this.jLabel14.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/pepsoft/worldpainter/icons/edge_rounded.png")));
        this.jLabel15.setText(" ");
        this.checkBoxSmooth.setText("Smooth:");
        this.checkBoxSmooth.setHorizontalTextPosition(10);
        this.labelWesterosCraftFeature.setFont(new Font("Times New Roman", 1, 18));
        this.labelWesterosCraftFeature.setText("W ");
        this.jLabel6.setText("Name:");
        this.fieldName.setColumns(15);
        this.jLabel7.setText("Thickness:");
        this.spinnerThickness.setModel(new SpinnerNumberModel(1, -255, 255, 1));
        this.spinnerThickness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GroundCoverLayerEditor.this.spinnerThicknessStateChanged(evt);
            }
        });
        this.jLabel9.setText("(negative values will dig down into the terrain)");
        this.jLabel10.setText("Edge ");
        this.buttonGroup1.add(this.radioButtonSheerEdge);
        this.radioButtonSheerEdge.setSelected(true);
        this.radioButtonSheerEdge.setText("sheer");
        this.radioButtonSheerEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroundCoverLayerEditor.this.radioButtonSheerEdgeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonLinearEdge);
        this.radioButtonLinearEdge.setText("linear");
        this.radioButtonLinearEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroundCoverLayerEditor.this.radioButtonLinearEdgeActionPerformed(evt);
            }
        });
        this.jLabel11.setText("shape:");
        this.buttonGroup1.add(this.radioButtonSmoothEdge);
        this.radioButtonSmoothEdge.setText("smooth");
        this.radioButtonSmoothEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroundCoverLayerEditor.this.radioButtonSmoothEdgeActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Material:");
        this.jLabel4.setText("Paint:");
        this.jLabel12.setText("width:");
        this.spinnerEdgeWidth.setModel(new SpinnerNumberModel(1, 1, 255, 1));
        this.spinnerEdgeWidth.setEnabled(false);
        this.spinnerEdgeWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GroundCoverLayerEditor.this.spinnerEdgeWidthStateChanged(evt);
            }
        });
        this.comboBoxLayerAnchor.setModel(new DefaultComboBoxModel<String>(new String[]{"Bedrock", "Terrain", "Top of ground cover"}));
        this.comboBoxLayerAnchor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GroundCoverLayerEditor.this.comboBoxLayerAnchorActionPerformed(evt);
            }
        });
        this.jLabel16.setText("Layers relative to:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerThickness, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noiseSettingsEditor1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerEdgeWidth, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSheerEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonLinearEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSmoothEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRoundedEdge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paintPicker1, -2, -1, -2).addComponent(this.fieldName, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxSmooth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWesterosCraftFeature)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxLayerAnchor, -2, -1, -2)).addComponent(this.mixedMaterialSelector1, -2, -1, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.mixedMaterialSelector1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxLayerAnchor, -2, -1, -2).addComponent(this.jLabel16)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerThickness, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.noiseSettingsEditor1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.radioButtonSheerEdge).addComponent(this.radioButtonLinearEdge).addComponent(this.jLabel11).addComponent(this.radioButtonSmoothEdge).addComponent(this.radioButtonRoundedEdge).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.spinnerEdgeWidth, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.fieldName, -2, -1, -2).addComponent(this.checkBoxSmooth).addComponent(this.labelWesterosCraftFeature)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel15).addComponent(this.paintPicker1, -2, -1, -2))));
    }

    private void radioButtonRoundedEdgeActionPerformed(ActionEvent evt) {
        this.settingsChanged();
    }

    private void spinnerThicknessStateChanged(ChangeEvent evt) {
        this.settingsChanged();
    }

    private void radioButtonSheerEdgeActionPerformed(ActionEvent evt) {
        this.settingsChanged();
    }

    private void radioButtonLinearEdgeActionPerformed(ActionEvent evt) {
        this.settingsChanged();
    }

    private void radioButtonSmoothEdgeActionPerformed(ActionEvent evt) {
        this.settingsChanged();
    }

    private void spinnerEdgeWidthStateChanged(ChangeEvent evt) {
        this.settingsChanged();
    }

    private void comboBoxLayerAnchorActionPerformed(ActionEvent evt) {
        this.settingsChanged();
    }
}

