/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.combined;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeListCellRenderer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.AbstractLayerEditor;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.LayerTableCellRenderer;
import org.pepsoft.worldpainter.layers.combined.AddLayerDialog;
import org.pepsoft.worldpainter.layers.combined.CombinedLayerTableModel;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.renderers.PaintPicker;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.themes.JSpinnerTableCellEditor;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedLayerEditor
extends AbstractLayerEditor<CombinedLayer>
implements ListSelectionListener {
    private JButton buttonAddLayer;
    private JButton buttonEditLayerSettings;
    private JButton buttonRemoveLayer;
    private JCheckBox checkBoxApplyTerrainAndBiomeOnExport;
    private JComboBox<Integer> comboBoxBiome;
    private JComboBox<Terrain> comboBoxTerrain;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private PaintPicker paintPicker1;
    private JTable tableLayers;
    private CombinedLayerTableModel tableModel;
    private List<Layer> allLayers;
    private static final Logger logger = LoggerFactory.getLogger(CombinedLayerEditor.class);
    private static final long serialVersionUID = 1L;

    public CombinedLayerEditor() {
        this.initComponents();
        this.fieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CombinedLayerEditor.this.settingsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CombinedLayerEditor.this.settingsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CombinedLayerEditor.this.settingsChanged();
            }
        });
        this.tableLayers.getSelectionModel().addListSelectionListener(this);
        GUIUtils.scaleToUI((Container)this.tableLayers);
    }

    public CombinedLayer createLayer() {
        return new CombinedLayer("My Combined Layer", "A combined layer", (Object)Color.ORANGE);
    }

    public void setLayer(CombinedLayer layer) {
        super.setLayer((Layer)layer);
        this.reset();
    }

    public void commit() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        this.saveSettings((CombinedLayer)this.layer);
    }

    public void reset() {
        this.tableModel = new CombinedLayerTableModel(((CombinedLayer)this.layer).getLayers(), ((CombinedLayer)this.layer).getFactors());
        this.tableModel.addTableModelListener(e -> this.settingsChanged());
        this.configureTable();
        this.comboBoxTerrain.setSelectedItem(((CombinedLayer)this.layer).getTerrain());
        this.fieldName.setText(((CombinedLayer)this.layer).getName());
        this.paintPicker1.setPaint(((CombinedLayer)this.layer).getPaint());
        this.paintPicker1.setOpacity(((CombinedLayer)this.layer).getOpacity());
        this.comboBoxBiome.setSelectedItem(((CombinedLayer)this.layer).getBiome());
        this.checkBoxApplyTerrainAndBiomeOnExport.setSelected(((CombinedLayer)this.layer).isApplyTerrainAndBiomeOnExport());
        this.settingsChanged();
    }

    public ExporterSettings getSettings() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        final CombinedLayer previewLayer = this.saveSettings(null);
        return new ExporterSettings(){

            public boolean isApplyEverywhere() {
                return false;
            }

            public CombinedLayer getLayer() {
                return previewLayer;
            }

            public ExporterSettings clone() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    public void setContext(LayerEditor.LayerEditorContext context) {
        super.setContext(context);
        CustomBiomeManager customBiomeManager = context.getCustomBiomeManager();
        ColourScheme colourScheme = context.getColourScheme();
        Dimension dimension = context.getDimension();
        Platform platform = dimension.getWorld().getPlatform();
        this.comboBoxTerrain.setRenderer(new TerrainListCellRenderer(colourScheme, "none"));
        this.comboBoxBiome.setRenderer(new BiomeListCellRenderer(colourScheme, customBiomeManager, "none", platform));
        List allTerrains = CollectionUtils.listOf((List[])new List[]{Collections.singletonList(null), Arrays.asList(Terrain.getConfiguredValues())});
        this.comboBoxTerrain.setModel(new DefaultComboBoxModel<Terrain>(allTerrains.toArray(new Terrain[allTerrains.size()])));
        List allBiomes = CollectionUtils.listOf((List[])new List[]{Collections.singletonList(-1), BiomeUtils.getAllBiomes((Platform)platform, (CustomBiomeManager)customBiomeManager)});
        this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(allBiomes.toArray(new Integer[allBiomes.size()])));
        this.allLayers = context.getAllLayers();
        if (dimension.getAnchor().role == Dimension.Role.CAVE_FLOOR) {
            this.allLayers.removeIf(l -> !TunnelLayer.isLayerSupportedForCaveFloorDimension((Layer)l));
        } else if (dimension.getAnchor().role == Dimension.Role.FLOATING_FLOOR) {
            this.allLayers.removeIf(l -> !TunnelLayer.isLayerSupportedForFloatingFloorDimension((Layer)l));
        }
    }

    public boolean isCommitAvailable() {
        boolean terrainSelected = this.comboBoxTerrain.getSelectedItem() != null;
        boolean biomeSelected = this.comboBoxBiome.getSelectedItem() != null && (Integer)this.comboBoxBiome.getSelectedItem() != -1;
        int layersSelected = this.tableModel.getRowCount();
        boolean nameEntered = !this.fieldName.getText().trim().isEmpty();
        return nameEntered && (terrainSelected && biomeSelected || (terrainSelected || biomeSelected) && layersSelected > 0 || layersSelected > 1);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setControlStates();
    }

    private void setControlStates() {
        this.checkBoxApplyTerrainAndBiomeOnExport.setEnabled(this.comboBoxTerrain.getSelectedItem() != null || (Integer)this.comboBoxBiome.getSelectedItem() != -1);
        this.buttonRemoveLayer.setEnabled(this.tableLayers.getSelectedRowCount() == 1);
        this.buttonEditLayerSettings.setEnabled(this.tableLayers.getSelectedRowCount() == 1 && this.tableModel.getValueAt(this.tableLayers.getSelectedRow(), 0) instanceof CustomLayer);
    }

    private void addLayer() {
        ArrayList<Layer> availableLayers = new ArrayList<Layer>(this.allLayers.size());
        availableLayers.addAll(this.allLayers.stream().filter(availableLayer -> !availableLayer.equals((Object)this.layer) && !this.tableModel.contains((Layer)availableLayer)).collect(Collectors.toList()));
        AddLayerDialog dialog = new AddLayerDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), availableLayers);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.tableModel.addRow(new CombinedLayerTableModel.Row(dialog.getSelectedLayer(), dialog.getSelectedFactor(), dialog.isHiddenSelected()));
            this.settingsChanged();
        }
    }

    private void removeLayer() {
        int selectedRow;
        if (this.tableLayers.isEditing()) {
            this.tableLayers.getCellEditor().stopCellEditing();
        }
        if ((selectedRow = this.tableLayers.getSelectedRow()) != -1) {
            this.tableModel.deleteRow(selectedRow);
            this.settingsChanged();
        }
    }

    private void editLayerSettings() {
        int selectedRow;
        if (this.tableLayers.isEditing()) {
            this.tableLayers.getCellEditor().stopCellEditing();
        }
        if ((selectedRow = this.tableLayers.getSelectedRow()) != -1) {
            Layer layer = (Layer)this.tableModel.getValueAt(selectedRow, 0);
            if (layer instanceof CustomLayer) {
                App.getInstance().editCustomLayer((CustomLayer)layer, () -> {
                    this.tableLayers.repaint();
                    this.settingsChanged();
                });
            } else {
                logger.error("Selected layer is not a CustomLayer: " + layer);
            }
        }
    }

    private void settingsChanged() {
        this.context.settingsChanged();
    }

    private CombinedLayer saveSettings(CombinedLayer layer) {
        if (layer == null) {
            layer = this.createLayer();
        }
        layer.setName(this.fieldName.getText().trim());
        layer.setBiome(((Integer)this.comboBoxBiome.getSelectedItem()).intValue());
        layer.setTerrain((Terrain)this.comboBoxTerrain.getSelectedItem());
        layer.setApplyTerrainAndBiomeOnExport(this.checkBoxApplyTerrainAndBiomeOnExport.isSelected());
        this.tableModel.saveSettings(layer);
        layer.setPaint(this.paintPicker1.getPaint());
        layer.setOpacity(this.paintPicker1.getOpacity());
        return layer;
    }

    private void configureTable() {
        this.tableLayers.setModel(this.tableModel);
        TableColumn layerColumn = this.tableLayers.getColumnModel().getColumn(0);
        JComboBox<Layer> layerCellEditor = new JComboBox<Layer>(this.allLayers.toArray(new Layer[this.allLayers.size()]));
        layerCellEditor.setRenderer(new LayerListCellRenderer());
        layerColumn.setCellEditor(new DefaultCellEditor(layerCellEditor));
        layerColumn.setCellRenderer(new LayerTableCellRenderer());
        SpinnerNumberModel factorSpinnerModel = new SpinnerNumberModel(100, 1, 1500, 1);
        this.tableLayers.getColumnModel().getColumn(1).setCellEditor(new JSpinnerTableCellEditor(factorSpinnerModel));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboBoxTerrain = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboBoxBiome = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLayers = new JTable();
        this.buttonAddLayer = new JButton();
        this.jLabel5 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel6 = new JLabel();
        this.buttonRemoveLayer = new JButton();
        this.checkBoxApplyTerrainAndBiomeOnExport = new JCheckBox();
        this.buttonEditLayerSettings = new JButton();
        this.paintPicker1 = new PaintPicker();
        this.jLabel1.setText("Configure your combined layer on this screen.");
        this.jLabel2.setText("Terrain:");
        this.comboBoxTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CombinedLayerEditor.this.comboBoxTerrainActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Biome:");
        this.comboBoxBiome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CombinedLayerEditor.this.comboBoxBiomeActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Layers:");
        this.tableLayers.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.tableLayers);
        this.buttonAddLayer.setText("Add");
        this.buttonAddLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CombinedLayerEditor.this.buttonAddLayerActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Name:");
        this.fieldName.setColumns(20);
        this.jLabel6.setText("Paint:");
        this.buttonRemoveLayer.setText("Remove");
        this.buttonRemoveLayer.setEnabled(false);
        this.buttonRemoveLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CombinedLayerEditor.this.buttonRemoveLayerActionPerformed(evt);
            }
        });
        this.checkBoxApplyTerrainAndBiomeOnExport.setText("apply terrain and biome on Export");
        this.buttonEditLayerSettings.setText("Edit...");
        this.buttonEditLayerSettings.setEnabled(false);
        this.buttonEditLayerSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CombinedLayerEditor.this.buttonEditLayerSettingsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonEditLayerSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddLayer)).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrain, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome, -2, -1, -2)).addComponent(this.jLabel4).addComponent(this.checkBoxApplyTerrainAndBiomeOnExport).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paintPicker1, -2, -1, -2).addComponent(this.fieldName, -2, -1, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboBoxTerrain, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboBoxBiome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxApplyTerrainAndBiomeOnExport).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 27, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonAddLayer).addComponent(this.buttonRemoveLayer).addComponent(this.buttonEditLayerSettings)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.fieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.paintPicker1, -2, -1, -2))));
    }

    private void comboBoxTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.settingsChanged();
    }

    private void comboBoxBiomeActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.settingsChanged();
    }

    private void buttonAddLayerActionPerformed(ActionEvent evt) {
        this.addLayer();
    }

    private void buttonRemoveLayerActionPerformed(ActionEvent evt) {
        this.removeLayer();
    }

    private void buttonEditLayerSettingsActionPerformed(ActionEvent evt) {
        this.editLayerSettings();
    }
}

