/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.vecmath.Point3i;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.layers.bo2.OffsetViewer;
import org.pepsoft.worldpainter.objects.WPObject;

public class OffsetEditor
extends JDialog {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private OffsetViewer offsetViewer1;
    private JSpinner spinnerX;
    private JSpinner spinnerY;
    private JSpinner spinnerZ;
    private boolean cancelled = true;
    private static final long serialVersionUID = 1L;

    public OffsetEditor(Window parent, Point3i offset, WPObject object, ColourScheme colourScheme) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
        this.offsetViewer1.setObject(object);
        this.offsetViewer1.setOffset(offset);
        this.offsetViewer1.setColourScheme(colourScheme);
        this.spinnerX.setValue(offset.x);
        this.spinnerY.setValue(offset.y);
        this.spinnerZ.setValue(offset.z);
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OffsetEditor.this.dispose();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == 'l') {
                    OffsetEditor.this.offsetViewer1.rotateLeft();
                    e.consume();
                } else if (c == 'r') {
                    OffsetEditor.this.offsetViewer1.rotateRight();
                    e.consume();
                }
            }
        };
        ((JSpinner.DefaultEditor)this.spinnerX.getEditor()).getTextField().addKeyListener(listener);
        ((JSpinner.DefaultEditor)this.spinnerY.getEditor()).getTextField().addKeyListener(listener);
        ((JSpinner.DefaultEditor)this.spinnerZ.getEditor()).getTextField().addKeyListener(listener);
        this.buttonOK.addKeyListener(listener);
        this.buttonCancel.addKeyListener(listener);
        this.jTextArea1.addKeyListener(listener);
        this.rootPane.setDefaultButton(this.buttonOK);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Point3i getOffset() {
        return new Point3i(((Integer)this.spinnerX.getValue()).intValue(), ((Integer)this.spinnerY.getValue()).intValue(), ((Integer)this.spinnerZ.getValue()).intValue());
    }

    private void updateOffsetViewer() {
        this.offsetViewer1.setOffset(this.getOffset());
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.spinnerX = new JSpinner();
        this.jLabel3 = new JLabel();
        this.spinnerY = new JSpinner();
        this.jLabel4 = new JLabel();
        this.spinnerZ = new JSpinner();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.offsetViewer1 = new OffsetViewer();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Offset");
        this.jLabel2.setText("X axis (west to east):");
        this.spinnerX.setModel(new SpinnerNumberModel(0, -999, 999, 1));
        this.spinnerX.addChangeListener(this::spinnerXStateChanged);
        this.jLabel3.setText("Z axis (north to south):");
        this.spinnerY.setModel(new SpinnerNumberModel(0, -999, 999, 1));
        this.spinnerY.addChangeListener(this::spinnerYStateChanged);
        this.jLabel4.setText("Y axis (vertical):");
        this.spinnerZ.setModel(new SpinnerNumberModel(0, -999, 999, 1));
        this.spinnerZ.addChangeListener(this::spinnerZStateChanged);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(this::buttonCancelActionPerformed);
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(this::buttonOKActionPerformed);
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        GroupLayout offsetViewer1Layout = new GroupLayout(this.offsetViewer1);
        this.offsetViewer1.setLayout(offsetViewer1Layout);
        offsetViewer1Layout.setHorizontalGroup(offsetViewer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        offsetViewer1Layout.setVerticalGroup(offsetViewer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offsetViewer1, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offsetViewer1, -1, -1, Short.MAX_VALUE));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(this.jLabel2.getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText("The dotted square indicates the \"origin\" of the object; i.e. the block that will be placed directly on the surface at the location of the object. You can change it by adjusting the offset. The dotted line indicates ground level.\n\nRotate the object by pressing L or R.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerZ, -2, -1, -2).addComponent(this.spinnerY, -2, -1, -2).addComponent(this.spinnerX, -2, -1, -2))).addComponent(this.jTextArea1)).addGap(18, 18, 18).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.spinnerX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.spinnerZ, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jTextArea1, -2, 220, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.dispose();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void spinnerXStateChanged(ChangeEvent evt) {
        this.updateOffsetViewer();
    }

    private void spinnerYStateChanged(ChangeEvent evt) {
        this.updateOffsetViewer();
    }

    private void spinnerZStateChanged(ChangeEvent evt) {
        this.updateOffsetViewer();
    }
}

