/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.util.Box;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldFactory;
import org.pepsoft.worldpainter.dynmap.DynmapPreviewer;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.exporting.WorldPainterChunkFactory;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerManager;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.objects.MinecraftWorldObject;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.platforms.Java1_15PostProcessor;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerPreviewCreator {
    private Layer layer;
    private ExporterSettings settings;
    private int previewHeight = 128;
    private boolean subterranean;
    private Pattern pattern = CONSTANT_HALF_PLUS_GRADIENT_PLUS_HIGHLIGHT;
    private static final Logger logger = LoggerFactory.getLogger(LayerPreviewCreator.class);
    public static final Pattern CONSTANT_ONE_QUARTER = new Pattern("25%"){

        @Override
        float getStrength(int x, int y) {
            return 0.25f;
        }
    };
    public static final Pattern CONSTANT_HALF = new Pattern("50%"){

        @Override
        float getStrength(int x, int y) {
            return 0.5f;
        }
    };
    public static final Pattern CONSTANT_THREE_QUARTERS = new Pattern("75%"){

        @Override
        float getStrength(int x, int y) {
            return 0.75f;
        }
    };
    public static final Pattern CONSTANT_FULL = new Pattern("100%"){

        @Override
        float getStrength(int x, int y) {
            return 1.0f;
        }
    };
    public static final Pattern GRADIENT_ZERO_TO_FULL = new Pattern("100% - 0%"){

        @Override
        float getStrength(int x, int y) {
            return (float)x / 127.0f;
        }
    };
    public static final Pattern STEPPED_ZERO_TO_FULL = new Pattern("100% - 0% (hard edge)"){

        @Override
        float getStrength(int x, int y) {
            return MathUtils.getDistance((int)x, (int)y, (int)188, (int)64) < 128.0f ? 1.0f : 0.0f;
        }
    };
    public static final Pattern STEPPED_ZERO_TO_HALF = new Pattern("50% - 0% (hard edge)"){

        @Override
        float getStrength(int x, int y) {
            return MathUtils.getDistance((int)x, (int)y, (int)188, (int)64) < 128.0f ? 0.5f : 0.0f;
        }
    };
    public static final Pattern CIRCULAR_ZERO_TO_FULL = new Pattern("0% - 100% (circular)"){
        private final float MAX_DIST = (float)Math.sqrt(8192.0);

        @Override
        float getStrength(int x, int y) {
            return 1.0f - MathUtils.getDistance((int)(x - 64), (int)(y - 64)) / this.MAX_DIST;
        }
    };
    public static final Pattern CONSTANT_HALF_PLUS_GRADIENT_PLUS_HIGHLIGHT = new Pattern("50% - 50% - 0% (100% highlight)"){

        @Override
        float getStrength(int x, int y) {
            return Math.max(x < 64 ? (float)x / 127.0f : 0.5f, 1.0f - MathUtils.getDistance((int)(x - 64), (int)(127 - y)) / 64.0f);
        }
    };
    public static final Pattern CONSTANT_FULL_PLUS_GRADIENT = new Pattern("100% - 100% - 0%"){

        @Override
        float getStrength(int x, int y) {
            return x < 64 ? (float)x / 63.0f : 1.0f;
        }
    };
    public static final Pattern[] PATTERNS = new Pattern[]{CONSTANT_ONE_QUARTER, CONSTANT_HALF, CONSTANT_THREE_QUARTERS, CONSTANT_FULL, CONSTANT_HALF_PLUS_GRADIENT_PLUS_HIGHLIGHT, CONSTANT_FULL_PLUS_GRADIENT, GRADIENT_ZERO_TO_FULL, STEPPED_ZERO_TO_FULL, STEPPED_ZERO_TO_HALF, CIRCULAR_ZERO_TO_FULL};

    public MinecraftWorldObject renderPreview() {
        List<Object> layers;
        long timestamp = System.currentTimeMillis();
        long seed = 0L;
        HeightMapTileFactory tileFactory = this.subterranean ? TileFactoryFactory.createNoiseTileFactory((long)0L, (Terrain)Terrain.BARE_GRASS, (int)DefaultPlugin.JAVA_ANVIL_1_17.minZ, (int)this.previewHeight, (int)56, (int)62, (boolean)false, (boolean)true, (float)20.0f, (double)0.5) : TileFactoryFactory.createNoiseTileFactory((long)0L, (Terrain)Terrain.BARE_GRASS, (int)DefaultPlugin.JAVA_ANVIL_1_17.minZ, (int)this.previewHeight, (int)8, (int)14, (boolean)false, (boolean)true, (float)20.0f, (double)0.5);
        Dimension dimension = new World2(DefaultPlugin.JAVA_MCREGION, 0L, (TileFactory)tileFactory).getDimension(Dimension.Anchor.NORMAL_DETAIL);
        dimension.setSubsurfaceMaterial(Terrain.STONE);
        MinecraftWorldObject minecraftWorldObject = new MinecraftWorldObject(this.layer.getName() + " Preview", new Box(-8, 136, -8, 136, 0, this.previewHeight), this.previewHeight, tileFactory.getWaterHeight(), null, new Point3i(-64, -64, 0));
        long now = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Creating data structures took " + (now - timestamp) + " ms");
        }
        timestamp = now;
        Tile tile = tileFactory.createTile(0, 0);
        switch (this.layer.getDataSize()) {
            case BIT: {
                int y;
                Random random = new Random(0L);
                for (int x = 0; x < 128; ++x) {
                    for (y = 0; y < 128; ++y) {
                        if (!(random.nextFloat() < this.pattern.getStrength(x, y))) continue;
                        tile.setBitLayerValue(this.layer, x, y, true);
                    }
                }
                break;
            }
            case BIT_PER_CHUNK: {
                int y;
                Random random = new Random(0L);
                for (int x = 0; x < 128; x += 16) {
                    for (y = 0; y < 128; y += 16) {
                        if (!(random.nextFloat() < this.pattern.getStrength(x, y))) continue;
                        tile.setBitLayerValue(this.layer, x, y, true);
                    }
                }
                break;
            }
            case BYTE: {
                int y;
                for (int x = 0; x < 128; ++x) {
                    for (y = 0; y < 128; ++y) {
                        tile.setLayerValue(this.layer, x, y, Math.min((int)(this.pattern.getStrength(x, y) * 256.0f), 255));
                    }
                }
                break;
            }
            case NIBBLE: {
                int y;
                if (this.layer instanceof CombinedLayer && ((CombinedLayer)this.layer).getTerrain() != null && !((CombinedLayer)this.layer).isApplyTerrainAndBiomeOnExport()) {
                    Terrain terrain = ((CombinedLayer)this.layer).getTerrain();
                    for (int x = 0; x < 128; ++x) {
                        for (int y2 = 0; y2 < 128; ++y2) {
                            float strength = this.pattern.getStrength(x, y2);
                            tile.setLayerValue(this.layer, x, y2, Math.min((int)(strength * 16.0f), 15));
                            strength = Math.min(strength * 2.0f, 1.0f);
                            if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                            tile.setTerrain(x, y2, terrain);
                        }
                    }
                } else {
                    for (int x = 0; x < 128; ++x) {
                        for (y = 0; y < 128; ++y) {
                            tile.setLayerValue(this.layer, x, y, Math.min((int)(this.pattern.getStrength(x, y) * 16.0f), 15));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data size " + this.layer.getDataSize() + " encountered");
            }
        }
        if (this.layer instanceof CombinedLayer) {
            layers = new ArrayList();
            layers.add(this.layer);
            while (true) {
                ArrayList addedLayers = new ArrayList();
                Iterator<Object> i = layers.iterator();
                while (i.hasNext()) {
                    Layer tmpLayer = (Layer)i.next();
                    if (!(tmpLayer instanceof CombinedLayer)) continue;
                    i.remove();
                    addedLayers.addAll(((CombinedLayer)tmpLayer).apply(tile));
                }
                if (!addedLayers.isEmpty()) {
                    layers.addAll(addedLayers);
                    continue;
                }
                break;
            }
        } else {
            layers = Collections.singletonList(this.layer);
        }
        dimension.addTile(tile);
        now = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Applying layer(s) took " + (now - timestamp) + " ms");
        }
        HashMap<Layer, LayerExporter> pass1Exporters = new HashMap<Layer, LayerExporter>();
        HashMap<Layer, SecondPassLayerExporter> pass2Exporters = new HashMap<Layer, SecondPassLayerExporter>();
        Iterator<Object> tmpLayer = layers.iterator();
        while (tmpLayer.hasNext()) {
            Layer tmpLayer2;
            LayerExporter exporter = tmpLayer2.getExporter(dimension, DefaultPlugin.JAVA_ANVIL_1_17, (tmpLayer2 = (Layer)tmpLayer.next()).equals((Object)this.layer) ? this.settings : null);
            if (exporter instanceof FirstPassLayerExporter) {
                pass1Exporters.put(tmpLayer2, exporter);
            }
            if (!(exporter instanceof SecondPassLayerExporter)) continue;
            pass2Exporters.put(tmpLayer2, (SecondPassLayerExporter)exporter);
        }
        timestamp = now;
        WorldPainterChunkFactory chunkFactory = new WorldPainterChunkFactory(dimension, pass1Exporters, DefaultPlugin.JAVA_ANVIL_1_17, this.previewHeight);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                ChunkFactory.ChunkCreationResult chunkCreationResult = chunkFactory.createChunk(x, y);
                if (chunkCreationResult == null) continue;
                minecraftWorldObject.addChunk(chunkCreationResult.chunk);
            }
        }
        now = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Generating terrain and rendering first pass layer(s) (if any) took " + (now - timestamp) + " ms");
        }
        if (!pass2Exporters.isEmpty()) {
            timestamp = now;
            Rectangle area = new Rectangle(128, 128);
            for (SecondPassLayerExporter exporter : pass2Exporters.values()) {
                exporter.carve(area, area, (MinecraftWorld)minecraftWorldObject);
            }
            for (SecondPassLayerExporter exporter : pass2Exporters.values()) {
                exporter.addFeatures(area, area, (MinecraftWorld)minecraftWorldObject);
            }
            now = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Rendering second pass layer(s) took " + (now - timestamp) + " ms");
            }
        }
        timestamp = now;
        now = System.currentTimeMillis();
        try {
            new Java1_15PostProcessor().postProcess((MinecraftWorld)minecraftWorldObject, new Rectangle(-8, -8, 136, 136), null, null);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Post processing took " + (now - timestamp) + " ms");
        }
        return minecraftWorldObject;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public void setPreviewHeight(int previewHeight) {
        this.previewHeight = previewHeight;
    }

    public ExporterSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ExporterSettings settings) {
        this.settings = settings;
    }

    public boolean isSubterranean() {
        return this.subterranean;
    }

    public void setSubterranean(boolean subterranean) {
        this.subterranean = subterranean;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public static LayerPreviewCreator createPreviewerForLayer(Layer layer, Dimension dimension) {
        LayerPreviewCreator previewer = new LayerPreviewCreator();
        previewer.setLayer(layer);
        if (layer instanceof UndergroundPocketsLayer || layer instanceof Caverns || layer instanceof Chasms || layer instanceof TunnelLayer || layer.equals((Object)Resources.INSTANCE)) {
            previewer.setSubterranean(true);
            previewer.setPattern(CONSTANT_HALF);
        } else if (layer instanceof GroundCoverLayer) {
            previewer.setPattern(STEPPED_ZERO_TO_FULL);
        } else {
            previewer.setPattern(CONSTANT_HALF_PLUS_GRADIENT_PLUS_HIGHLIGHT);
        }
        return previewer;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Configuration config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        WPPluginManager.initialise((UUID)config.getUuid(), (WPContext)WPContext.INSTANCE);
        Dimension dimension = WorldFactory.createDefaultWorldWithoutTiles(config, 0L).getDimension(Dimension.Anchor.NORMAL_DETAIL);
        for (Layer layer : LayerManager.getInstance().getLayers()) {
            LayerPreviewCreator renderer = LayerPreviewCreator.createPreviewerForLayer(layer, dimension);
            long start = System.currentTimeMillis();
            MinecraftWorldObject preview = renderer.renderPreview();
            System.out.println("Total: " + (System.currentTimeMillis() - start) + " ms");
            DynmapPreviewer previewer = new DynmapPreviewer();
            previewer.setZoom(-2);
            previewer.setInclination(30.0);
            previewer.setAzimuth(60.0);
            if (layer instanceof Caverns || layer instanceof Chasms || layer instanceof TunnelLayer) {
                previewer.setCaves(true);
            }
            previewer.setObject((WPObject)preview, dimension);
            start = System.currentTimeMillis();
            BufferedImage image = previewer.createImage();
            System.out.println("Creating image took " + (System.currentTimeMillis() - start) + " ms");
            ImageIO.write((RenderedImage)image, "png", new File(layer.getName().toLowerCase().replaceAll("\\s", "") + "-preview.png"));
        }
    }

    public static abstract class Pattern {
        private final String description;

        protected Pattern(String description) {
            this.description = description;
        }

        abstract float getStrength(int var1, int var2);

        public String getDescription() {
            return this.description;
        }

        public BufferedImage getIcon() {
            BufferedImage icon = new BufferedImage(32, 32, 10);
            for (int x = 1; x < 31; ++x) {
                for (int y = 1; y < 31; ++y) {
                    int value = Math.min((int)(64.0f + this.getStrength(31 - x << 2, 31 - y << 2) * 192.0f), 255);
                    icon.setRGB(x, y, value << 16 | value << 8 | value);
                }
            }
            return icon;
        }
    }
}

