/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.dynmap.DynmapPreviewer;
import org.pepsoft.worldpainter.layers.AbstractEditLayerDialog;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.LayerEditorManager;
import org.pepsoft.worldpainter.layers.LayerPreviewCreator;
import org.pepsoft.worldpainter.layers.PatternListCellRenderer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.objects.MinecraftWorldObject;
import org.pepsoft.worldpainter.objects.WPObject;

public class EditLayerDialog<L extends Layer>
extends AbstractEditLayerDialog<L>
implements LayerEditor.LayerEditorContext,
ActionListener {
    private JButton buttonCancel;
    private JButton buttonOK;
    private DynmapPreviewer dynMapPreviewer1;
    private JPanel editorPanel;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JPanel panelButtons;
    private final LayerEditor<L> editor;
    private final Timer previewTimer = new Timer(1000, this);
    private final LayerPreviewCreator previewCreator;
    private final App app;
    private PreviewRenderState previewRenderState = PreviewRenderState.IDLE;
    private static final Object PREVIEW_STATE_LOCK = new Object();
    private static final Object PREVIEW_RENDERER_LOCK = new Object();

    public EditLayerDialog(Window parent, Platform platform, Class<L> layerType) {
        this(parent, null, LayerEditorManager.getInstance().createEditor(platform, layerType));
    }

    public EditLayerDialog(Window parent, Platform platform, L layer) {
        this(parent, layer, LayerEditorManager.getInstance().createEditor(platform, layer.getClass()));
    }

    private EditLayerDialog(Window parent, L layer, LayerEditor<L> editor) {
        super(parent);
        if (editor == null) {
            throw new IllegalArgumentException("No editor available for layer type" + (Serializable)(layer != null ? layer.getClass() : ""));
        }
        this.editor = editor;
        if (layer == null) {
            layer = editor.createLayer();
        }
        this.app = App.getInstance();
        this.previewCreator = LayerPreviewCreator.createPreviewerForLayer(layer, this.app.getDimension());
        this.initComponents();
        if (!(layer instanceof CustomLayer)) {
            this.setIconImage(layer.getIcon());
        }
        this.previewTimer.setRepeats(false);
        editor.setContext((LayerEditor.LayerEditorContext)this);
        editor.setLayer(layer);
        JComponent editorComponent = editor.getComponent();
        this.editorPanel.add((Component)editorComponent, "Center");
        SwingUtilities.updateComponentTreeUI(editorComponent);
        int index = 0;
        for (Component additionalButton : editor.getAdditionalButtons()) {
            this.panelButtons.add(additionalButton, index++);
        }
        this.buttonOK.setEnabled(editor.isCommitAvailable());
        this.jComboBox1.setModel(new DefaultComboBoxModel<LayerPreviewCreator.Pattern>(LayerPreviewCreator.PATTERNS));
        this.jComboBox1.setRenderer(new PatternListCellRenderer());
        this.jComboBox1.setSelectedItem(this.previewCreator.getPattern());
        this.dynMapPreviewer1.setZoom(-2);
        this.dynMapPreviewer1.setInclination(30.0);
        this.dynMapPreviewer1.setAzimuth(60.0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                EditLayerDialog.this.cancelPreviewUpdate();
            }
        });
        this.scaleToUI();
        this.pack();
        if (!(layer instanceof PlantLayer)) {
            this.scaleWindowToUI();
        }
        this.setLocationRelativeTo(parent);
        this.getRootPane().setDefaultButton(this.buttonOK);
    }

    @Override
    public L getLayer() {
        return (L)this.editor.getLayer();
    }

    public void settingsChanged() {
        boolean commitAvailable = this.editor.isCommitAvailable();
        this.buttonOK.setEnabled(commitAvailable);
        if (commitAvailable) {
            this.schedulePreviewUpdate();
        } else {
            this.cancelPreviewUpdate();
        }
    }

    public Dimension getDimension() {
        return this.app.getDimension();
    }

    public ColourScheme getColourScheme() {
        return this.app.getColourScheme();
    }

    public boolean isExtendedBlockIds() {
        return this.app.getWorld().isExtendedBlockIds();
    }

    public CustomBiomeManager getCustomBiomeManager() {
        return this.app.getCustomBiomeManager();
    }

    public List<Layer> getAllLayers() {
        return new ArrayList<Layer>(this.app.getAllLayers());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.previewTimer) {
            this.updatePreview();
        }
    }

    private void schedulePreviewUpdate() {
        this.previewTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPreviewUpdate() {
        this.previewTimer.stop();
        Object object = PREVIEW_STATE_LOCK;
        synchronized (object) {
            if (this.previewRenderState == PreviewRenderState.SECOND_RENDER_SCHEDULED) {
                this.previewRenderState = PreviewRenderState.RENDERING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreview() {
        if (!this.editor.isCommitAvailable()) {
            return;
        }
        final ExporterSettings settings = this.editor.getSettings();
        Object object = PREVIEW_STATE_LOCK;
        synchronized (object) {
            switch (this.previewRenderState) {
                case IDLE: {
                    new Thread("Preview Creator for " + this.editor.getLayer().getName()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block10: while (true) {
                                Object object = PREVIEW_RENDERER_LOCK;
                                synchronized (object) {
                                    EditLayerDialog.this.previewCreator.setLayer(settings.getLayer());
                                    EditLayerDialog.this.previewCreator.setSettings(settings);
                                    MinecraftWorldObject preview = EditLayerDialog.this.previewCreator.renderPreview();
                                    SwingUtilities.invokeLater(() -> EditLayerDialog.this.dynMapPreviewer1.setObject((WPObject)preview, EditLayerDialog.this.app.getDimension()));
                                }
                                object = PREVIEW_STATE_LOCK;
                                synchronized (object) {
                                    switch (EditLayerDialog.this.previewRenderState) {
                                        case SECOND_RENDER_SCHEDULED: {
                                            EditLayerDialog.this.previewRenderState = PreviewRenderState.RENDERING;
                                            break;
                                        }
                                        case RENDERING: {
                                            EditLayerDialog.this.previewRenderState = PreviewRenderState.IDLE;
                                        }
                                        default: {
                                            break block10;
                                        }
                                    }
                                }
                            }
                        }
                    }.start();
                    this.previewRenderState = PreviewRenderState.RENDERING;
                    break;
                }
                case RENDERING: {
                    this.previewRenderState = PreviewRenderState.SECOND_RENDER_SCHEDULED;
                    break;
                }
            }
        }
    }

    private void updatePattern() {
        this.previewCreator.setPattern((LayerPreviewCreator.Pattern)this.jComboBox1.getSelectedItem());
        this.schedulePreviewUpdate();
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.dynMapPreviewer1 = new DynmapPreviewer();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Layer Settings");
        this.editorPanel.setLayout(new BorderLayout());
        this.dynMapPreviewer1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Preview pattern:");
        this.panelButtons.setLayout(new FlowLayout(1, 5, 0));
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonOK);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonCancel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.editorPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dynMapPreviewer1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2)).addComponent(this.panelButtons, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent((Component)this.dynMapPreviewer1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addGap(12, 12, 12).addComponent(this.panelButtons, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.editor.commit();
        this.ok();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.updatePattern();
    }

    static enum PreviewRenderState {
        IDLE,
        RENDERING,
        SECOND_RENDER_SCHEDULED;

    }
}

