/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.bo2.Bo2LayerEditor;
import org.pepsoft.worldpainter.layers.combined.CombinedLayerEditor;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayerEditor;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.layers.plants.PlantLayerEditor;
import org.pepsoft.worldpainter.plugins.AbstractPlugin;
import org.pepsoft.worldpainter.plugins.LayerEditorProvider;

public class DefaultLayerEditorProvider
extends AbstractPlugin
implements LayerEditorProvider {
    public DefaultLayerEditorProvider() {
        super("DefaultLayerEditorProvider", Version.VERSION);
    }

    public <L extends Layer> LayerEditor<L> createLayerEditor(Platform platform, Class<L> layerType) {
        if (Bo2Layer.class.isAssignableFrom(layerType)) {
            return new Bo2LayerEditor();
        }
        if (CombinedLayer.class.isAssignableFrom(layerType)) {
            return new CombinedLayerEditor();
        }
        if (GroundCoverLayer.class.isAssignableFrom(layerType)) {
            return new GroundCoverLayerEditor(platform);
        }
        if (PlantLayer.class.isAssignableFrom(layerType)) {
            return new PlantLayerEditor();
        }
        return null;
    }
}

