/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import com.google.common.collect.ImmutableSet;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.importing.Mapping;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Layer;

public class MaskImporter {
    private final Dimension dimension;
    private final InputType inputType;
    private final double imageLowValue;
    private final double imageHighValue;
    private final double imageMaxValue;
    private final File imageFile;
    private final String unsupportedReason;
    private BufferedImage image;
    private boolean applyToTerrain;
    private boolean removeExistingLayer;
    private Layer applyToLayer;
    private Mapping mapping;
    private float scale;
    private int xOffset;
    private int yOffset;
    private double threshold = -1.0;
    private Integer applyToLayerValue;
    private Terrain applyToTerrainType;

    public MaskImporter(Dimension dimension, File imageFile, BufferedImage image) {
        this.dimension = dimension;
        this.imageFile = imageFile;
        this.image = image;
        int sampleSize = image.getSampleModel().getSampleSize(0);
        if (sampleSize == 1) {
            this.inputType = InputType.ONE_BIT_GREY_SCALE;
            this.imageMaxValue = 1.0;
            this.unsupportedReason = null;
        } else if (image.getColorModel().getColorSpace().getType() == 6) {
            block0 : switch (image.getRaster().getTransferType()) {
                case 4: {
                    this.inputType = InputType.FLOAT_GREY_SCALE;
                    this.imageMaxValue = 3.4028234663852886E38;
                    this.unsupportedReason = null;
                    break;
                }
                case 5: {
                    this.inputType = InputType.DOUBLE_GREY_SCALE;
                    this.imageMaxValue = Double.MAX_VALUE;
                    this.unsupportedReason = null;
                    break;
                }
                default: {
                    switch (sampleSize) {
                        case 8: {
                            this.inputType = InputType.EIGHT_BIT_GREY_SCALE;
                            this.imageMaxValue = 255.0;
                            this.unsupportedReason = null;
                            break block0;
                        }
                        case 16: {
                            this.inputType = InputType.SIXTEEN_BIT_GREY_SCALE;
                            this.imageMaxValue = 65535.0;
                            this.unsupportedReason = null;
                            break block0;
                        }
                        case 32: {
                            this.inputType = InputType.THIRTY_TWO_BIT_GREY_SCALE;
                            this.imageMaxValue = 4.294967295E9;
                            this.unsupportedReason = null;
                            break block0;
                        }
                    }
                    this.inputType = InputType.UNSUPPORTED;
                    this.imageMaxValue = -1.0;
                    this.unsupportedReason = "Grey scale images of " + sampleSize + " bits not yet supported";
                    break;
                }
            }
        } else {
            this.inputType = InputType.COLOUR;
            this.imageMaxValue = -1.0;
            this.unsupportedReason = null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = image.getRaster();
        switch (this.inputType) {
            case ONE_BIT_GREY_SCALE: {
                this.imageLowValue = 0.0;
                this.imageHighValue = 1.0;
                break;
            }
            case EIGHT_BIT_GREY_SCALE: 
            case SIXTEEN_BIT_GREY_SCALE: 
            case THIRTY_TWO_BIT_GREY_SCALE: {
                long lImageMaxValue = this.inputType == InputType.EIGHT_BIT_GREY_SCALE ? 255L : (this.inputType == InputType.SIXTEEN_BIT_GREY_SCALE ? 65535L : 0xFFFFFFFFL);
                long lImageLowValue = Integer.MAX_VALUE;
                long lImageHighValue = Integer.MIN_VALUE;
                block14: for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        long value = (long)raster.getSample(x, y, 0) & 0xFFFFFFFFL;
                        if (value < lImageLowValue) {
                            lImageLowValue = value;
                        }
                        if (value > lImageHighValue) {
                            lImageHighValue = value;
                        }
                        if (lImageLowValue == 0L && lImageHighValue == lImageMaxValue) break block14;
                    }
                }
                this.imageLowValue = lImageLowValue;
                this.imageHighValue = lImageHighValue;
                break;
            }
            case FLOAT_GREY_SCALE: 
            case DOUBLE_GREY_SCALE: {
                double dImageMaxValue = Double.MAX_VALUE;
                double dImageLowValue = Double.MAX_VALUE;
                double dImageHighValue = -1.7976931348623157E308;
                block16: for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        double value = raster.getSampleDouble(x, y, 0);
                        if (value < dImageLowValue) {
                            dImageLowValue = value;
                        }
                        if (value > dImageHighValue) {
                            dImageHighValue = value;
                        }
                        if (dImageLowValue <= 0.0 && dImageHighValue >= Double.MAX_VALUE) break block16;
                    }
                }
                this.imageLowValue = dImageLowValue;
                this.imageHighValue = dImageHighValue;
                break;
            }
            default: {
                this.imageLowValue = -1.0;
                this.imageHighValue = -1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        BitmapHeightMap scaledHeightMap;
        BufferedImage scaledImage;
        if (!this.applyToTerrain && this.applyToLayer == null) {
            throw new IllegalStateException("Target not set");
        }
        if (this.mapping == null) {
            throw new IllegalStateException("Mapping not set");
        }
        boolean colour = this.inputType == InputType.COLOUR;
        boolean bitmask = this.inputType == InputType.ONE_BIT_GREY_SCALE;
        boolean discrete = this.applyToTerrain && this.applyToTerrainType == null || this.applyToLayer != null && this.applyToLayer.discrete && this.applyToLayerValue == null;
        this.mapping.setThreshold(this.threshold);
        this.mapping.setMaskLowValue(this.imageLowValue);
        this.mapping.setMaskHighValue(this.imageHighValue);
        this.mapping.setMaskMaxValue(this.imageMaxValue);
        int oldWidth = this.image.getWidth();
        int oldHeight = this.image.getHeight();
        int width = Math.round((float)oldWidth * this.scale);
        int height = Math.round((float)oldHeight * this.scale);
        if (width == oldWidth && height == oldHeight) {
            scaledImage = this.image;
            scaledHeightMap = BitmapHeightMap.build().withImage(this.image).now();
        } else if (colour) {
            scaledImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = scaledImage.createGraphics();
            try {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(this.image, 0, 0, width, height, null);
            }
            finally {
                g2.dispose();
            }
            if (this.mapping instanceof Mapping.ColourToAnnotationsMapping && ((Mapping.ColourToAnnotationsMapping)this.mapping).dithered) {
                scaledImage = Mapping.ditherMask(scaledImage);
            }
            scaledHeightMap = null;
        } else {
            BitmapHeightMap heightMap = BitmapHeightMap.build().withImage(this.image).now();
            if (!bitmask && !discrete) {
                heightMap = heightMap.smoothed();
            }
            scaledHeightMap = heightMap.scaled(this.scale).clamped(this.imageLowValue, this.imageHighValue);
            scaledImage = null;
        }
        this.image = null;
        if (this.dimension.getWorld() != null) {
            this.dimension.getWorld().addHistoryEntry(22, new Serializable[]{this.dimension.getName(), this.imageFile, this.mapping.getAspect()});
        }
        int tileX1 = this.xOffset >> 7;
        int tileX2 = this.xOffset + width - 1 >> 7;
        int tileY1 = this.yOffset >> 7;
        int tileY2 = this.yOffset + height - 1 >> 7;
        int noOfTiles = (tileX2 - tileX1 + 1) * (tileY2 - tileY1 + 1);
        int tileCount = 0;
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = this.dimension.getTile(tileX, tileY);
                if (tile == null) {
                    ++tileCount;
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)tileCount / (float)noOfTiles);
                    continue;
                }
                tile.inhibitEvents();
                try {
                    int imageY;
                    int imageX;
                    int yInTile;
                    int xInTile;
                    int tileOffsetX = (tileX << 7) - this.xOffset;
                    int tileOffsetY = (tileY << 7) - this.yOffset;
                    if (this.applyToLayer != null && this.removeExistingLayer) {
                        if (tileX > tileX1 && tileX < tileX2 && tileY > tileY1 && tileY < tileY2) {
                            tile.clearLayerData(this.applyToLayer);
                        } else if (this.applyToLayer.dataSize.maxValue == 1) {
                            for (xInTile = 0; xInTile < 128; ++xInTile) {
                                for (yInTile = 0; yInTile < 128; ++yInTile) {
                                    imageX = tileOffsetX + xInTile;
                                    imageY = tileOffsetY + yInTile;
                                    if (imageX < 0 || imageX >= width || imageY < 0 || imageY >= height) continue;
                                    tile.setBitLayerValue(this.applyToLayer, xInTile, yInTile, false);
                                }
                            }
                        } else {
                            int defaultValue = this.applyToLayer.getDefaultValue();
                            for (int xInTile2 = 0; xInTile2 < 128; ++xInTile2) {
                                for (int yInTile2 = 0; yInTile2 < 128; ++yInTile2) {
                                    int imageX2 = tileOffsetX + xInTile2;
                                    int imageY2 = tileOffsetY + yInTile2;
                                    if (imageX2 < 0 || imageX2 >= width || imageY2 < 0 || imageY2 >= height) continue;
                                    tile.setLayerValue(this.applyToLayer, xInTile2, yInTile2, defaultValue);
                                }
                            }
                        }
                    }
                    this.mapping.setTile(tile);
                    if (colour) {
                        for (xInTile = 0; xInTile < 128; ++xInTile) {
                            for (yInTile = 0; yInTile < 128; ++yInTile) {
                                imageX = tileOffsetX + xInTile;
                                imageY = tileOffsetY + yInTile;
                                if (imageX < 0 || imageX >= width || imageY < 0 || imageY >= height) continue;
                                this.mapping.applyColour(xInTile, yInTile, scaledImage.getRGB(imageX, imageY));
                            }
                        }
                    } else if (discrete) {
                        for (xInTile = 0; xInTile < 128; ++xInTile) {
                            for (yInTile = 0; yInTile < 128; ++yInTile) {
                                imageX = tileOffsetX + xInTile;
                                imageY = tileOffsetY + yInTile;
                                if (imageX < 0 || imageX >= width || imageY < 0 || imageY >= height) continue;
                                this.mapping.applyDiscrete(xInTile, yInTile, (int)scaledHeightMap.getHeight(imageX, imageY));
                            }
                        }
                    } else {
                        for (xInTile = 0; xInTile < 128; ++xInTile) {
                            for (yInTile = 0; yInTile < 128; ++yInTile) {
                                imageX = tileOffsetX + xInTile;
                                imageY = tileOffsetY + yInTile;
                                if (imageX < 0 || imageX >= width || imageY < 0 || imageY >= height) continue;
                                this.mapping.applyGreyScale(xInTile, yInTile, scaledHeightMap.getHeight(imageX, imageY));
                            }
                        }
                    }
                }
                finally {
                    tile.releaseEvents();
                }
                ++tileCount;
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)tileCount / (float)noOfTiles);
            }
        }
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public boolean isSupported() {
        return this.inputType != InputType.UNSUPPORTED;
    }

    public String getScalingNotSupportedReason() {
        int imageType = this.image.getType();
        if (this.image.getColorModel() instanceof IndexColorModel && imageType != 12 && imageType != 13) {
            return "Scaling not supported for indexed images of type " + imageType;
        }
        return null;
    }

    public Layer getApplyToLayer() {
        return this.applyToLayer;
    }

    public void setApplyToLayer(Layer applyToLayer) {
        this.applyToLayer = applyToLayer;
        if (applyToLayer != null) {
            this.applyToTerrain = false;
        }
    }

    public Integer getApplyToLayerValue() {
        return this.applyToLayerValue;
    }

    public void setApplyToLayerValue(Integer applyToLayerValue) {
        this.applyToLayerValue = applyToLayerValue;
    }

    public boolean isApplyToTerrain() {
        return this.applyToTerrain;
    }

    public void setApplyToTerrain(boolean applyToTerrain) {
        this.applyToTerrain = applyToTerrain;
        if (applyToTerrain) {
            this.applyToLayer = null;
        }
    }

    public PossibleMappingsResult getPossibleMappings() {
        switch (this.inputType) {
            case ONE_BIT_GREY_SCALE: {
                if (this.applyToTerrain) {
                    if (this.applyToTerrainType != null) {
                        return new PossibleMappingsResult(Mapping.setTerrainValue(this.applyToTerrainType));
                    }
                    return new PossibleMappingsResult("Pick one terrain type to apply one-bit mask to");
                }
                if (this.applyToLayer == null) break;
                if (this.applyToLayer.discrete) {
                    if (this.applyToLayerValue != null) {
                        return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue));
                    }
                    return new PossibleMappingsResult("Pick one discrete layer value to apply one-bit mask to");
                }
                if (this.applyToLayer.getDataSize().maxValue == 1) {
                    return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, 1));
                }
                if (this.applyToLayerValue != null) {
                    return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue));
                }
                return new PossibleMappingsResult("Pick one layer intensity to apply one-bit mask to");
            }
            case EIGHT_BIT_GREY_SCALE: 
            case SIXTEEN_BIT_GREY_SCALE: 
            case THIRTY_TWO_BIT_GREY_SCALE: {
                if (this.applyToTerrain) {
                    if (this.applyToTerrainType != null) {
                        return new PossibleMappingsResult(Mapping.setTerrainValue(this.applyToTerrainType).ditheredActualRange(), Mapping.setTerrainValue(this.applyToTerrainType).ditheredFullRange(), Mapping.setTerrainValue(this.applyToTerrainType).threshold());
                    }
                    if (this.imageHighValue < (double)Terrain.VALUES.length) {
                        return new PossibleMappingsResult(Mapping.mapToTerrain());
                    }
                    return new PossibleMappingsResult("Mask contains values higher than the highest terrain type index (" + (Terrain.VALUES.length - 1) + ")");
                }
                if (this.applyToLayer == null) break;
                if (this.applyToLayer.discrete) {
                    if (this.applyToLayerValue != null) {
                        return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredActualRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredFullRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).threshold());
                    }
                    if (this.imageHighValue <= (double)this.applyToLayer.dataSize.maxValue) {
                        return new PossibleMappingsResult(Mapping.mapToLayer(this.applyToLayer));
                    }
                    return new PossibleMappingsResult("Mask contains values higher than the highest layer value (" + this.applyToLayer.dataSize.maxValue + ")");
                }
                if (this.applyToLayer.getDataSize().maxValue == 1) {
                    if (this.applyToLayer.getDataSize() == Layer.DataSize.BIT) {
                        return new PossibleMappingsResult(Mapping.mapToLayer(this.applyToLayer).ditheredActualRange(), Mapping.mapToLayer(this.applyToLayer).ditheredFullRange(), Mapping.mapToLayer(this.applyToLayer).threshold());
                    }
                    return new PossibleMappingsResult(Mapping.mapToLayer(this.applyToLayer).threshold());
                }
                if (this.applyToLayerValue != null) {
                    return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredActualRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredFullRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).threshold());
                }
                if (this.imageHighValue <= (double)this.applyToLayer.dataSize.maxValue) {
                    return new PossibleMappingsResult(Mapping.mapActualRangeToLayer(this.applyToLayer), Mapping.mapFullRangeToLayer(this.applyToLayer), Mapping.mapToLayer(this.applyToLayer));
                }
                return new PossibleMappingsResult(Mapping.mapActualRangeToLayer(this.applyToLayer), Mapping.mapFullRangeToLayer(this.applyToLayer));
            }
            case FLOAT_GREY_SCALE: 
            case DOUBLE_GREY_SCALE: {
                if (this.applyToTerrain) {
                    if (this.applyToTerrainType != null) {
                        return new PossibleMappingsResult(Mapping.setTerrainValue(this.applyToTerrainType).ditheredActualRange(), Mapping.setTerrainValue(this.applyToTerrainType).ditheredFullRange(), Mapping.setTerrainValue(this.applyToTerrainType).threshold());
                    }
                    return new PossibleMappingsResult("Pick one terrain type to apply floating point mask to");
                }
                if (this.applyToLayer == null) break;
                if (this.applyToLayer.discrete) {
                    if (this.applyToLayerValue != null) {
                        return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredActualRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredFullRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).threshold());
                    }
                    return new PossibleMappingsResult("Pick one discrete layer value type to apply floating point mask to");
                }
                if (this.applyToLayer.getDataSize().maxValue == 1) {
                    if (this.applyToLayer.getDataSize() == Layer.DataSize.BIT) {
                        return new PossibleMappingsResult(Mapping.mapToLayer(this.applyToLayer).ditheredActualRange(), Mapping.mapToLayer(this.applyToLayer).ditheredFullRange(), Mapping.mapToLayer(this.applyToLayer).threshold());
                    }
                    return new PossibleMappingsResult(Mapping.mapToLayer(this.applyToLayer).threshold());
                }
                if (this.applyToLayerValue != null) {
                    return new PossibleMappingsResult(Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredActualRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).ditheredFullRange(), Mapping.setLayerValue(this.applyToLayer, this.applyToLayerValue).threshold());
                }
                if (this.imageHighValue <= (double)this.applyToLayer.dataSize.maxValue) {
                    return new PossibleMappingsResult(Mapping.mapActualRangeToLayer(this.applyToLayer), Mapping.mapFullRangeToLayer(this.applyToLayer), Mapping.mapToLayer(this.applyToLayer));
                }
                return new PossibleMappingsResult(Mapping.mapActualRangeToLayer(this.applyToLayer), Mapping.mapFullRangeToLayer(this.applyToLayer));
            }
            case COLOUR: {
                if (Annotations.INSTANCE.equals((Object)this.applyToLayer) && this.applyToLayerValue == null) {
                    return new PossibleMappingsResult(Mapping.colourToAnnotations(), Mapping.colourToAnnotations().ditheredActualRange());
                }
                return new PossibleMappingsResult("Colour mask can only be applied to Annotations layer");
            }
            default: {
                return new PossibleMappingsResult("Bit depth or format of mask not supported");
            }
        }
        return new PossibleMappingsResult("No target selected");
    }

    public Terrain getApplyToTerrainType() {
        return this.applyToTerrainType;
    }

    public void setApplyToTerrainType(Terrain applyToTerrainType) {
        this.applyToTerrainType = applyToTerrainType;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = threshold;
    }

    public boolean isRemoveExistingLayer() {
        return this.removeExistingLayer;
    }

    public void setRemoveExistingLayer(boolean removeExistingLayer) {
        this.removeExistingLayer = removeExistingLayer;
    }

    public double getImageHighValue() {
        return this.imageHighValue;
    }

    public double getImageLowValue() {
        return this.imageLowValue;
    }

    public double getImageMaxValue() {
        return this.imageMaxValue;
    }

    public String getUnsupportedReason() {
        return this.unsupportedReason;
    }

    public static enum InputType {
        UNSUPPORTED,
        ONE_BIT_GREY_SCALE,
        EIGHT_BIT_GREY_SCALE,
        SIXTEEN_BIT_GREY_SCALE,
        THIRTY_TWO_BIT_GREY_SCALE,
        COLOUR,
        FLOAT_GREY_SCALE,
        DOUBLE_GREY_SCALE;

    }

    public static class PossibleMappingsResult {
        public final Set<Mapping> mappings;
        public final String reason;

        PossibleMappingsResult(Mapping ... mappings) {
            if (mappings == null || mappings.length == 0) {
                throw new IllegalArgumentException("mappings");
            }
            this.mappings = ImmutableSet.copyOf((Object[])mappings);
            this.reason = null;
        }

        PossibleMappingsResult(String reason) {
            if (reason == null || reason.trim().isEmpty()) {
                throw new IllegalArgumentException("reason");
            }
            this.reason = reason;
            this.mappings = Collections.emptySet();
        }
    }
}

