/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.ImportWarningsDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.importing.MapImporter;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.MapImporterProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapImportDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonOK;
    private JButton buttonSelectFile;
    private JCheckBox checkBoxImportEnd;
    private JCheckBox checkBoxImportNether;
    private JCheckBox checkBoxImportSurface;
    private JTextField fieldFilename;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel labelArea;
    private JLabel labelLength;
    private JLabel labelPlatform;
    private JLabel labelWidth;
    private JRadioButton radioButtonReadOnlyAll;
    private JRadioButton radioButtonReadOnlyManMade;
    private JRadioButton radioButtonReadOnlyManMadeAboveGround;
    private JRadioButton radioButtonReadOnlyNone;
    private final App app;
    private File previouslySelectedDir;
    private MapStatistics mapStatistics;
    private World2 importedWorld;
    private static final Logger logger = LoggerFactory.getLogger(MapImportDialog.class);
    private static final ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
    private static final NumberFormat FORMATTER = NumberFormat.getIntegerInstance();
    private static final long serialVersionUID = 1L;

    public MapImportDialog(App app) {
        super((Window)app);
        this.app = app;
        this.initComponents();
        this.resetStats();
        this.fieldFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MapImportDialog.this.checkSelection();
                MapImportDialog.this.setControlStates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MapImportDialog.this.checkSelection();
                MapImportDialog.this.setControlStates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MapImportDialog.this.checkSelection();
                MapImportDialog.this.setControlStates();
            }
        });
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setLocationRelativeTo(app);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MapImportDialog.this.selectDir();
            }
        });
    }

    public World2 getImportedWorld() {
        return this.importedWorld;
    }

    private void checkSelection() {
        File dir;
        String fileStr = this.fieldFilename.getText();
        if (!fileStr.trim().isEmpty() && (dir = new File(fileStr.trim())).isDirectory() && !dir.equals(this.previouslySelectedDir)) {
            this.previouslySelectedDir = dir;
            this.analyseMap();
        }
    }

    private void analyseMap() {
        BlockBasedPlatformProvider platformProvider;
        Set dimensions;
        this.mapStatistics = null;
        this.resetStats();
        final File worldDir = new File(this.fieldFilename.getText());
        PlatformManager platformManager = PlatformManager.getInstance();
        PlatformProvider.MapInfo mapInfo = platformManager.identifyMap(worldDir);
        if (mapInfo == null) {
            logger.error("Could not determine platform for " + worldDir);
            JOptionPane.showMessageDialog(this, "Could not determine map format for " + worldDir.getName(), "Unidentified Map Format", 0);
            return;
        }
        final Platform platform = mapInfo.platform;
        if (!mapInfo.platform.capabilities.contains(Platform.Capability.BLOCK_BASED)) {
            logger.error("Non block based platform " + platform + " not supported for " + worldDir);
            JOptionPane.showMessageDialog(this, "Non block based map format " + platform + " not (yet) supported", "Unsupported Map Format", 0);
            return;
        }
        if (!(platformManager.getPlatformProvider(platform) instanceof MapImporterProvider)) {
            logger.error("Platform provider for platform " + platform + " does not support importing");
            JOptionPane.showMessageDialog(this, "The plugin for map format " + platform + " does not support Importing existing maps", "Importing Not Supported", 0);
            return;
        }
        JavaLevel levelDat = null;
        if (DefaultPlugin.DEFAULT_JAVA_PLATFORMS.contains(platform)) {
            File levelDatFile = new File(worldDir, "level.dat");
            try {
                levelDat = JavaLevel.load((File)levelDatFile);
            }
            catch (IOException e) {
                logger.error("IOException while analysing map " + levelDatFile, (Throwable)e);
                JOptionPane.showMessageDialog(this, strings.getString("selected.file.is.not.a.valid.level.dat.file"), strings.getString("invalid.file"), 0);
                return;
            }
            catch (IllegalArgumentException e) {
                logger.error("IllegalArgumentException while analysing map " + levelDatFile, (Throwable)e);
                JOptionPane.showMessageDialog(this, strings.getString("selected.file.is.not.a.valid.level.dat.file"), strings.getString("invalid.file"), 0);
                return;
            }
            catch (NullPointerException e) {
                logger.error("NullPointerException while analysing map " + levelDatFile, (Throwable)e);
                JOptionPane.showMessageDialog(this, strings.getString("selected.file.is.not.a.valid.level.dat.file"), strings.getString("invalid.file"), 0);
                return;
            }
            int version = levelDat.getVersion();
            if (version == 0) {
                logger.error("Modded maps are not (yet) supported while analysing map " + levelDatFile);
                JOptionPane.showMessageDialog(this, "Modded maps are not (yet) supported for Importing", "Modded Map", 0);
                return;
            }
            if (version != 19132 && version != 19133) {
                logger.error("Unsupported Minecraft version while analysing map " + levelDatFile);
                JOptionPane.showMessageDialog(this, strings.getString("unsupported.minecraft.version"), strings.getString("unsupported.version"), 0);
                return;
            }
        }
        if (!(dimensions = Arrays.stream((platformProvider = (BlockBasedPlatformProvider)platformManager.getPlatformProvider(platform)).getDimensions(platform, worldDir)).boxed().collect(Collectors.toSet())).contains(0)) {
            logger.error("Map has no surface dimension: " + worldDir);
            JOptionPane.showMessageDialog(this, "This map has no surface dimension; this is not supported by WorldPainter", "Missing Surface Dimension", 0);
            return;
        }
        boolean netherPresent = dimensions.contains(1);
        boolean endPresent = dimensions.contains(2);
        this.checkBoxImportNether.setEnabled(netherPresent);
        this.checkBoxImportNether.setSelected(netherPresent);
        this.checkBoxImportEnd.setEnabled(endPresent);
        this.checkBoxImportEnd.setSelected(endPresent);
        this.mapStatistics = (MapStatistics)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<MapStatistics>(){

            public String getName() {
                return "Analyzing map...";
            }

            public MapStatistics execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                Set allChunkCoords;
                MapStatistics stats = new MapStatistics();
                try (ChunkStore chunkStore = platformProvider.getChunkStore(platform, worldDir, 0);){
                    allChunkCoords = chunkStore.getChunkCoords();
                }
                stats.chunkCount = allChunkCoords.size();
                for (MinecraftCoords chunkCoords : allChunkCoords) {
                    if (chunkCoords.x < stats.lowestChunkX) {
                        stats.lowestChunkX = chunkCoords.x;
                    }
                    if (chunkCoords.x > stats.highestChunkX) {
                        stats.highestChunkX = chunkCoords.x;
                    }
                    if (chunkCoords.z < stats.lowestChunkZ) {
                        stats.lowestChunkZ = chunkCoords.z;
                    }
                    if (chunkCoords.z <= stats.highestChunkZ) continue;
                    stats.highestChunkZ = chunkCoords.z;
                }
                progressReceiver.setProgress(1.0f);
                return stats;
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
        if (this.mapStatistics != null && this.mapStatistics.chunkCount > 0) {
            this.mapStatistics.dir = worldDir;
            this.mapStatistics.platform = platform;
            this.mapStatistics.levelDat = levelDat;
            this.labelPlatform.setIcon(mapInfo.icon);
            this.labelPlatform.setText(platform.displayName);
            int width = this.mapStatistics.highestChunkX - this.mapStatistics.lowestChunkX + 1;
            int length = this.mapStatistics.highestChunkZ - this.mapStatistics.lowestChunkZ + 1;
            int area = this.mapStatistics.chunkCount;
            this.labelWidth.setText(FORMATTER.format((long)width * 16L) + " blocks (from " + FORMATTER.format((long)this.mapStatistics.lowestChunkX << 4) + " to " + FORMATTER.format(((long)this.mapStatistics.highestChunkX << 4) + 15L) + "; " + FORMATTER.format(width) + " chunks)");
            this.labelLength.setText(FORMATTER.format((long)length * 16L) + " blocks (from " + FORMATTER.format((long)this.mapStatistics.lowestChunkZ << 4) + " to " + FORMATTER.format(((long)this.mapStatistics.highestChunkZ << 4) + 15L) + "; " + FORMATTER.format(length) + " chunks)");
            this.labelArea.setText(FORMATTER.format((long)area * 256L) + " blocks (" + FORMATTER.format(area) + " chunks)");
        }
    }

    private void setControlStates() {
        File dir;
        String dirStr = this.fieldFilename.getText().trim();
        File file = dir = !dirStr.isEmpty() ? new File(dirStr) : null;
        if (this.mapStatistics == null || this.mapStatistics.chunkCount == 0 || dir == null || !dir.isDirectory()) {
            this.buttonOK.setEnabled(false);
        } else {
            this.buttonOK.setEnabled(true);
        }
    }

    private void resetStats() {
        this.labelWidth.setText("0 blocks (from ? to ?; 0 chunks)");
        this.labelLength.setText("0 blocks (from ? to ?; 0 chunks)");
        this.labelArea.setText("0 blocks\u00b2 (0 chunks)");
    }

    private void selectDir() {
        PlatformProvider.MapInfo selectedMap = MapUtils.selectMap(this, this.previouslySelectedDir != null ? this.previouslySelectedDir.getParentFile() : null);
        if (selectedMap != null) {
            this.fieldFilename.setText(selectedMap.dir.getAbsolutePath());
        }
    }

    private void importWorld() {
        File worldDir = new File(this.fieldFilename.getText());
        final MapImporter.ReadOnlyOption readOnlyOption = this.radioButtonReadOnlyAll.isSelected() ? MapImporter.ReadOnlyOption.ALL : (this.radioButtonReadOnlyManMade.isSelected() ? MapImporter.ReadOnlyOption.MAN_MADE : (this.radioButtonReadOnlyManMadeAboveGround.isSelected() ? MapImporter.ReadOnlyOption.MAN_MADE_ABOVE_GROUND : MapImporter.ReadOnlyOption.NONE));
        this.app.clearWorld();
        this.importedWorld = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<World2>(){

            public String getName() {
                return strings.getString("importing.world");
            }

            public World2 execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                try {
                    int waterLevel;
                    int maxHeight;
                    int minHeight;
                    Platform platform = MapImportDialog.this.mapStatistics.platform;
                    JavaLevel levelDat = MapImportDialog.this.mapStatistics.levelDat;
                    if (levelDat != null) {
                        minHeight = levelDat.getMinHeight();
                        maxHeight = levelDat.getMaxHeight();
                        waterLevel = levelDat.getVersion() == 19132 ? maxHeight / 2 - 2 : 62;
                    } else {
                        minHeight = platform.minMinHeight;
                        maxHeight = platform.maxMaxHeight;
                        waterLevel = 62;
                    }
                    int terrainLevel = waterLevel - 4;
                    HeightMapTileFactory tileFactory = TileFactoryFactory.createNoiseTileFactory((long)0L, (Terrain)Terrain.GRASS, (int)minHeight, (int)maxHeight, (int)terrainLevel, (int)waterLevel, (boolean)false, (boolean)true, (float)20.0f, (double)1.0);
                    HashSet<Integer> dimensionsToImport = new HashSet<Integer>(3);
                    dimensionsToImport.add(0);
                    if (MapImportDialog.this.checkBoxImportNether.isSelected()) {
                        dimensionsToImport.add(1);
                    }
                    if (MapImportDialog.this.checkBoxImportEnd.isSelected()) {
                        dimensionsToImport.add(2);
                    }
                    MapImporter importer = ((MapImporterProvider)PlatformManager.getInstance().getPlatformProvider(platform)).getImporter(MapImportDialog.this.mapStatistics.dir, (TileFactory)tileFactory, null, readOnlyOption, dimensionsToImport);
                    World2 world = importer.doImport(progressReceiver);
                    if (importer.getWarnings() != null) {
                        try {
                            SwingUtilities.invokeAndWait(() -> {
                                DesktopUtils.beep();
                                ImportWarningsDialog warningsDialog = new ImportWarningsDialog((Window)MapImportDialog.this, strings.getString("import.warnings"), strings.getString("the.import.process.generated.warnings"));
                                warningsDialog.setWarnings(importer.getWarnings());
                                warningsDialog.setVisible(true);
                            });
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return world;
                }
                catch (IOException e) {
                    throw new RuntimeException("I/O error while importing world", e);
                }
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
        if (this.importedWorld == null) {
            this.cancel();
            return;
        }
        Configuration config = Configuration.getInstance();
        config.setSavesDirectory(worldDir.getParentFile());
        this.ok();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.fieldFilename = new JTextField();
        this.buttonSelectFile = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.labelWidth = new JLabel();
        this.jLabel4 = new JLabel();
        this.labelLength = new JLabel();
        this.jLabel7 = new JLabel();
        this.labelArea = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.radioButtonReadOnlyNone = new JRadioButton();
        this.radioButtonReadOnlyManMade = new JRadioButton();
        this.radioButtonReadOnlyAll = new JRadioButton();
        this.radioButtonReadOnlyManMadeAboveGround = new JRadioButton();
        this.checkBoxImportSurface = new JCheckBox();
        this.checkBoxImportNether = new JCheckBox();
        this.checkBoxImportEnd = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.labelPlatform = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Existing Minecraft Map");
        this.jLabel1.setText("Select an existing map:");
        this.buttonSelectFile.setText("...");
        this.buttonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapImportDialog.this.buttonSelectFileActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Statistics for surface:");
        this.jLabel3.setText("Width:");
        this.labelWidth.setText("0");
        this.jLabel4.setText("Length:");
        this.labelLength.setText("0");
        this.jLabel7.setText("Area:");
        this.labelArea.setText("0");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapImportDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.setEnabled(false);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapImportDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Options:");
        this.buttonGroup1.add(this.radioButtonReadOnlyNone);
        this.radioButtonReadOnlyNone.setText("do not mark any chunks read-only");
        this.buttonGroup1.add(this.radioButtonReadOnlyManMade);
        this.radioButtonReadOnlyManMade.setText("mark chunks containing man-made blocks read-only");
        this.buttonGroup1.add(this.radioButtonReadOnlyAll);
        this.radioButtonReadOnlyAll.setText("mark all chunks read-only");
        this.buttonGroup1.add(this.radioButtonReadOnlyManMadeAboveGround);
        this.radioButtonReadOnlyManMadeAboveGround.setSelected(true);
        this.radioButtonReadOnlyManMadeAboveGround.setText("<html>mark chunks containing man-made blocks <i>above ground</i> read-only</html>");
        this.checkBoxImportSurface.setSelected(true);
        this.checkBoxImportSurface.setText("Import Surface");
        this.checkBoxImportSurface.setEnabled(false);
        this.checkBoxImportNether.setText("Import Nether");
        this.checkBoxImportNether.setEnabled(false);
        this.checkBoxImportEnd.setText("Import End");
        this.checkBoxImportEnd.setEnabled(false);
        this.jLabel6.setText("Map format:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fieldFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectFile)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonReadOnlyManMadeAboveGround, -2, -1, -2).addComponent(this.radioButtonReadOnlyAll).addComponent(this.radioButtonReadOnlyManMade).addComponent(this.radioButtonReadOnlyNone).addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelLength)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWidth)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelArea))).addComponent(this.jLabel5).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxImportSurface).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxImportNether).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxImportEnd)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPlatform))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldFilename, -2, -1, -2).addComponent(this.buttonSelectFile)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.labelPlatform)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.labelWidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.labelLength)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.labelArea)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxImportSurface).addComponent(this.checkBoxImportNether).addComponent(this.checkBoxImportEnd)).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonReadOnlyNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonReadOnlyManMadeAboveGround, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonReadOnlyManMade).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonReadOnlyAll).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonSelectFileActionPerformed(ActionEvent evt) {
        this.selectDir();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.importWorld();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    static class MapStatistics {
        File dir;
        Platform platform;
        JavaLevel levelDat;
        int lowestChunkX = Integer.MAX_VALUE;
        int lowestChunkZ = Integer.MAX_VALUE;
        int highestChunkX = Integer.MIN_VALUE;
        int highestChunkZ = Integer.MIN_VALUE;
        int chunkCount;
        String errorMessage;

        MapStatistics() {
        }
    }
}

