/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.awt.Component;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.layers.CustomLayer;

public class CustomItemsTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ColourScheme colourScheme;
    private final Map<Object, Icon> icons = new IdentityHashMap<Object, Icon>();
    private final Map<Object, String> labels = new IdentityHashMap<Object, String>();

    public CustomItemsTreeCellRenderer(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value != null && !(value instanceof String)) {
            Icon icon = this.icons.get(value);
            String label = this.labels.get(value);
            if (icon == null) {
                if (value instanceof CustomLayer) {
                    icon = new ImageIcon(((CustomLayer)value).getIcon());
                    label = ((CustomLayer)value).getName();
                } else if (value instanceof MixedMaterial) {
                    icon = new ImageIcon(((MixedMaterial)value).getIcon(this.colourScheme));
                    label = ((MixedMaterial)value).getName();
                } else if (value instanceof CustomBiome) {
                    icon = IconUtils.createScaledColourIcon((int)((CustomBiome)value).getColour());
                    label = ((CustomBiome)value).getName();
                }
                this.icons.put(value, icon);
                this.labels.put(value, label);
            }
            this.setIcon(icon);
            this.setText(label);
        }
        return this;
    }
}

