/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.history;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.history.HistoryEntry;

public class WorldHistoryTableModel
implements TableModel {
    private final List<HistoryEntry> history;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final DateFormat dateFormatter = DateFormat.getDateInstance();
    private List<HistoryEntry> filteredHistory;
    private boolean includeLoadsSaves;
    private boolean includeExportsMerges = true;
    private static final String[] COLUMN_NAMES = new String[]{"Date", "User", "Action"};
    private static final Class[] COLUMN_TYPES = new Class[]{String.class, String.class, String.class};
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_USER = 1;
    private static final int COLUMN_ACTION = 2;

    public WorldHistoryTableModel(World2 world) {
        this.history = world.getHistory();
        this.filter();
    }

    public boolean isIncludeLoadsSaves() {
        return this.includeLoadsSaves;
    }

    public void setIncludeLoadsSaves(boolean includeLoadsSaves) {
        this.includeLoadsSaves = includeLoadsSaves;
        this.filter();
    }

    public boolean isIncludeExportsMerges() {
        return this.includeExportsMerges;
    }

    public void setIncludeExportsMerges(boolean includeExportsMerges) {
        this.includeExportsMerges = includeExportsMerges;
        this.filter();
    }

    @Override
    public int getRowCount() {
        return this.filteredHistory.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HistoryEntry entry = this.filteredHistory.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.dateFormatter.format(new Date(entry.timestamp));
            }
            case 1: {
                return entry.userId;
            }
            case 2: {
                return entry.getText();
            }
        }
        throw new IndexOutOfBoundsException("columnIndex");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    private void filter() {
        this.filteredHistory = this.history.stream().filter(entry -> this.includeLoadsSaves || entry.key != 7 && entry.key != 8).filter(entry -> this.includeExportsMerges || entry.key != 9 && entry.key != 10 && entry.key != 11 && entry.key != 12).collect(Collectors.toList());
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }
}

