/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class HeightMapTreeModel
implements TreeModel {
    private final HeightMap rootHeightMap;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public HeightMapTreeModel(HeightMap rootHeightMap) {
        this.rootHeightMap = rootHeightMap;
    }

    public void notifyListeners() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.rootHeightMap});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public Object getRoot() {
        return this.rootHeightMap;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof DelegatingHeightMap) {
            return ((DelegatingHeightMap)parent).getHeightMap(index);
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof DelegatingHeightMap) {
            return ((DelegatingHeightMap)parent).getHeightMapCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof DelegatingHeightMap);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DelegatingHeightMap) {
            return ((DelegatingHeightMap)parent).getIndex((HeightMap)child);
        }
        throw new IllegalArgumentException("Not a child of specified parent");
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }
}

