/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;
import org.pepsoft.worldpainter.heightMaps.DisplacementHeightMap;

public class HeightMapTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Border focusBorder = BorderFactory.createLineBorder(Color.RED);
    private HeightMap focusHeightMap;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof HeightMap) {
            DelegatingHeightMap parent;
            HeightMap heightMap = (HeightMap)value;
            String role = null;
            StringBuilder name = new StringBuilder();
            if (value instanceof AbstractHeightMap && (parent = ((AbstractHeightMap)value).getParent()) instanceof DisplacementHeightMap) {
                role = parent.getRole(parent.getIndex(heightMap));
                if (role.endsWith("HeightMap")) {
                    name.append(role.substring(0, role.length() - 9));
                } else if (role.endsWith("Map")) {
                    name.append(role.substring(0, role.length() - 3));
                } else {
                    name.append(role);
                }
            }
            if (heightMap.getName() != null) {
                if (name.length() > 0) {
                    name.append(": ");
                }
                name.append(heightMap.getName());
            }
            if (name.length() == 0) {
                name.append(heightMap.getClass().getSimpleName());
            }
            if (value == this.focusHeightMap) {
                this.setBorder(this.focusBorder);
            } else if (this.getBorder() != null) {
                this.setBorder(null);
            }
            this.setText(name.toString());
            this.setIcon(heightMap.getIcon());
            this.setToolTipText(this.getTooltipText(heightMap, role));
        }
        return this;
    }

    public HeightMap getFocusHeightMap() {
        return this.focusHeightMap;
    }

    public void setFocusHeightMap(HeightMap focusHeightMap) {
        this.focusHeightMap = focusHeightMap;
    }

    private String getTooltipText(HeightMap heightMap, String role) {
        String type;
        StringBuilder sb = new StringBuilder("<html>");
        String name = heightMap.getName();
        if (name != null) {
            sb.append("Name: <strong>").append(name).append("</strong><br>");
        }
        if ((type = heightMap.getClass().getSimpleName()).endsWith("HeightMap")) {
            type = type.substring(0, type.length() - 9);
        }
        sb.append("Type: <strong>").append(type).append("</strong><br>");
        if (role != null) {
            sb.append("Role: <strong>").append(role).append("</strong><br>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

