/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps.gui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.HeightMap;

public class HeightMapTileProvider
implements TileProvider {
    private final HeightMap heightMap;
    private final ThreadLocal<BufferedImage> renderBufferRef = new ThreadLocal<BufferedImage>(){

        @Override
        protected BufferedImage initialValue() {
            return new BufferedImage(128, 128, 10);
        }
    };
    private int zoom = 0;

    public HeightMapTileProvider(HeightMap heightMap) {
        if (heightMap == null) {
            throw new NullPointerException();
        }
        this.heightMap = heightMap;
    }

    public HeightMap getHeightMap() {
        return this.heightMap;
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isTilePresent(int x, int y) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image tileImage, int x, int y, int imageX, int imageY) {
        BufferedImage image = this.renderBufferRef.get();
        WritableRaster raster = image.getRaster();
        double vertScale = 255.0 / this.heightMap.getRange()[1];
        if (this.zoom < 0) {
            int scale = -this.zoom;
            int xOffset = x << 7 << scale;
            int yOffset = y << 7 << scale;
            for (int dx = 0; dx < 128; ++dx) {
                for (int dy = 0; dy < 128; ++dy) {
                    raster.setSample(dx, dy, 0, MathUtils.clamp((long)0L, (long)Math.round(this.heightMap.getHeight(xOffset + (dx << scale), yOffset + (dy << scale)) * vertScale), (long)255L));
                }
            }
        } else {
            int xOffset = x << 7;
            int yOffset = y << 7;
            for (int dx = 0; dx < 128; ++dx) {
                for (int dy = 0; dy < 128; ++dy) {
                    raster.setSample(dx, dy, 0, MathUtils.clamp((long)0L, (long)Math.round(this.heightMap.getHeight(xOffset + dx, yOffset + dy) * vertScale), (long)255L));
                }
            }
        }
        Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
        try {
            g2.drawImage((Image)image, imageX, imageY, null);
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    public int getTilePriority(int x, int y) {
        return 0;
    }

    public Rectangle getExtent() {
        return null;
    }

    public void addTileListener(TileListener tileListener) {
    }

    public void removeTileListener(TileListener tileListener) {
    }

    public boolean isZoomSupported() {
        return true;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom != this.zoom) {
            if (zoom > 0) {
                throw new UnsupportedOperationException("Zooming in not supported");
            }
            this.zoom = zoom;
        }
    }
}

