/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import org.pepsoft.worldpainter.Platform;

public abstract class ImportPreset {
    private final String description;
    public static final ImportPreset FULL_RANGE_0_BASED = new ImportPreset("Full range; from 0"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                return new Mapping(imageLow, imageHigh, 0, maxHeight - 1);
            }
            return new Mapping(0.0, imageHigh, 0, maxHeight - 1);
        }
    };
    public static final ImportPreset FULL_RANGE_MINUS_64_BASED = new ImportPreset("Full range; from -64"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                return new Mapping(imageLow, imageHigh, -64, maxHeight - 1);
            }
            return new Mapping(0.0, imageHigh, -64, maxHeight - 1);
        }
    };
    public static final ImportPreset WORLDPAINTER_LOW_RES_0_BASED = new ImportPreset("One to one (e.g. low res WorldPainter export); from 0"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                return new Mapping(imageLow, Math.min(imageMaxHeight, (double)maxHeight) - 1.0 + imageLow, 0, Math.min((int)Math.round(imageMaxHeight), maxHeight) - 1);
            }
            return new Mapping(0.0, Math.min(imageMaxHeight, (double)maxHeight) - 1.0, 0, Math.min((int)Math.round(imageMaxHeight), maxHeight) - 1);
        }
    };
    public static final ImportPreset WORLDPAINTER_HIGH_RES_0_BASED = new ImportPreset("256 to one (e.g. high res WorldPainter export); from 0"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                long worldHighOut = Math.round(imageHigh - imageLow) >> 8;
                long imageHighOut = worldHighOut << 8;
                while ((double)imageHighOut < imageMaxHeight - 256.0 && Math.round((double)imageHighOut + imageLow) >> 8 < (long)(maxHeight - 1)) {
                    imageHighOut += 256L;
                }
                return new Mapping(imageLow, (double)imageHighOut + imageLow, 0, (int)(imageHighOut >> 8));
            }
            long imageHighOut = (long)(maxHeight - 1) << 8;
            while ((double)imageHighOut >= imageMaxHeight) {
                imageHighOut -= 256L;
            }
            return new Mapping(0.0, imageHighOut, 0, (int)(imageHighOut >> 8));
        }
    };
    public static final ImportPreset WORLDPAINTER_LOW_RES_MINUS_64_BASED = new ImportPreset("One to one (e.g. low res WorldPainter export); from -64"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                return new Mapping(imageLow, Math.min(imageMaxHeight, (double)maxHeight) - 1.0 + imageLow, -64, Math.min((int)Math.round(imageMaxHeight), maxHeight - 64) - 1);
            }
            return new Mapping(0.0, Math.min(imageMaxHeight, (double)maxHeight) - 1.0, -64, Math.min((int)Math.round(imageMaxHeight), maxHeight - 64) - 1);
        }
    };
    public static final ImportPreset WORLDPAINTER_HIGH_RES_MINUS_64_BASED = new ImportPreset("256 to one (e.g. high res WorldPainter export); from -64"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            if (imageLow < 0.0) {
                long worldHighOut = (Math.round(imageHigh - imageLow) >> 8) - 64L;
                long imageHighOut = worldHighOut << 8;
                while ((double)imageHighOut < imageMaxHeight - 256.0 && Math.round((double)imageHighOut + imageLow) >> 8 < (long)(maxHeight + 63)) {
                    imageHighOut += 256L;
                }
                return new Mapping(imageLow, (double)imageHighOut + imageLow, -64, (int)((imageHighOut >> 8) - 64L));
            }
            long imageHighOut = (long)(maxHeight + 63) << 8;
            while ((double)imageHighOut >= imageMaxHeight) {
                imageHighOut -= 256L;
            }
            return new Mapping(0.0, imageHighOut, -64, (int)((imageHighOut >> 8) - 64L));
        }
    };
    public static final ImportPreset FLOATING_POINT_MINUS_64_BASED = new ImportPreset("Normalised floating point range; from -64"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            return new Mapping(0.0, 1.0, -64, maxHeight - 1);
        }

        @Override
        public boolean isValid(double imageMinHeight, double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int minHeight, int maxHeight) {
            return imageLow >= 0.0 && imageHigh <= 1.0 && super.isValid(imageMinHeight, imageMaxHeight, imageLow, imageHigh, platform, minHeight, maxHeight);
        }
    };
    public static final ImportPreset FLOATING_POINT_0_BASED = new ImportPreset("Normalised floating point range; from 0"){

        @Override
        public Mapping getMapping(double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int maxHeight) {
            return new Mapping(0.0, 1.0, 0, maxHeight - 1);
        }

        @Override
        public boolean isValid(double imageMinHeight, double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int minHeight, int maxHeight) {
            return imageLow >= 0.0 && imageHigh <= 1.0 && super.isValid(imageMinHeight, imageMaxHeight, imageLow, imageHigh, platform, minHeight, maxHeight);
        }
    };
    public static final ImportPreset[] PRESETS = new ImportPreset[]{FLOATING_POINT_0_BASED, FLOATING_POINT_MINUS_64_BASED, FULL_RANGE_0_BASED, FULL_RANGE_MINUS_64_BASED, WORLDPAINTER_HIGH_RES_0_BASED, WORLDPAINTER_LOW_RES_0_BASED, WORLDPAINTER_HIGH_RES_MINUS_64_BASED, WORLDPAINTER_LOW_RES_MINUS_64_BASED};

    private ImportPreset(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public boolean isValid(double imageMinHeight, double imageMaxHeight, double imageLow, double imageHigh, Platform platform, int minHeight, int maxHeight) {
        Mapping mapping = this.getMapping(imageMaxHeight, imageLow, imageHigh, platform, maxHeight);
        int lowWorldValue = this.getWorldValue(imageLow, mapping);
        int highWorldValue = this.getWorldValue(imageHigh, mapping);
        return mapping.imageLow >= imageMinHeight && mapping.imageHigh < imageMaxHeight && mapping.worldLow >= minHeight && mapping.worldHigh < maxHeight && lowWorldValue >= minHeight && highWorldValue < maxHeight && highWorldValue != lowWorldValue;
    }

    public abstract Mapping getMapping(double var1, double var3, double var5, Platform var7, int var8);

    private int getWorldValue(double imageValue, Mapping mapping) {
        return (int)Math.round((imageValue - mapping.imageLow) * mapping.levelScale + (double)mapping.worldLow);
    }

    public static class Mapping {
        public final double imageLow;
        public final double imageHigh;
        public final double levelScale;
        public final int worldLow;
        public final int worldHigh;

        public Mapping(double imageLow, double imageHigh, int worldLow, int worldHigh) {
            this.imageLow = imageLow;
            this.imageHigh = imageHigh;
            this.worldLow = worldLow;
            this.worldHigh = worldHigh;
            this.levelScale = (double)(worldHigh - worldLow) / (imageHigh - imageLow);
        }
    }
}

