/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dnd;

import com.google.common.collect.ImmutableSet;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPTransferHandler
extends TransferHandler {
    private final App app;
    private static final Logger logger = LoggerFactory.getLogger(WPTransferHandler.class);
    private static final Set<String> IMAGE_FILE_EXTENSIONS = ImmutableSet.copyOf((Object[])ImageIO.getReaderFileSuffixes());

    public WPTransferHandler(App app) {
        this.app = app;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        if (!support.isDrop()) {
            return false;
        }
        if ((1 & support.getSourceDropActions()) != 1) {
            return false;
        }
        support.setDropAction(1);
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            String extension;
            List list = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (list.size() > 1) {
                MessageUtils.beepAndShowError((Component)this.app, (String)"Please drag only one file at a time.", (String)"Multiple Files");
                return false;
            }
            File file = (File)list.get(0);
            String name = file.getName();
            int p = name.lastIndexOf(46);
            String string = extension = p != -1 ? name.substring(p + 1).toLowerCase() : null;
            if (!"world".equals(extension) && !IMAGE_FILE_EXTENSIONS.contains(extension)) {
                MessageUtils.beepAndShowError((Component)this.app, (String)"The file is not a WorldPainter .world file or image file.", (String)"Unsupported File");
                return false;
            }
            try {
                if (IMAGE_FILE_EXTENSIONS.contains(extension)) {
                    int action = JOptionPane.showOptionDialog(this.app, "An image file was dropped on WorldPainter.\nSelect how you would like to import it:", "Select Image Import Action", -1, 3, null, new String[]{"New World", "Height Map", "Mask", "Cancel"}, "Cancel");
                    switch (action) {
                        case 0: {
                            this.app.importHeightMap(file);
                            break;
                        }
                        case 1: {
                            this.app.importHeightMapIntoCurrentDimension(file);
                            break;
                        }
                        case 2: {
                            this.app.importMask(file);
                        }
                    }
                } else {
                    this.app.open(file, true);
                }
            }
            catch (RuntimeException e) {
                ExceptionHandler.handleException(e, this.app);
                return false;
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException e) {
            logger.error("{} while obtaining drag and drop transfer data", (Object)e.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }
}

