/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.brushes;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import org.pepsoft.worldpainter.brushes.AbstractBrush;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.brushes.SymmetricBrush;

public final class RotatedBrush
extends AbstractBrush {
    private Brush brush;
    private int radius;
    private int effectiveRadius;
    private int degrees;
    private int effectiveWidth;
    private int effectiveHeight;
    private float level;
    private Raster fullStrengthCache;

    private RotatedBrush(Brush brush, int degrees) {
        super(brush.getName());
        this.brush = brush;
        this.degrees = degrees;
        this.radius = brush.getRadius();
        this.level = brush.getLevel();
        this.cacheAllStrengths();
    }

    public Brush getBrush() {
        return this.brush;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public void setDegrees(int degrees) {
        if (degrees != this.degrees) {
            this.degrees = degrees;
            this.cacheAllStrengths();
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        if (radius != this.radius) {
            this.radius = radius;
            this.brush.setRadius(radius);
            this.cacheAllStrengths();
        }
    }

    public int getEffectiveRadius() {
        return this.effectiveRadius;
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        if (level != this.level) {
            this.level = level;
            this.brush.setLevel(level);
            if (this.fullStrengthCache == null) {
                this.cacheAllStrengths();
            }
        }
    }

    public BrushShape getBrushShape() {
        return this.brush.getBrushShape();
    }

    public float getStrength(int dx, int dy) {
        int x = dx + this.effectiveRadius;
        int y = dy + this.effectiveRadius;
        if (x < 0 || x >= this.effectiveWidth || y < 0 || y >= this.effectiveHeight) {
            return 0.0f;
        }
        if (this.level == 1.0f) {
            return (float)this.fullStrengthCache.getSample(x, y, 0) / 255.0f;
        }
        return (float)this.fullStrengthCache.getSample(x, y, 0) / 255.0f * this.level;
    }

    public float getFullStrength(int dx, int dy) {
        int x = dx + this.effectiveRadius;
        int y = dy + this.effectiveRadius;
        if (x < 0 || x >= this.effectiveWidth || y < 0 || y >= this.effectiveHeight) {
            return 0.0f;
        }
        return (float)this.fullStrengthCache.getSample(x, y, 0) / 255.0f;
    }

    public RotatedBrush clone() {
        RotatedBrush clone = (RotatedBrush)super.clone();
        clone.brush = this.brush.clone();
        return clone;
    }

    private void cacheAllStrengths() {
        int d = this.radius * 2 + 1;
        byte[] rasterData = new byte[d * d];
        for (int dx = -this.radius; dx <= this.radius; ++dx) {
            for (int dy = -this.radius; dy <= this.radius; ++dy) {
                rasterData[dx + this.radius + (dy + this.radius) * d] = (byte)(this.brush.getFullStrength(dx, dy) * 255.0f);
            }
        }
        DataBufferByte imageDataBuffer = new DataBufferByte(rasterData, d * d);
        Raster raster = Raster.createRaster(new SinglePixelPackedSampleModel(0, d, d, new int[]{255}), imageDataBuffer, new Point(0, 0));
        double a = (double)this.degrees / 180.0 * Math.PI;
        AffineTransformOp transformOp = new AffineTransformOp(AffineTransform.getRotateInstance(a), 3);
        Rectangle2D transformedBounds = transformOp.getBounds2D(raster);
        AffineTransform transform = AffineTransform.getTranslateInstance(-transformedBounds.getX(), -transformedBounds.getY());
        transform.rotate(a);
        transformOp = new AffineTransformOp(transform, 3);
        this.fullStrengthCache = transformOp.filter(raster, null);
        this.effectiveWidth = this.fullStrengthCache.getWidth();
        this.effectiveHeight = this.fullStrengthCache.getHeight();
        this.effectiveRadius = this.effectiveWidth / 2;
    }

    public static Brush rotate(Brush brush, int degrees) {
        if ((degrees = Math.floorMod(degrees, 360)) == 0) {
            return brush;
        }
        if (brush instanceof RotatedBrush) {
            int adjustedDegrees = Math.floorMod(((RotatedBrush)brush).degrees + degrees, 360);
            if (adjustedDegrees == 0) {
                return ((RotatedBrush)brush).brush;
            }
            return new RotatedBrush(((RotatedBrush)brush).brush, adjustedDegrees);
        }
        if (brush instanceof SymmetricBrush && ((SymmetricBrush)brush).isRotationallySymmetric()) {
            return brush;
        }
        return new RotatedBrush(brush, degrees);
    }
}

