/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.pepsoft.util.IconUtils;

public class SimpleBrowser
extends JDialog
implements HyperlinkListener {
    private final Action backAction = new AbstractAction("back", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/resultset_previous.png")){
        private static final long serialVersionUID = 1L;
        {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SimpleBrowser.this.historyPointer > 0) {
                --SimpleBrowser.this.historyPointer;
                String url = SimpleBrowser.this.history.get(SimpleBrowser.this.historyPointer);
                try {
                    SimpleBrowser.this.jEditorPane1.setPage(url);
                    if (SimpleBrowser.this.historyPointer == 0) {
                        this.setEnabled(false);
                    }
                    SimpleBrowser.this.forwardAction.setEnabled(true);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(SimpleBrowser.this, "I/O error loading page " + url, "Error Loading Page", 0);
                }
            }
        }
    };
    private final Action forwardAction = new AbstractAction("forward", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/resultset_next.png")){
        private static final long serialVersionUID = 1L;
        {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SimpleBrowser.this.historyPointer < SimpleBrowser.this.historySize - 1) {
                ++SimpleBrowser.this.historyPointer;
                String url = SimpleBrowser.this.history.get(SimpleBrowser.this.historyPointer);
                try {
                    SimpleBrowser.this.jEditorPane1.setPage(url);
                    if (SimpleBrowser.this.historyPointer == SimpleBrowser.this.historySize - 1) {
                        this.setEnabled(false);
                    }
                    SimpleBrowser.this.backAction.setEnabled(true);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(SimpleBrowser.this, "I/O error loading page " + url, "Error Loading Page", 0);
                }
            }
        }
    };
    private JEditorPane jEditorPane1;
    private JScrollPane jScrollPane1;
    private final List<String> history = new ArrayList<String>();
    private int historySize;
    private int historyPointer;
    private ActionListener actionListener;
    private static final long serialVersionUID = 1L;

    public SimpleBrowser(Frame parent, boolean modal, String title, String initialUrl) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(title);
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.jEditorPane1.setEditorKit(htmlEditorKit);
        try {
            this.jEditorPane1.setPage(initialUrl);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading page", e);
        }
        this.jEditorPane1.addHyperlinkListener(this);
        this.history.add(initialUrl);
        this.historySize = 1;
        this.historyPointer = 0;
        this.setLocationRelativeTo(parent);
    }

    public Action getBackAction() {
        return this.backAction;
    }

    public Action getForwardAction() {
        return this.forwardAction;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL().getProtocol().equals("action") && this.actionListener != null) {
            ActionEvent event = new ActionEvent(this, 1001, e.getURL().getFile());
            this.actionListener.actionPerformed(event);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Simple Browser");
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setFont(new Font("Dialog", 0, 15));
        this.jEditorPane1.addHyperlinkListener(this::jEditorPane1HyperlinkUpdate);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    private void jEditorPane1HyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = evt.getURL();
            try {
                this.jEditorPane1.setPage(url);
                if (this.historyPointer == this.historySize - 1) {
                    this.history.add(url.toExternalForm());
                    ++this.historyPointer;
                    ++this.historySize;
                } else {
                    ++this.historyPointer;
                    this.history.set(this.historyPointer, url.toExternalForm());
                    this.historySize = this.historyPointer + 1;
                }
                this.backAction.setEnabled(true);
                this.forwardAction.setEnabled(false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "I/O error loading page " + url, "Error Loading Page", 0);
            }
        }
    }
}

