/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class BiomeHelper {
    private final CustomBiomeManager customBiomeManager;
    private final ColourScheme colourScheme;
    private final BiomeScheme biomeScheme;
    private final boolean showIds;
    private final String[][] names = new String[255][2];
    private final Icon[] icons = new Icon[256];

    public BiomeHelper(ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Platform platform) {
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.showIds = !platform.capabilities.contains(Platform.Capability.NAMED_BIOMES);
        this.biomeScheme = BiomeUtils.getBiomeScheme((Platform)platform);
    }

    public String getBiomeName(int biomeID) {
        if (biomeID == 255) {
            return "Auto";
        }
        return this.getBiomeNames(biomeID)[1];
    }

    public String getBiomeNameWithoutId(int biomeID) {
        if (biomeID == 255) {
            return "Auto";
        }
        return this.getBiomeNames(biomeID)[0];
    }

    private String[] getBiomeNames(int biomeID) {
        if (this.names[biomeID][0] == null) {
            if (this.biomeScheme.isBiomePresent(biomeID)) {
                this.names[biomeID][0] = this.biomeScheme.getBiomeName(biomeID);
                this.names[biomeID][1] = this.showIds ? this.names[biomeID][0] + " (" + biomeID + ")" : this.names[biomeID][0];
            } else if (this.customBiomeManager != null) {
                for (CustomBiome customBiome : this.customBiomeManager.getCustomBiomes()) {
                    if (customBiome.getId() != biomeID) continue;
                    this.names[biomeID][0] = customBiome.getName();
                    this.names[biomeID][1] = this.showIds ? this.names[biomeID][0] + " (" + biomeID + ")" : this.names[biomeID][0];
                    break;
                }
            }
            if (this.names[biomeID][0] == null) {
                this.names[biomeID][0] = "Biome " + biomeID;
                this.names[biomeID][1] = this.names[biomeID][0];
            }
        }
        return this.names[biomeID];
    }

    public Icon getBiomeIcon(int biomeID) {
        if (this.icons[biomeID] == null) {
            if (this.biomeScheme.isBiomePresent(biomeID)) {
                this.icons[biomeID] = new ImageIcon(BiomeSchemeManager.createImage((BiomeScheme)this.biomeScheme, (int)biomeID, (ColourScheme)this.colourScheme));
            } else if (this.customBiomeManager != null) {
                for (CustomBiome customBiome : this.customBiomeManager.getCustomBiomes()) {
                    if (customBiome.getId() != biomeID) continue;
                    this.icons[biomeID] = IconUtils.createScaledColourIcon((int)customBiome.getColour());
                    break;
                }
            }
        }
        return this.icons[biomeID];
    }
}

