/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Version;

public class WorldPainterModalFrame
extends JFrame {
    private final Window owner;
    private boolean cancelled = true;
    private volatile boolean open;
    private static final long serialVersionUID = 1L;

    public WorldPainterModalFrame(Window owner) {
        this(owner, true);
    }

    public WorldPainterModalFrame(final Window owner, boolean enableHelpKey) {
        this.owner = owner;
        this.setIconImage(App.ICON);
        if (owner instanceof App) {
            ((App)owner).reset3DViewAlwaysOnTop();
            ((App)owner).pauseAutosave();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ((App)owner).resumeAutosave();
                }
            });
        }
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldPainterModalFrame.this.cancel();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        if (enableHelpKey) {
            this.getRootPane().putClientProperty("org.pepsoft.worldpainter.helpKey", "Dialog/" + this.getClass().getSimpleName());
            actionMap.put("help", new AbstractAction("help"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    App.getInstance().showHelp(WorldPainterModalFrame.this);
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(112, 0), "help");
        }
    }

    public void setVisible(final Runnable okCallback) {
        if (this.open) {
            throw new IllegalStateException("Window is already open");
        }
        this.open = true;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorldPainterModalFrame.this.owner.setEnabled(true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                WorldPainterModalFrame.this.owner.setEnabled(true);
                WorldPainterModalFrame.this.owner.toFront();
                if (!WorldPainterModalFrame.this.cancelled) {
                    okCallback.run();
                }
                WorldPainterModalFrame.this.open = false;
            }
        });
        super.setVisible(true);
        this.owner.setEnabled(false);
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public Window getOwner() {
        return this.owner;
    }

    @Override
    public void setVisible(boolean b) {
        throw new UnsupportedOperationException("Use setVisible(Runnable)");
    }

    @Override
    public void setTitle(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        if (Version.isSnapshot()) {
            sb.append(" [SNAPSHOT]");
        }
        if (Configuration.getInstance().isSafeMode()) {
            sb.append(" [SAFE MODE]");
        }
        super.setTitle(sb.toString());
    }

    protected void ok() {
        this.cancelled = false;
        this.owner.setEnabled(true);
        this.dispose();
    }

    protected void cancel() {
        this.owner.setEnabled(true);
        this.dispose();
    }

    protected final void scaleToUI() {
        GUIUtils.scaleToUI((Container)this);
    }

    protected final void scaleWindowToUI() {
        GUIUtils.scaleWindow((Window)this);
    }
}

