/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Version;

public class WorldPainterDialog
extends JDialog {
    private boolean cancelled = true;
    private static final long serialVersionUID = 1L;

    public WorldPainterDialog(Window parent) {
        this(parent, true);
    }

    public WorldPainterDialog(final Window parent, boolean enableHelpKey) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        if (parent instanceof App) {
            ((App)parent).reset3DViewAlwaysOnTop();
            ((App)parent).pauseAutosave();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ((App)parent).resumeAutosave();
                }
            });
        }
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldPainterDialog.this.cancel();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        if (enableHelpKey) {
            this.getRootPane().putClientProperty("org.pepsoft.worldpainter.helpKey", "Dialog/" + this.getClass().getSimpleName());
            actionMap.put("help", new AbstractAction("help"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    App.getInstance().showHelp(WorldPainterDialog.this);
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(112, 0), "help");
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setTitle(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        if (Version.isSnapshot()) {
            sb.append(" [SNAPSHOT]");
        }
        if (Configuration.getInstance().isSafeMode()) {
            sb.append(" [SAFE MODE]");
        }
        super.setTitle(sb.toString());
    }

    protected void ok() {
        this.cancelled = false;
        this.dispose();
    }

    protected void cancel() {
        this.dispose();
    }

    protected final void scaleToUI() {
        GUIUtils.scaleToUI((Container)this);
    }

    protected final void scaleWindowToUI() {
        GUIUtils.scaleWindow((Window)this);
    }
}

