/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.io.Serializable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorldFactory {
    private static final Logger logger = LoggerFactory.getLogger(WorldFactory.class);

    private WorldFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static World2 createDefaultWorld(Configuration config, long seed) {
        if (config.isDefaultCircularWorld()) {
            logger.info("Creating default circular world with {} tiles diameter (approximately {} tiles total)", (Object)config.getDefaultWidth(), (Object)((int)Math.round(Math.PI * (double)config.getDefaultWidth() / 2.0 * (double)config.getDefaultWidth() / 2.0)));
        } else {
            logger.info("Creating default world of {} by {} tiles ({} tiles total)", new Object[]{config.getDefaultWidth(), config.getDefaultHeight(), config.getDefaultWidth() * config.getDefaultHeight()});
        }
        World2 world = WorldFactory.createDefaultWorldWithoutTiles(config, seed);
        boolean circularWorld = config.isDefaultCircularWorld();
        int radius = config.getDefaultWidth() * 64;
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        TileFactory tileFactory = dim0.getTileFactory();
        dim0.setEventsInhibited(true);
        try {
            if (circularWorld) {
                int tileRadius = (radius + 127) / 128;
                for (int x = -tileRadius; x < tileRadius; ++x) {
                    for (int y = -tileRadius; y < tileRadius; ++y) {
                        if (!(MathUtils.getSmallestDistanceFromOrigin((int)x, (int)y) < (float)radius)) continue;
                        Tile tile = tileFactory.createTile(x, y);
                        dim0.addTile(tile);
                        if (!(MathUtils.getLargestDistanceFromOrigin((int)x, (int)y) >= (float)radius)) continue;
                        for (int xx = 0; xx < 128; ++xx) {
                            for (int yy = 0; yy < 128; ++yy) {
                                float distance = org.pepsoft.util.MathUtils.getDistance((float)((float)(x * 128 + xx) + 0.5f), (float)((float)(y * 128 + yy) + 0.5f));
                                if (!(distance > (float)radius)) continue;
                                tile.setBitLayerValue((Layer)Void.INSTANCE, xx, yy, true);
                            }
                        }
                    }
                }
                if (dim0.getBorder() != null && dim0.getBorder().isEndless()) {
                    dim0.setBorder(Dimension.Border.ENDLESS_VOID);
                    dim0.setBorderSize(0);
                } else {
                    dim0.setBorder(Dimension.Border.VOID);
                    dim0.setBorderSize(2);
                }
                dim0.setWallType(null);
            } else {
                int width = config.getDefaultWidth();
                int height = config.getDefaultHeight();
                int startX = -width / 2;
                int startY = -height / 2;
                for (int x = startX; x < startX + width; ++x) {
                    for (int y = startY; y < startY + height; ++y) {
                        Tile tile = tileFactory.createTile(x, y);
                        dim0.addTile(tile);
                    }
                }
            }
        }
        finally {
            dim0.setEventsInhibited(false);
        }
        return world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static World2 createDefaultWorldWithoutTiles(Configuration config, long seed) {
        Platform platform = config.getDefaultPlatform();
        HeightMapTileFactory tileFactory = config.isHilly() ? TileFactoryFactory.createNoiseTileFactory((long)seed, (Terrain)config.getSurface(), (int)platform.minZ, (int)config.getDefaultMaxHeight(), (int)config.getLevel(), (int)config.getWaterLevel(), (boolean)config.isLava(), (boolean)config.isBeaches(), (float)config.getDefaultRange(), (double)config.getDefaultScale()) : TileFactoryFactory.createFlatTileFactory((long)seed, (Terrain)config.getSurface(), (int)platform.minZ, (int)config.getDefaultMaxHeight(), (int)config.getLevel(), (int)config.getWaterLevel(), (boolean)config.isLava(), (boolean)config.isBeaches());
        Dimension defaults = config.getDefaultTerrainAndLayerSettings();
        if (defaults.getTileFactory() instanceof HeightMapTileFactory && ((HeightMapTileFactory)defaults.getTileFactory()).getTheme() instanceof SimpleTheme && ((SimpleTheme)((HeightMapTileFactory)defaults.getTileFactory()).getTheme()).getTerrainRanges() != null) {
            HeightMapTileFactory defaultTileFactory = (HeightMapTileFactory)defaults.getTileFactory();
            SimpleTheme defaultTheme = (SimpleTheme)defaultTileFactory.getTheme();
            SimpleTheme theme = (SimpleTheme)tileFactory.getTheme();
            theme.setTerrainRanges(new TreeMap(defaultTheme.getTerrainRanges()));
            theme.setRandomise(defaultTheme.isRandomise());
        }
        World2 world = new World2(platform, 27594263L, (TileFactory)tileFactory);
        world.addHistoryEntry(3, new Serializable[0]);
        ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
        world.setName(strings.getString("generated.world"));
        world.setCreateGoodiesChest(config.isDefaultCreateGoodiesChest());
        world.setMapFeatures(config.isDefaultMapFeatures());
        world.setGameType(config.getDefaultGameType());
        world.setAllowCheats(config.isDefaultAllowCheats());
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        dim0.setEventsInhibited(true);
        try {
            dim0.setBorder(defaults.getBorder());
            dim0.setBorderSize(defaults.getBorderSize());
            dim0.setWallType(defaults.getWallType());
            dim0.setRoofType(defaults.getRoofType());
            dim0.setBorderLevel(defaults.getBorderLevel());
            dim0.setSubsurfaceMaterial(defaults.getSubsurfaceMaterial());
            dim0.setPopulate(defaults.isPopulate());
            for (Map.Entry entry : defaults.getAllLayerSettings().entrySet()) {
                dim0.setLayerSettings((Layer)entry.getKey(), ((ExporterSettings)entry.getValue()).clone());
            }
            ((ResourcesExporter.ResourcesExporterSettings)dim0.getLayerSettings((Layer)Resources.INSTANCE)).setMinimumLevel(config.getDefaultResourcesMinimumLevel());
            dim0.setGridEnabled(config.isDefaultGridEnabled());
            dim0.setGridSize(config.getDefaultGridSize());
            dim0.setContoursEnabled(config.isDefaultContoursEnabled());
            dim0.setContourSeparation(config.getDefaultContourSeparation());
            dim0.setTopLayerMinDepth(defaults.getTopLayerMinDepth());
            dim0.setTopLayerVariation(defaults.getTopLayerVariation());
            dim0.setBottomless(defaults.isBottomless());
            dim0.setCoverSteepTerrain(defaults.isCoverSteepTerrain());
            dim0.setGenerator(config.getDefaultGenerator());
            dim0.setExportSettings(config.getDefaultExportSettings());
        }
        finally {
            dim0.setEventsInhibited(false);
        }
        return world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static World2 createFancyWorld(Configuration config, long seed) {
        Platform platform = config.getDefaultPlatform();
        HeightMapTileFactory tileFactory = TileFactoryFactory.createFancyTileFactory((long)seed, (Terrain)Terrain.GRASS, (int)platform.minZ, (int)platform.standardMaxHeight, (int)58, (int)62, (boolean)false, (float)20.0f, (double)1.0);
        Dimension defaults = config.getDefaultTerrainAndLayerSettings();
        World2 world = new World2(platform, 27594263L, (TileFactory)tileFactory);
        world.addHistoryEntry(3, new Serializable[0]);
        world.setMixedMaterial(0, new MixedMaterial("Dirt/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.DIRT, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
        world.setMixedMaterial(1, new MixedMaterial("Stone/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.STONE, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
        ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
        world.setName(strings.getString("generated.world"));
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        if (config.getDefaultMaxHeight() == 256) {
            dim0.setGenerator((MapGenerator)new SeededGenerator(Generator.LARGE_BIOMES, 27594263L));
        }
        boolean circularWorld = true;
        int radius = 750;
        dim0.setEventsInhibited(true);
        try {
            int tileRadius = 6;
            for (int x = -6; x < 6; ++x) {
                for (int y = -6; y < 6; ++y) {
                    if (!(MathUtils.getSmallestDistanceFromOrigin((int)x, (int)y) < 750.0f)) continue;
                    Tile tile = tileFactory.createTile(x, y);
                    dim0.addTile(tile);
                }
            }
            dim0.setBorderLevel(defaults.getBorderLevel());
            dim0.setSubsurfaceMaterial(defaults.getSubsurfaceMaterial());
            dim0.setPopulate(defaults.isPopulate());
            for (Map.Entry entry : defaults.getAllLayerSettings().entrySet()) {
                dim0.setLayerSettings((Layer)entry.getKey(), ((ExporterSettings)entry.getValue()).clone());
            }
            ((ResourcesExporter.ResourcesExporterSettings)dim0.getLayerSettings((Layer)Resources.INSTANCE)).setMinimumLevel(config.getDefaultResourcesMinimumLevel());
            FrostExporter.FrostSettings frostSettings = (FrostExporter.FrostSettings)dim0.getLayerSettings((Layer)Frost.INSTANCE);
            if (frostSettings == null) {
                frostSettings = new FrostExporter.FrostSettings();
            }
            frostSettings.setMode(3);
            dim0.setLayerSettings((Layer)Frost.INSTANCE, (ExporterSettings)frostSettings);
            dim0.setGridEnabled(config.isDefaultGridEnabled());
            dim0.setGridSize(config.getDefaultGridSize());
            dim0.setContoursEnabled(config.isDefaultContoursEnabled());
            dim0.setContourSeparation(config.getDefaultContourSeparation());
            dim0.setTopLayerMinDepth(defaults.getTopLayerMinDepth());
            dim0.setTopLayerVariation(defaults.getTopLayerVariation());
            dim0.setBottomless(defaults.isBottomless());
        }
        finally {
            dim0.setEventsInhibited(false);
        }
        return world;
    }
}

