/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.util.Set;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.tools.Eyedropper;

public class WPDialogWithPaintSelection
extends WorldPainterDialog {
    private Eyedropper.SelectionListener selectFromMapListener;
    private Set<Eyedropper.PaintType> selectFromMapTypes;
    private Runnable okCallback;
    protected final App app;

    public WPDialogWithPaintSelection(Window parent) {
        this(parent, true);
    }

    public WPDialogWithPaintSelection(Window parent, boolean enableHelpKey) {
        super(parent, enableHelpKey);
        this.app = parent instanceof App ? (App)parent : null;
    }

    public void setVisible() {
        this.setVisible(null);
    }

    public void setVisible(final Runnable okCallback) {
        this.okCallback = okCallback;
        super.setVisible(true);
        if (this.selectFromMapListener != null) {
            this.app.selectPaintOnMap(this.selectFromMapTypes, new Eyedropper.SelectionListener(){

                @Override
                public void terrainSelected(Terrain terrain) {
                    WPDialogWithPaintSelection.this.selectFromMapListener.terrainSelected(terrain);
                    this.showAgain();
                }

                @Override
                public void layerSelected(Layer layer, int value) {
                    WPDialogWithPaintSelection.this.selectFromMapListener.layerSelected(layer, value);
                    this.showAgain();
                }

                @Override
                public void selectionCancelled(boolean byUser) {
                    if (byUser) {
                        this.showAgain();
                    } else {
                        DesktopUtils.beep();
                        WPDialogWithPaintSelection.this.cancel();
                    }
                }

                private void showAgain() {
                    WPDialogWithPaintSelection.this.selectFromMapListener = null;
                    WPDialogWithPaintSelection.this.setVisible(okCallback);
                }
            });
        }
    }

    @Override
    @Deprecated
    public void setVisible(boolean b) {
        throw new UnsupportedOperationException("Use setVisible(Runnable)");
    }

    @Override
    protected void ok() {
        super.ok();
        if (this.okCallback != null) {
            this.okCallback.run();
        }
    }

    protected final void selectFromMap(Set<Eyedropper.PaintType> paintTypes, Eyedropper.SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new NullPointerException("selectionListener");
        }
        if (this.selectFromMapListener != null) {
            throw new IllegalStateException("Map selection already in progress");
        }
        if (this.app == null) {
            throw new IllegalArgumentException("Parent is not of type App");
        }
        this.selectFromMapListener = selectionListener;
        this.selectFromMapTypes = paintTypes;
        super.setVisible(false);
    }
}

